/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.api.energy;

import java.text.NumberFormat;
import javax.annotation.Nonnull;
import sonar.fluxnetworks.common.util.FluxUtils;

public enum EnergyType {
    FE("Forge Energy", "FE", "FE/t"),
    EU("Energy Unit", "EU", "EU/t");

    private final String name;
    private final String storage;
    private final String usage;

    private EnergyType(String name, String storage, String usage) {
        this.name = name;
        this.storage = storage;
        this.usage = usage;
    }

    public String getName() {
        return this.name;
    }

    public String getStorageSuffix() {
        return this.storage;
    }

    public String getUsageSuffix() {
        return this.usage;
    }

    @Nonnull
    public String getUsage(long in) {
        return NumberFormat.getInstance().format(in) + " " + this.usage;
    }

    @Nonnull
    public String getUsageCompact(long in) {
        return FluxUtils.compact(in, this.usage);
    }

    @Nonnull
    public String getStorage(long in) {
        return NumberFormat.getInstance().format(in) + " " + this.storage;
    }

    @Nonnull
    public String getStorageCompact(long in) {
        return FluxUtils.compact(in, this.storage);
    }
}

