/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.gui.basic;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.resources.ResourceLocation;
import sonar.fluxnetworks.client.gui.basic.GuiButtonCore;
import sonar.fluxnetworks.client.gui.basic.GuiFluxCore;
import sonar.fluxnetworks.client.gui.basic.GuiFocusable;
import sonar.fluxnetworks.common.connection.FluxMenu;
import sonar.fluxnetworks.common.util.FluxUtils;

public abstract class GuiPopupCore<T extends GuiFluxCore>
extends GuiFocusable {
    protected final List<GuiButtonCore> mButtons = new ArrayList<GuiButtonCore>();
    public final T mHost;
    protected float mAlpha = 0.0f;

    public GuiPopupCore(@Nonnull T host) {
        super((FluxMenu)host.m_6262_(), ((GuiFluxCore)((Object)host)).mPlayer);
        this.mHost = host;
    }

    public void m_7856_() {
        super.m_7856_();
        this.mButtons.clear();
    }

    public void m_7379_() {
        this.mButtons.clear();
    }

    public final void m_88315_(@Nonnull GuiGraphics gr, int mouseX, int mouseY, float deltaTicks) {
        throw new UnsupportedOperationException();
    }

    protected void m_280003_(@Nonnull GuiGraphics gr, int mouseX, int mouseY) {
        throw new UnsupportedOperationException();
    }

    protected final void m_7286_(@Nonnull GuiGraphics gr, float deltaTicks, int mouseX, int mouseY) {
        throw new UnsupportedOperationException();
    }

    public void drawForegroundLayer(@Nonnull GuiGraphics gr, int mouseX, int mouseY, float deltaTicks) {
        for (GuiButtonCore button : this.mButtons) {
            button.drawButton(gr, mouseX, mouseY, deltaTicks);
        }
    }

    public void drawBackgroundLayer(@Nonnull GuiGraphics gr, int mouseX, int mouseY, float deltaTicks) {
        this.mAlpha = Math.min(1.0f, this.mAlpha + deltaTicks / 6.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.mAlpha);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)BACKGROUND);
        this.blitBackgroundOrFrame(gr);
        int color = ((GuiFluxCore)((Object)this.mHost)).getNetwork().getNetworkColor();
        RenderSystem.setShaderColor((float)FluxUtils.getRed(color), (float)FluxUtils.getGreen(color), (float)FluxUtils.getBlue(color), (float)this.mAlpha);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)FRAME);
        this.blitBackgroundOrFrame(gr);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int bgColor = (int)(this.mAlpha * 128.0f) << 24;
        gr.m_280509_(0, 0, this.f_96543_, this.f_96544_, bgColor);
        for (Renderable widget : this.f_169369_) {
            widget.m_88315_(gr, mouseX, mouseY, deltaTicks);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        boolean result = false;
        for (GuiButtonCore button : this.mButtons) {
            if (!button.mClickable || !button.isMouseHovered(mouseX, mouseY)) continue;
            this.onButtonClicked(button, (int)mouseX, (int)mouseY, mouseButton);
            result = true;
            break;
        }
        for (GuiEventListener child : this.m_6702_()) {
            if (!child.m_6375_(mouseX, mouseY, mouseButton)) continue;
            this.m_7522_(child);
            if (mouseButton == 0) {
                this.m_7897_(true);
            }
            return true;
        }
        boolean focused = false;
        for (GuiEventListener child : this.m_6702_()) {
            EditBox editBox;
            if (!(child instanceof EditBox) || !(editBox = (EditBox)child).m_93696_() || !editBox.m_5953_(mouseX, mouseY)) continue;
            focused = true;
            break;
        }
        if (!focused) {
            this.m_7522_(null);
            return true;
        }
        return result;
    }

    public void onButtonClicked(GuiButtonCore button, int mouseX, int mouseY, int mouseButton) {
    }
}

