/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.gui.popup;

import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import sonar.fluxnetworks.FluxConfig;
import sonar.fluxnetworks.api.FluxTranslate;
import sonar.fluxnetworks.api.device.IFluxDevice;
import sonar.fluxnetworks.client.gui.basic.GuiButtonCore;
import sonar.fluxnetworks.client.gui.basic.GuiFocusable;
import sonar.fluxnetworks.client.gui.basic.GuiPopupCore;
import sonar.fluxnetworks.client.gui.button.Checkbox;
import sonar.fluxnetworks.client.gui.button.FluxEditBox;
import sonar.fluxnetworks.client.gui.button.SimpleButton;
import sonar.fluxnetworks.client.gui.button.SwitchButton;
import sonar.fluxnetworks.client.gui.tab.GuiTabConnections;
import sonar.fluxnetworks.register.ClientMessages;

public class PopupConnectionEdit
extends GuiPopupCore<GuiTabConnections> {
    public SimpleButton mCancel;
    public SimpleButton mApply;
    public FluxEditBox mCustomName;
    public FluxEditBox mPriority;
    public FluxEditBox mLimit;
    public SwitchButton mSurgeMode;
    public SwitchButton mDisableLimit;
    public SwitchButton mChunkLoading;
    public Checkbox mEditCustomName;
    public Checkbox mEditPriority;
    public Checkbox mEditLimit;
    public Checkbox mEditSurgeMode;
    public Checkbox mEditDisableLimit;
    public Checkbox mEditChunkLoading;

    public PopupConnectionEdit(GuiTabConnections host) {
        super(host);
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.mCancel = new SimpleButton(this, this.f_97735_ + this.f_97726_ / 2 - 12 - 48, this.f_97736_ + 146, 48, 12, FluxTranslate.CANCEL.get());
        this.mButtons.add(this.mCancel);
        this.mApply = new SimpleButton(this, this.f_97735_ + this.f_97726_ / 2 + 12, this.f_97736_ + 146, 48, 12, FluxTranslate.APPLY.get());
        this.mApply.setClickable(false);
        this.mButtons.add(this.mApply);
        int color = ((GuiTabConnections)this.mHost).getNetwork().getNetworkColor() | 0xFF000000;
        IFluxDevice singleConnection = ((GuiTabConnections)this.mHost).mSelected.size() == 1 ? (IFluxDevice)((GuiTabConnections)this.mHost).mSelected.iterator().next() : null;
        this.mCustomName = FluxEditBox.create(FluxTranslate.NAME.get() + ": ", this.f_96547_, this.f_97735_ + 20, this.f_97736_ + 30, 136, 12).setOutlineColor(color);
        this.mCustomName.m_94199_(24);
        if (singleConnection != null) {
            this.mCustomName.m_94144_(singleConnection.getCustomName());
        }
        this.m_142416_((GuiEventListener)this.mCustomName);
        this.mPriority = FluxEditBox.create(FluxTranslate.PRIORITY.get() + ": ", this.f_96547_, this.f_97735_ + 20, this.f_97736_ + 47, 136, 12).setOutlineColor(color).setDigitsOnly().setAllowNegatives(true);
        this.mPriority.m_94199_(5);
        if (singleConnection != null) {
            this.mPriority.m_94144_(Integer.toString(singleConnection.getRawPriority()));
        } else {
            this.mPriority.m_94144_(Integer.toString(0));
        }
        this.m_142416_((GuiEventListener)this.mPriority);
        this.mLimit = FluxEditBox.create(FluxTranslate.TRANSFER_LIMIT.get() + ": ", this.f_96547_, this.f_97735_ + 20, this.f_97736_ + 64, 136, 12).setOutlineColor(color).setDigitsOnly().setMaxValue(Long.MAX_VALUE);
        this.mLimit.m_94199_(15);
        if (singleConnection != null) {
            this.mLimit.m_94144_(Long.toString(singleConnection.getRawLimit()));
        } else {
            this.mLimit.m_94144_(Integer.toString(0));
        }
        this.m_142416_((GuiEventListener)this.mLimit);
        this.mEditCustomName = new Checkbox(this, this.f_97735_ + 10, this.f_97736_ + 33);
        this.mEditPriority = new Checkbox(this, this.f_97735_ + 10, this.f_97736_ + 50);
        this.mEditLimit = new Checkbox(this, this.f_97735_ + 10, this.f_97736_ + 67);
        this.mEditSurgeMode = new Checkbox(this, this.f_97735_ + 10, this.f_97736_ + 82);
        this.mEditDisableLimit = new Checkbox(this, this.f_97735_ + 10, this.f_97736_ + 94);
        this.mEditChunkLoading = new Checkbox(this, this.f_97735_ + 10, this.f_97736_ + 106);
        this.mButtons.add(this.mEditCustomName);
        this.mButtons.add(this.mEditPriority);
        this.mButtons.add(this.mEditLimit);
        this.mButtons.add(this.mEditSurgeMode);
        this.mButtons.add(this.mEditDisableLimit);
        this.mButtons.add(this.mEditChunkLoading);
        this.mSurgeMode = new SwitchButton((GuiFocusable)this, this.f_97735_ + 140, this.f_97736_ + 82, singleConnection != null && singleConnection.getSurgeMode(), color);
        this.mDisableLimit = new SwitchButton((GuiFocusable)this, this.f_97735_ + 140, this.f_97736_ + 94, singleConnection != null && singleConnection.getDisableLimit(), color);
        this.mChunkLoading = new SwitchButton((GuiFocusable)this, this.f_97735_ + 140, this.f_97736_ + 106, singleConnection != null && singleConnection.isForcedLoading(), color);
        this.mChunkLoading.setClickable(FluxConfig.enableChunkLoading && (singleConnection == null || !singleConnection.getDeviceType().isStorage()));
        this.mButtons.add(this.mSurgeMode);
        this.mButtons.add(this.mDisableLimit);
        this.mButtons.add(this.mChunkLoading);
    }

    @Override
    public void drawForegroundLayer(@Nonnull GuiGraphics gr, int mouseX, int mouseY, float deltaTicks) {
        super.drawForegroundLayer(gr, mouseX, mouseY, deltaTicks);
        gr.m_280137_(this.f_96547_, FluxTranslate.BATCH_EDIT.get(), this.f_97735_ + 88, this.f_97736_ + 14, 0xFFFFFF);
        gr.m_280137_(this.f_96547_, FluxTranslate.EDITING_CONNECTIONS.format(((GuiTabConnections)this.mHost).mSelected.size()), this.f_97735_ + 88, this.f_97736_ + 122, 0xFFFFFF);
        gr.m_280488_(this.f_96547_, FluxTranslate.SURGE_MODE.get(), this.f_97735_ + 20, this.f_97736_ + 82, ((GuiTabConnections)this.mHost).getNetwork().getNetworkColor());
        gr.m_280488_(this.f_96547_, FluxTranslate.DISABLE_LIMIT.get(), this.f_97735_ + 20, this.f_97736_ + 94, ((GuiTabConnections)this.mHost).getNetwork().getNetworkColor());
        if (this.mChunkLoading != null) {
            gr.m_280488_(this.f_96547_, FluxTranslate.CHUNK_LOADING.get(), this.f_97735_ + 20, this.f_97736_ + 106, ((GuiTabConnections)this.mHost).getNetwork().getNetworkColor());
        }
    }

    @Override
    public void onButtonClicked(GuiButtonCore button, int mouseX, int mouseY, int mouseButton) {
        super.onButtonClicked(button, mouseX, mouseY, mouseButton);
        if (mouseButton != 0) {
            return;
        }
        if (button instanceof SwitchButton) {
            SwitchButton switchButton = (SwitchButton)button;
            switchButton.toggle();
        } else if (button instanceof Checkbox) {
            Checkbox checkbox = (Checkbox)button;
            checkbox.toggle();
            this.mApply.setClickable(this.mButtons.stream().filter(b -> b instanceof Checkbox).anyMatch(t -> ((Checkbox)t).isChecked()));
        }
        if (button == this.mCancel) {
            ((GuiTabConnections)this.mHost).closePopup();
        } else if (button == this.mApply) {
            List<GlobalPos> list = ((GuiTabConnections)this.mHost).mSelected.stream().map(IFluxDevice::getGlobalPos).collect(Collectors.toList());
            CompoundTag tag = new CompoundTag();
            if (this.mEditCustomName.isChecked()) {
                tag.m_128359_("customName", this.mCustomName.m_94155_());
            }
            if (this.mEditPriority.isChecked()) {
                int priority = Mth.m_14045_((int)this.mPriority.getValidInt(), (int)-9999, (int)9999);
                tag.m_128405_("priority", priority);
            }
            if (this.mEditLimit.isChecked()) {
                long limit = this.mLimit.getValidLong();
                tag.m_128356_("limit", limit);
            }
            if (this.mEditSurgeMode.isChecked()) {
                tag.m_128379_("surgeMode", this.mSurgeMode.isChecked());
            }
            if (this.mEditDisableLimit.isChecked()) {
                tag.m_128379_("disableLimit", this.mDisableLimit.isChecked());
            }
            if (this.mEditChunkLoading.isChecked()) {
                tag.m_128379_("forcedLoading", this.mChunkLoading.isChecked());
            }
            ClientMessages.editConnection(((GuiTabConnections)this.mHost).getToken(), ((GuiTabConnections)this.mHost).getNetwork(), list, tag);
            this.mApply.setClickable(false);
        }
    }
}

