/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.client.particle.impl;

import cofh.core.client.particle.CylindricalParticle;
import cofh.core.client.particle.options.CylindricalParticleOptions;
import cofh.core.init.CoreShaders;
import cofh.core.util.helpers.vfx.RenderTypes;
import cofh.core.util.helpers.vfx.VFXHelper;
import cofh.lib.util.helpers.MathHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.SplittableRandom;
import javax.annotation.Nonnull;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.MultiBufferSource;
import org.joml.Quaternionf;

public class BlastWaveParticle
extends CylindricalParticle {
    private BlastWaveParticle(CylindricalParticleOptions data, ClientLevel level, double x, double y, double z, double xDir, double yDir, double zDir) {
        super(data, level, x, y, z, xDir, yDir, zDir);
    }

    @Override
    public void render(PoseStack stack, MultiBufferSource buffer, VertexConsumer consumer, int packedLightIn, float time, float pTicks) {
        if (!this.rotation.equals((Object)new Quaternionf())) {
            stack.m_252781_(this.rotation);
        }
        SplittableRandom rand = new SplittableRandom(this.seed);
        float progress = time / this.duration;
        float easeSin = MathHelper.sin(progress * (float)Math.PI * 0.5f);
        VFXHelper.renderCyclone(stack, CoreShaders.PIXELATE.getBuffer(RenderTypes.BLANK_TEXTURE), this.m_6355_(time), this.c0, easeSin * this.size * 0.5f, 0.018f * MathHelper.sqrt(9.0f + this.size * this.size), this.height * easeSin, rand, progress * 0.5f);
    }

    @Nonnull
    public static ParticleProvider<CylindricalParticleOptions> factory(SpriteSet spriteSet) {
        return BlastWaveParticle::new;
    }
}

