/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.common;

import cofh.core.util.ProxyUtils;
import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.lighting.BlockLightEngine;
import net.minecraft.world.level.lighting.BlockLightSectionStorage;
import net.minecraft.world.level.lighting.LightEngine;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="cofh_core")
public class TransientLightManager {
    protected static final BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
    protected static Long2ByteMap CURRENT = new Long2ByteOpenHashMap();
    protected static Long2ByteMap PREVIOUS = new Long2ByteOpenHashMap();

    public static void addLight(BlockPos pos, int level) {
        TransientLightManager.addLight(pos.m_121878_(), level);
    }

    public static void addLight(long pos, int level) {
        if (0 < level && level < 16 && level > CURRENT.get(pos)) {
            CURRENT.put(pos, (byte)level);
        }
    }

    @SubscribeEvent
    protected static void tick(TickEvent.ClientTickEvent event) {
        long pos;
        LightEngine lightEngine;
        if (event.phase != TickEvent.Phase.END || CURRENT.isEmpty() && PREVIOUS.isEmpty()) {
            return;
        }
        Level level = ProxyUtils.getClientWorld();
        if (level == null || !((lightEngine = level.m_5518_().f_75802_) instanceof BlockLightEngine)) {
            CURRENT.clear();
            return;
        }
        BlockLightEngine engine = (BlockLightEngine)lightEngine;
        for (Long2ByteMap.Entry entry : CURRENT.long2ByteEntrySet()) {
            int stored;
            pos = entry.getLongKey();
            if (!((BlockLightSectionStorage)engine.f_283849_).m_75791_(SectionPos.m_123235_((long)pos))) {
                return;
            }
            int light = entry.getByteValue();
            byte previous = PREVIOUS.remove(pos);
            if (previous == light || (stored = ((BlockLightSectionStorage)engine.f_283849_).m_75795_(pos)) == light) continue;
            boolean empty = true;
            if (stored == previous) {
                BlockState state = engine.m_284512_((BlockPos)cursor.m_122188_(pos));
                int emitted = engine.m_284436_(pos, state);
                if (emitted > light) {
                    if (emitted == stored) continue;
                    light = emitted;
                    empty = LightEngine.m_284265_((BlockState)state);
                }
            } else if (stored > light) continue;
            if (stored > 0) {
                ((BlockLightSectionStorage)engine.f_283849_).m_75772_(pos, 0);
                engine.m_284343_(pos, LightEngine.QueueEntry.m_284290_((int)stored));
            }
            if (light <= 0) continue;
            engine.m_284218_(pos, LightEngine.QueueEntry.m_284185_((int)light, (boolean)empty));
        }
        for (Long2ByteMap.Entry entry : PREVIOUS.long2ByteEntrySet()) {
            pos = entry.getLongKey();
            if (((BlockLightSectionStorage)engine.f_283849_).m_75795_(pos) != entry.getByteValue()) continue;
            engine.m_7174_((BlockPos)cursor.m_122188_(pos));
        }
        PREVIOUS = CURRENT;
        CURRENT = new Long2ByteOpenHashMap(CURRENT.size() + 10);
    }
}

