/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.common.network.packet.server;

import cofh.core.CoFHCore;
import cofh.core.util.helpers.ItemHelper;
import cofh.lib.common.network.packet.IPacketServer;
import cofh.lib.common.network.packet.PacketBase;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class ItemModeChangePacket
extends PacketBase
implements IPacketServer {
    protected boolean decr;

    public ItemModeChangePacket() {
        super(64, CoFHCore.PACKET_HANDLER);
    }

    @Override
    public void handleServer(ServerPlayer player) {
        if (!ItemHelper.isPlayerHoldingMultiModeItem((Player)player)) {
            return;
        }
        if (this.decr && ItemHelper.decrHeldMultiModeItemState((Player)player) || !this.decr && ItemHelper.incrHeldMultiModeItemState((Player)player)) {
            ItemHelper.onHeldMultiModeItemChange((Player)player);
        }
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.writeBoolean(this.decr);
    }

    @Override
    public void read(FriendlyByteBuf buf) {
        this.decr = buf.readBoolean();
    }

    public static void incrMode() {
        ItemModeChangePacket.sendToServer(false);
    }

    public static void decrMode() {
        ItemModeChangePacket.sendToServer(true);
    }

    private static void sendToServer(boolean decr) {
        ItemModeChangePacket packet = new ItemModeChangePacket();
        packet.decr = decr;
        packet.sendToServer();
    }
}

