/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.common.network.packet.server;

import cofh.core.CoFHCore;
import cofh.core.util.control.ISecurableTile;
import cofh.lib.api.control.ISecurable;
import cofh.lib.common.network.packet.IPacketServer;
import cofh.lib.common.network.packet.PacketBase;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class SecurityControlPacket
extends PacketBase
implements IPacketServer {
    protected BlockPos pos;
    protected byte mode;

    public SecurityControlPacket() {
        super(33, CoFHCore.PACKET_HANDLER);
    }

    @Override
    public void handleServer(ServerPlayer player) {
        Level world = player.f_19853_;
        if (!world.m_46749_(this.pos)) {
            return;
        }
        BlockEntity tile = world.m_7702_(this.pos);
        if (tile instanceof ISecurableTile) {
            ISecurableTile securableTile = (ISecurableTile)tile;
            securableTile.setAccess(ISecurable.AccessMode.VALUES[this.mode]);
        }
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.writeByte((int)this.mode);
    }

    @Override
    public void read(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.mode = buf.readByte();
    }

    public static void sendToServer(ISecurableTile tile) {
        SecurityControlPacket packet = new SecurityControlPacket();
        packet.pos = tile.pos();
        packet.mode = (byte)tile.securityControl().getAccess().ordinal();
        packet.sendToServer();
    }
}

