/*
 * Decompiled with CFR 0.152.
 */
package com.maideniles.maidensmerrymaking.world.feature.tree.weathering;

import com.maideniles.maidensmerrymaking.init.ModBlocks;
import com.maideniles.maidensmerrymaking.world.feature.tree.weathering.WeatheringLog;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ToolAction;

public class WeatheringLogBlock
extends Block
implements WeatheringLog {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.f_61365_;
    private final WeatheringLog.WeatherState weatherState;

    public WeatheringLogBlock(WeatheringLog.WeatherState pWeatherState, BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.weatherState = pWeatherState;
        this.m_49959_((BlockState)this.m_49966_().m_61124_(AXIS, (Comparable)Direction.Axis.Y));
    }

    public void m_213898_(BlockState p_222665_, ServerLevel p_222666_, BlockPos p_222667_, RandomSource p_222668_) {
        this.m_220947_(p_222665_, p_222666_, p_222667_, p_222668_);
    }

    public boolean m_6724_(BlockState pState) {
        return WeatheringLog.getNext(pState.m_60734_()).isPresent();
    }

    public WeatheringLog.WeatherState getAge() {
        return this.weatherState;
    }

    public BlockState m_6843_(BlockState pState, Rotation pRot) {
        return WeatheringLogBlock.rotatePillar(pState, pRot);
    }

    public static BlockState rotatePillar(BlockState pState, Rotation pRotation) {
        switch (pRotation) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                switch ((Direction.Axis)pState.m_61143_(AXIS)) {
                    case X: {
                        return (BlockState)pState.m_61124_(AXIS, (Comparable)Direction.Axis.Z);
                    }
                    case Z: {
                        return (BlockState)pState.m_61124_(AXIS, (Comparable)Direction.Axis.X);
                    }
                }
                return pState;
            }
        }
        return pState;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{AXIS});
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)this.m_49966_().m_61124_(AXIS, (Comparable)pContext.m_43719_().m_122434_());
    }

    @Nullable
    public BlockState getToolModifiedState(BlockState state, UseOnContext context, ToolAction toolAction, boolean simulate) {
        if (context.m_43722_().m_41720_() instanceof AxeItem) {
            if (state.m_60713_((Block)ModBlocks.PINE_LOG.get())) {
                return (BlockState)((Block)ModBlocks.STRIPPED_PINE_LOG.get()).m_49966_().m_61124_(AXIS, (Comparable)((Direction.Axis)state.m_61143_(AXIS)));
            }
            if (state.m_60713_((Block)ModBlocks.EXPOSED_PINE_LOG.get())) {
                return (BlockState)((Block)ModBlocks.STRIPPED_EXPOSED_PINE_LOG.get()).m_49966_().m_61124_(AXIS, (Comparable)((Direction.Axis)state.m_61143_(AXIS)));
            }
            if (state.m_60713_((Block)ModBlocks.WEATHERED_PINE_LOG.get())) {
                return (BlockState)((Block)ModBlocks.STRIPPED_WEATHERED_PINE_LOG.get()).m_49966_().m_61124_(AXIS, (Comparable)((Direction.Axis)state.m_61143_(AXIS)));
            }
            if (state.m_60713_((Block)ModBlocks.AGED_PINE_LOG.get())) {
                return (BlockState)((Block)ModBlocks.STRIPPED_AGED_PINE_LOG.get()).m_49966_().m_61124_(AXIS, (Comparable)((Direction.Axis)state.m_61143_(AXIS)));
            }
            if (state.m_60713_((Block)ModBlocks.PINE_WOOD.get())) {
                return (BlockState)((Block)ModBlocks.STRIPPED_PINE_WOOD.get()).m_49966_().m_61124_(AXIS, (Comparable)((Direction.Axis)state.m_61143_(AXIS)));
            }
            if (state.m_60713_((Block)ModBlocks.EXPOSED_PINE_WOOD.get())) {
                return (BlockState)((Block)ModBlocks.STRIPPED_EXPOSED_PINE_WOOD.get()).m_49966_().m_61124_(AXIS, (Comparable)((Direction.Axis)state.m_61143_(AXIS)));
            }
            if (state.m_60713_((Block)ModBlocks.WEATHERED_PINE_WOOD.get())) {
                return (BlockState)((Block)ModBlocks.STRIPPED_WEATHERED_PINE_WOOD.get()).m_49966_().m_61124_(AXIS, (Comparable)((Direction.Axis)state.m_61143_(AXIS)));
            }
            if (state.m_60713_((Block)ModBlocks.AGED_PINE_WOOD.get())) {
                return (BlockState)((Block)ModBlocks.STRIPPED_AGED_PINE_WOOD.get()).m_49966_().m_61124_(AXIS, (Comparable)((Direction.Axis)state.m_61143_(AXIS)));
            }
        }
        return super.getToolModifiedState(state, context, toolAction, simulate);
    }

    public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return true;
    }

    public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 5;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 5;
    }
}

