/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.dimension.descriptor;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mcjty.lib.varia.TagTools;
import mcjty.lib.varia.Tools;
import mcjty.rftoolsdim.RFToolsDim;
import mcjty.rftoolsdim.dimension.AdminDimletType;
import mcjty.rftoolsdim.dimension.DimensionConfig;
import mcjty.rftoolsdim.dimension.TimeType;
import mcjty.rftoolsdim.dimension.additional.SkyDimletType;
import mcjty.rftoolsdim.dimension.biomes.BiomeControllerType;
import mcjty.rftoolsdim.dimension.descriptor.CompiledFeature;
import mcjty.rftoolsdim.dimension.descriptor.DescriptorError;
import mcjty.rftoolsdim.dimension.descriptor.DimensionDescriptor;
import mcjty.rftoolsdim.dimension.features.FeatureType;
import mcjty.rftoolsdim.dimension.terraintypes.AttributeType;
import mcjty.rftoolsdim.dimension.terraintypes.TerrainType;
import mcjty.rftoolsdim.modules.dimlets.data.DimletDictionary;
import mcjty.rftoolsdim.modules.dimlets.data.DimletKey;
import mcjty.rftoolsdim.modules.dimlets.data.DimletSettings;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;

public class CompiledDescriptor {
    private TerrainType terrainType = null;
    private final Set<AttributeType> attributeTypes = EnumSet.noneOf(AttributeType.class);
    private BlockState baseBlock = null;
    private BlockState baseLiquid = null;
    private final Set<AdminDimletType> adminDimletTypes = EnumSet.noneOf(AdminDimletType.class);
    private final Set<CompiledFeature> features = new HashSet<CompiledFeature>();
    private BiomeControllerType biomeControllerType = null;
    private final Set<TagKey<Biome>> biomeCategories = new HashSet<TagKey<Biome>>();
    private final List<ResourceLocation> biomes = new ArrayList<ResourceLocation>();
    private final List<ResourceLocation> structures = new ArrayList<ResourceLocation>();
    private long skyDimletTypes = 0L;
    private TimeType timeType = null;
    private int createCostPerTick = 0;
    private int maintainCostPerTick = 0;
    private int randomizedCostPerTick = 0;
    private int actualTickCost = 0;

    public void compile(DimensionDescriptor descriptor, DimensionDescriptor randomizedDescriptor) throws DescriptorError {
        this.createCostPerTick = 10;
        this.maintainCostPerTick = 10;
        this.randomizedCostPerTick = 0;
        this.actualTickCost = 100;
        ArrayList<ResourceLocation> collectedTags = new ArrayList<ResourceLocation>();
        ArrayList<BlockState> collectedBlocks = new ArrayList<BlockState>();
        ArrayList<BlockState> collectedFluids = new ArrayList<BlockState>();
        EnumSet<AttributeType> collectedAttributes = EnumSet.noneOf(AttributeType.class);
        for (DimletKey dimlet : descriptor.getDimlets()) {
            this.handleDimlet(collectedTags, collectedBlocks, collectedFluids, collectedAttributes, dimlet);
        }
        int originalMaintainCost = this.maintainCostPerTick;
        this.maintainCostPerTick = 0;
        for (DimletKey dimlet : randomizedDescriptor.getDimlets()) {
            this.handleDimlet(collectedTags, collectedBlocks, collectedFluids, collectedAttributes, dimlet);
        }
        this.randomizedCostPerTick = this.maintainCostPerTick;
        this.maintainCostPerTick = originalMaintainCost;
        if (this.adminDimletTypes.contains((Object)AdminDimletType.CHEATER)) {
            this.createCostPerTick = 0;
            this.maintainCostPerTick = 0;
            this.randomizedCostPerTick = 0;
            this.actualTickCost = 1;
        }
        if (!collectedBlocks.isEmpty()) {
            throw DescriptorError.ERROR(DescriptorError.Code.DANGLING_BLOCKS);
        }
        if (!collectedFluids.isEmpty()) {
            throw DescriptorError.ERROR(DescriptorError.Code.DANGLING_FLUIDS);
        }
        if (!collectedAttributes.isEmpty()) {
            throw DescriptorError.ERROR(DescriptorError.Code.DANGLING_ATTRIBUTES);
        }
        if (!collectedTags.isEmpty()) {
            throw DescriptorError.ERROR(DescriptorError.Code.DANGLING_TAGS);
        }
    }

    public void complete() {
        if (this.timeType == null) {
            this.timeType = TimeType.NORMAL;
        }
        if (this.biomeControllerType == null) {
            this.biomeControllerType = BiomeControllerType.SINGLE;
        }
        if (this.baseBlock == null) {
            this.baseBlock = Tools.getBlock((ResourceLocation)new ResourceLocation((String)DimensionConfig.DEFAULT_BASE_BLOCK.get())).m_49966_();
        }
        if (this.baseLiquid == null) {
            this.baseLiquid = Tools.getBlock((ResourceLocation)new ResourceLocation((String)DimensionConfig.DEFAULT_BASE_FLUID.get())).m_49966_();
        }
    }

    private void handleDimlet(List<ResourceLocation> collectedTags, List<BlockState> collectedBlocks, List<BlockState> collectedFluids, Set<AttributeType> collectedAttributes, DimletKey dimlet) throws DescriptorError {
        DimletSettings settings = DimletDictionary.get().getSettings(dimlet);
        if (settings != null) {
            this.createCostPerTick += settings.getCreateCost();
            this.actualTickCost += settings.getTickCost();
            this.maintainCostPerTick += settings.getMaintainCost();
        }
        String name = dimlet.key();
        switch (dimlet.type()) {
            case TERRAIN: {
                this.handleDimletTerrain(collectedTags, collectedBlocks, collectedFluids, collectedAttributes, name);
                break;
            }
            case ATTRIBUTE: {
                AttributeType type = AttributeType.byName(dimlet.key());
                if (type == null) {
                    throw DescriptorError.ERROR(DescriptorError.Code.BAD_ATTRIBUTE, name);
                }
                collectedAttributes.add(type);
                break;
            }
            case DIGIT: {
                break;
            }
            case ADMIN: {
                AdminDimletType type = AdminDimletType.byName(dimlet.key());
                if (type == null) {
                    throw DescriptorError.ERROR(DescriptorError.Code.BAD_ADMIN_TYPE, name);
                }
                this.adminDimletTypes.add(type);
                break;
            }
            case BIOME_CONTROLLER: {
                if (this.biomeControllerType != null) {
                    throw DescriptorError.ERROR(DescriptorError.Code.ONLY_ONE_BIOME_CONTROLLER);
                }
                this.biomeControllerType = BiomeControllerType.byName(name);
                if (this.biomeControllerType != null) break;
                throw DescriptorError.ERROR(DescriptorError.Code.BAD_BIOME_CONTROLLER, name);
            }
            case BIOME_CATEGORY: {
                this.biomeCategories.add((TagKey<Biome>)TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation(name)));
                break;
            }
            case BIOME: {
                this.biomes.add(new ResourceLocation(name));
                break;
            }
            case STRUCTURE: {
                this.structures.add(new ResourceLocation(name));
                break;
            }
            case SKY: {
                SkyDimletType skyDimletType = SkyDimletType.byName(name);
                if (skyDimletType == null) break;
                this.skyDimletTypes |= skyDimletType.getMask();
                break;
            }
            case TIME: {
                if (this.timeType != null) {
                    throw DescriptorError.ERROR(DescriptorError.Code.ONLY_ONE_TIME);
                }
                this.timeType = TimeType.byName(name);
                if (this.timeType != null) break;
                throw DescriptorError.ERROR(DescriptorError.Code.BAD_TIME, name);
            }
            case FEATURE: {
                this.handleDimletTerrain(collectedTags, collectedBlocks, collectedFluids, name);
                break;
            }
            case TAG: {
                collectedTags.add(new ResourceLocation(name));
                break;
            }
            case BLOCK: {
                Block block = Tools.getBlock((ResourceLocation)new ResourceLocation(name));
                if (block == null) {
                    throw DescriptorError.ERROR(DescriptorError.Code.BAD_BLOCK, name);
                }
                collectedBlocks.add(block.m_49966_());
                break;
            }
            case FLUID: {
                Fluid fluid = Tools.getFluid((ResourceLocation)new ResourceLocation(name));
                if (fluid == null) {
                    throw DescriptorError.ERROR(DescriptorError.Code.BAD_FLUID, name);
                }
                BlockState blockState = fluid.m_76145_().m_76188_();
                if (blockState != null && !blockState.m_60795_()) {
                    collectedFluids.add(blockState);
                    break;
                }
                throw DescriptorError.ERROR(DescriptorError.Code.FLUID_HAS_NO_BLOCK, name);
            }
        }
    }

    private void handleDimletTerrain(List<ResourceLocation> collectedTags, List<BlockState> collectedBlocks, List<BlockState> collectedFluids, String name) throws DescriptorError {
        FeatureType feature = FeatureType.byName(name);
        if (feature == null) {
            throw DescriptorError.ERROR(DescriptorError.Code.BAD_FEATURE, name);
        }
        CompiledFeature compiledFeature = new CompiledFeature(feature);
        for (ResourceLocation rl : collectedTags) {
            for (Holder holder : TagTools.getBlocksForTag((ResourceLocation)rl)) {
                collectedBlocks.add(((Block)holder.m_203334_()).m_49966_());
            }
        }
        collectedTags.clear();
        compiledFeature.getBlocks().addAll(collectedBlocks);
        collectedBlocks.clear();
        if (compiledFeature.getBlocks().isEmpty()) {
            compiledFeature.getBlocks().add(Tools.getBlock((ResourceLocation)new ResourceLocation((String)DimensionConfig.DEFAULT_BASE_BLOCK.get())).m_49966_());
        }
        compiledFeature.getFluids().addAll(collectedFluids);
        collectedFluids.clear();
        if (compiledFeature.getFluids().isEmpty()) {
            compiledFeature.getFluids().add(Tools.getBlock((ResourceLocation)new ResourceLocation((String)DimensionConfig.DEFAULT_BASE_FLUID.get())).m_49966_());
        }
        this.features.add(compiledFeature);
    }

    private void handleDimletTerrain(List<ResourceLocation> collectedTags, List<BlockState> collectedBlocks, List<BlockState> collectedFluids, Set<AttributeType> collectedAttributes, String name) throws DescriptorError {
        if (this.terrainType != null) {
            throw DescriptorError.ERROR(DescriptorError.Code.ONLY_ONE_TERRAIN);
        }
        this.terrainType = TerrainType.byName(name);
        if (this.terrainType == null) {
            throw DescriptorError.ERROR(DescriptorError.Code.BAD_TERRAIN_TYPE, name);
        }
        if (!collectedTags.isEmpty()) {
            throw DescriptorError.ERROR(DescriptorError.Code.NO_TAGS);
        }
        if (collectedBlocks.size() > 1) {
            throw DescriptorError.ERROR(DescriptorError.Code.ONLY_ONE_BLOCK);
        }
        this.baseBlock = collectedBlocks.isEmpty() ? Tools.getBlock((ResourceLocation)new ResourceLocation((String)DimensionConfig.DEFAULT_BASE_BLOCK.get())).m_49966_() : collectedBlocks.iterator().next();
        collectedBlocks.clear();
        this.attributeTypes.addAll(collectedAttributes);
        collectedAttributes.clear();
        if (collectedFluids.size() > 1) {
            throw DescriptorError.ERROR(DescriptorError.Code.ONLY_ONE_FLUID, name);
        }
        if (collectedFluids.size() == 1) {
            this.baseLiquid = collectedFluids.get(0);
            collectedFluids.clear();
        }
    }

    public void log(String header) {
        header = "--------------------------------------------------\n" + (String)header;
        header = (String)header + "\n    TERRAIN: " + this.terrainType.getName();
        header = (String)header + "\n    TIME: " + this.timeType.getName();
        header = (String)header + "\n    SKY: " + SkyDimletType.getDescription(this.skyDimletTypes);
        header = (String)header + "\n    LIQUID: " + Tools.getId((BlockState)this.baseLiquid).toString();
        if (this.baseBlock != null) {
            header = (String)header + "\n    BLOCK: " + Tools.getId((BlockState)this.baseBlock).toString();
        }
        for (AdminDimletType adminDimletType : this.adminDimletTypes) {
            header = (String)header + "\n    ADMIN: " + adminDimletType.getName();
        }
        for (AttributeType attributeType : this.attributeTypes) {
            header = (String)header + "\n    ATTR: " + attributeType.getName();
        }
        header = (String)header + "\n    BIOME CTRL: " + this.biomeControllerType.getName();
        for (ResourceLocation resourceLocation : this.biomes) {
            header = (String)header + "\n        BIOME: " + resourceLocation.toString();
        }
        for (TagKey tagKey : this.biomeCategories) {
            header = (String)header + "\n        CATEGORY: " + tagKey.f_203868_().toString();
        }
        for (ResourceLocation resourceLocation : this.structures) {
            header = (String)header + "\n    STRUCTURE: " + resourceLocation.toString();
        }
        for (CompiledFeature compiledFeature : this.features) {
            header = (String)header + "\n    FEATURE: " + compiledFeature.getFeatureType().getName();
            for (BlockState block : compiledFeature.getBlocks()) {
                header = (String)header + "\n        BLOCK: " + Tools.getId((BlockState)block).toString();
            }
            for (BlockState fluid : compiledFeature.getFluids()) {
                header = (String)header + "\n        LIQUID: " + Tools.getId((BlockState)fluid).toString();
            }
        }
        header = (String)header + "\n--------------------------------------------------";
        RFToolsDim.setup.getLogger().info((String)header);
    }

    public long getSkyDimletTypes() {
        return this.skyDimletTypes;
    }

    public TimeType getTimeType() {
        return this.timeType;
    }

    public TerrainType getTerrainType() {
        return this.terrainType;
    }

    public Set<AttributeType> getAttributeTypes() {
        return this.attributeTypes;
    }

    public List<ResourceLocation> getStructures() {
        return this.structures;
    }

    public Set<AdminDimletType> getAdminDimletTypes() {
        return this.adminDimletTypes;
    }

    public BlockState getBaseLiquid() {
        return this.baseLiquid;
    }

    public int getCreateCostPerTick() {
        return this.createCostPerTick;
    }

    public int getActualTickCost() {
        return this.actualTickCost;
    }

    public int getActualPowerCost() {
        return this.maintainCostPerTick + (int)((double)this.randomizedCostPerTick * (Double)DimensionConfig.RANDOMIZED_DIMLET_COST_FACTOR.get());
    }

    public int getMaintainCostPerTick() {
        return this.maintainCostPerTick;
    }

    public BlockState getBaseBlock() {
        return this.baseBlock;
    }

    public Set<CompiledFeature> getFeatures() {
        return this.features;
    }

    public BiomeControllerType getBiomeControllerType() {
        return this.biomeControllerType;
    }

    public List<ResourceLocation> getBiomes() {
        return this.biomes;
    }

    public Set<TagKey<Biome>> getBiomeCategories() {
        return this.biomeCategories;
    }
}

