/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.modules.dimlets.lootmodifier;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import mcjty.rftoolsdim.modules.dimlets.DimletModule;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;

public record LootTableCondition(Set<ResourceLocation> tables) implements LootItemCondition
{
    @Nonnull
    public LootItemConditionType m_7940_() {
        return DimletModule.LOOT_TABLE_CONDITION;
    }

    public boolean test(LootContext lootContext) {
        ResourceLocation table = lootContext.getQueriedLootTableId();
        return this.tables.contains(table);
    }

    public static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<LootTableCondition> {
        public void serialize(@Nonnull JsonObject object, LootTableCondition condition, @Nonnull JsonSerializationContext context) {
            JsonArray array = new JsonArray();
            for (ResourceLocation table : condition.tables) {
                array.add(table.toString());
            }
            object.add("tables", (JsonElement)array);
        }

        @Nonnull
        public LootTableCondition deserialize(JsonObject object, @Nonnull JsonDeserializationContext context) {
            HashSet<ResourceLocation> tables = new HashSet<ResourceLocation>();
            JsonArray tablesArray = object.getAsJsonArray("tables");
            for (JsonElement element : tablesArray) {
                tables.add(new ResourceLocation(element.getAsString()));
            }
            return new LootTableCondition(tables);
        }
    }
}

