/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez.integration.waila;

import de.maxhenkel.pipez.blocks.PipeBlock;
import de.maxhenkel.pipez.blocks.tileentity.PipeLogicTileEntity;
import de.maxhenkel.pipez.blocks.tileentity.UpgradeTileEntity;
import de.maxhenkel.pipez.blocks.tileentity.types.PipeType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

public class HUDHandlerPipes
implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor> {
    static final HUDHandlerPipes INSTANCE = new HUDHandlerPipes();
    private static final ResourceLocation UID = new ResourceLocation("pipez", "pipe");

    public void appendTooltip(ITooltip iTooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig) {
        CompoundTag compound = blockAccessor.getServerData();
        if (compound.m_128425_("Upgrade", 8)) {
            iTooltip.add((Component)Component.Serializer.m_130701_((String)compound.m_128461_("Upgrade")));
        }
        iTooltip.addAll(this.getTooltips(compound));
    }

    public void appendServerData(CompoundTag compound, BlockAccessor blockAccessor) {
        if (blockAccessor.getBlockState().m_60734_() instanceof PipeBlock) {
            BlockEntity te = blockAccessor.getBlockEntity();
            PipeBlock pipe = (PipeBlock)blockAccessor.getBlockState().m_60734_();
            Direction selectedSide = pipe.getSelection(te.m_58900_(), (BlockGetter)blockAccessor.getLevel(), te.m_58899_(), blockAccessor.getPlayer()).getKey();
            if (selectedSide == null) {
                return;
            }
            if (!(te instanceof UpgradeTileEntity)) {
                return;
            }
            PipeLogicTileEntity pipeTile = (PipeLogicTileEntity)te;
            if (!pipeTile.isExtracting(selectedSide)) {
                return;
            }
            ItemStack upgrade = pipeTile.getUpgradeItem(selectedSide);
            if (upgrade.m_41619_()) {
                compound.m_128359_("Upgrade", Component.Serializer.m_130703_((Component)Component.m_237115_((String)"tooltip.pipez.no_upgrade")));
            } else {
                compound.m_128359_("Upgrade", Component.Serializer.m_130703_((Component)upgrade.m_41786_()));
            }
            ArrayList<Component> tooltips = new ArrayList<Component>();
            for (PipeType<?> pipeType : pipeTile.getPipeTypes()) {
                if (!pipeTile.isEnabled(selectedSide, pipeType)) continue;
                tooltips.add(pipeType.getTransferText(pipeTile.getUpgrade(selectedSide)));
            }
            this.putTooltips(compound, tooltips);
        }
    }

    public void putTooltips(CompoundTag compound, List<Component> tooltips) {
        ListTag list = new ListTag();
        for (Component tooltip : tooltips) {
            list.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)tooltip)));
        }
        compound.m_128365_("Tooltips", (Tag)list);
    }

    public List<Component> getTooltips(CompoundTag compound) {
        ArrayList<Component> tooltips = new ArrayList<Component>();
        if (!compound.m_128425_("Tooltips", 9)) {
            return tooltips;
        }
        ListTag list = compound.m_128437_("Tooltips", 8);
        for (int i = 0; i < list.size(); ++i) {
            tooltips.add((Component)Component.Serializer.m_130701_((String)list.m_128778_(i)));
        }
        return tooltips;
    }

    public ResourceLocation getUid() {
        return UID;
    }
}

