/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.maxhenkel.pipez.recipes.ModRecipes;
import javax.annotation.Nullable;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class ClearNbtRecipe
extends CustomRecipe {
    private Ingredient ingredient;

    public ClearNbtRecipe(ResourceLocation recipeID, Ingredient ingredient) {
        super(recipeID, CraftingBookCategory.MISC);
        this.ingredient = ingredient;
    }

    @Nullable
    public ItemStack getIngredient(CraftingContainer inv) {
        ItemStack found = null;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stackInSlot = inv.m_8020_(i);
            if (this.ingredient.test(stackInSlot)) {
                if (found != null) {
                    return null;
                }
                found = stackInSlot;
                continue;
            }
            if (stackInSlot.m_41619_()) continue;
            return null;
        }
        return found;
    }

    public boolean matches(CraftingContainer inv, Level worldIn) {
        return this.getIngredient(inv) != null;
    }

    public ItemStack assemble(CraftingContainer inv, RegistryAccess registryAccess) {
        ItemStack ingredient = this.getIngredient(inv);
        if (ingredient == null) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = ingredient.m_41777_();
        stack.m_41751_(null);
        stack.m_41764_(1);
        return stack;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.CLEAR_NBT.get();
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public static class Serializer
    implements RecipeSerializer<ClearNbtRecipe> {
        public ClearNbtRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            return new ClearNbtRecipe(recipeId, Ingredient.m_43917_((JsonElement)json.get("item")));
        }

        public ClearNbtRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            return new ClearNbtRecipe(recipeId, Ingredient.m_43940_((FriendlyByteBuf)buffer));
        }

        public void toNetwork(FriendlyByteBuf buffer, ClearNbtRecipe recipe) {
            recipe.ingredient.m_43923_(buffer);
        }
    }
}

