/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl3.gui.controllers.slider;

import dev.isxander.yacl3.api.utils.Dimension;
import dev.isxander.yacl3.gui.YACLScreen;
import dev.isxander.yacl3.gui.controllers.ControllerWidget;
import dev.isxander.yacl3.gui.controllers.slider.ISliderController;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.util.Mth;

public class SliderControllerElement
extends ControllerWidget<ISliderController<?>> {
    private final double min;
    private final double max;
    private final double interval;
    private float interpolation;
    private Dimension<Integer> sliderBounds;
    private boolean mouseDown = false;

    public SliderControllerElement(ISliderController<?> option, YACLScreen screen, Dimension<Integer> dim, double min, double max, double interval) {
        super(option, screen, dim);
        this.min = min;
        this.max = max;
        this.interval = interval;
        this.setDimension(dim);
    }

    @Override
    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        super.m_88315_(graphics, mouseX, mouseY, delta);
        this.calculateInterpolation();
    }

    @Override
    protected void drawHoveredControl(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        graphics.m_280509_(this.sliderBounds.x().intValue(), this.sliderBounds.centerY() - 1, this.sliderBounds.xLimit().intValue(), this.sliderBounds.centerY().intValue(), -1);
        graphics.m_280509_(this.sliderBounds.x() + 1, this.sliderBounds.centerY().intValue(), this.sliderBounds.xLimit() + 1, this.sliderBounds.centerY() + 1, -12566464);
        graphics.m_280509_(this.getThumbX() - this.getThumbWidth() / 2 + 1, this.sliderBounds.y() + 1, this.getThumbX() + this.getThumbWidth() / 2 + 1, this.sliderBounds.yLimit() + 1, -12566464);
        graphics.m_280509_(this.getThumbX() - this.getThumbWidth() / 2, this.sliderBounds.y().intValue(), this.getThumbX() + this.getThumbWidth() / 2, this.sliderBounds.yLimit().intValue(), -1);
    }

    @Override
    protected void drawValueText(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        graphics.m_280168_().m_85836_();
        if (this.isHovered()) {
            graphics.m_280168_().m_252880_(-((float)(this.sliderBounds.width() + 6) + (float)this.getThumbWidth() / 2.0f), 0.0f, 0.0f);
        }
        super.drawValueText(graphics, mouseX, mouseY, delta);
        graphics.m_280168_().m_85849_();
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (!this.isAvailable() || button != 0 || !this.sliderBounds.isPointInside((int)mouseX, (int)mouseY)) {
            return false;
        }
        this.mouseDown = true;
        this.setValueFromMouse(mouseX);
        return true;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (!this.isAvailable() || button != 0 || !this.mouseDown) {
            return false;
        }
        this.setValueFromMouse(mouseX);
        return true;
    }

    public void incrementValue(double amount) {
        ((ISliderController)this.control).setPendingValue(Mth.m_14008_((double)(((ISliderController)this.control).pendingValue() + this.interval * amount), (double)this.min, (double)this.max));
        this.calculateInterpolation();
    }

    public boolean m_6050_(double mouseX, double mouseY, double vertical) {
        if (!this.isAvailable() || !this.m_5953_(mouseX, mouseY) || !Screen.m_96638_() && !Screen.m_96637_()) {
            return false;
        }
        this.incrementValue(vertical);
        return true;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.isAvailable() && this.mouseDown) {
            this.playDownSound();
        }
        this.mouseDown = false;
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (!this.focused) {
            return false;
        }
        switch (keyCode) {
            case 263: {
                this.incrementValue(-1.0);
                break;
            }
            case 262: {
                this.incrementValue(1.0);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean m_5953_(double mouseX, double mouseY) {
        return super.m_5953_(mouseX, mouseY) || this.mouseDown;
    }

    protected void setValueFromMouse(double mouseX) {
        double value = (mouseX - (double)this.sliderBounds.x().intValue()) / (double)this.sliderBounds.width().intValue() * ((ISliderController)this.control).range();
        ((ISliderController)this.control).setPendingValue(this.roundToInterval(value));
        this.calculateInterpolation();
    }

    protected double roundToInterval(double value) {
        return Mth.m_14008_((double)(this.min + this.interval * (double)Math.round(value / this.interval)), (double)this.min, (double)this.max);
    }

    @Override
    protected int getHoveredControlWidth() {
        return this.sliderBounds.width() + this.getUnhoveredControlWidth() + 6 + this.getThumbWidth() / 2;
    }

    protected void calculateInterpolation() {
        this.interpolation = Mth.m_14036_((float)((float)((((ISliderController)this.control).pendingValue() - ((ISliderController)this.control).min()) * 1.0 / ((ISliderController)this.control).range())), (float)0.0f, (float)1.0f);
    }

    @Override
    public void setDimension(Dimension<Integer> dim) {
        super.setDimension(dim);
        int trackWidth = dim.width() / 3;
        if (this.optionNameString.isEmpty()) {
            trackWidth = dim.width() / 2;
        }
        this.sliderBounds = Dimension.ofInt(dim.xLimit() - this.getXPadding() - this.getThumbWidth() / 2 - trackWidth, dim.centerY() - 5, trackWidth, 10);
    }

    protected int getThumbX() {
        return (int)((float)this.sliderBounds.x().intValue() + (float)this.sliderBounds.width().intValue() * this.interpolation);
    }

    protected int getThumbWidth() {
        return 4;
    }
}

