/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl3.gui.controllers.string;

import dev.isxander.yacl3.api.OptionEventListener;
import dev.isxander.yacl3.api.utils.Dimension;
import dev.isxander.yacl3.gui.YACLScreen;
import dev.isxander.yacl3.gui.controllers.ControllerWidget;
import dev.isxander.yacl3.gui.controllers.string.IStringController;
import dev.isxander.yacl3.gui.utils.GuiUtils;
import dev.isxander.yacl3.gui.utils.UndoRedoHelper;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class StringControllerElement
extends ControllerWidget<IStringController<?>> {
    protected final boolean instantApply;
    protected String inputField;
    protected Dimension<Integer> inputFieldBounds;
    protected boolean inputFieldFocused;
    protected int caretPos;
    protected int previousCaretPos;
    protected int selectionLength;
    protected int renderOffset;
    protected UndoRedoHelper undoRedoHelper;
    protected float ticks;
    protected float caretTicks;
    private final Component emptyText;

    public StringControllerElement(IStringController<?> control, YACLScreen screen, Dimension<Integer> dim, boolean instantApply) {
        super(control, screen, dim);
        this.instantApply = instantApply;
        this.inputField = control.getString();
        this.inputFieldFocused = false;
        this.selectionLength = 0;
        this.emptyText = Component.m_237113_((String)"Click to type...").m_130940_(ChatFormatting.GRAY);
        control.option().addEventListener((opt, event) -> {
            if (event == OptionEventListener.Event.STATE_CHANGE) {
                this.inputField = control.getString();
            }
        });
        this.setDimension(dim);
    }

    @Override
    protected void drawHoveredControl(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
    }

    @Override
    protected void drawValueText(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        Component valueText = this.getValueText();
        if (!this.isHovered()) {
            valueText = Component.m_237113_((String)GuiUtils.shortenString(valueText.getString(), this.textRenderer, this.getMaxUnwrapLength(), "...")).m_6270_(valueText.m_7383_());
        }
        int textX = this.getDimension().xLimit() - this.textRenderer.m_92852_((FormattedText)valueText) + this.renderOffset - this.getXPadding();
        graphics.m_280588_(this.inputFieldBounds.x().intValue(), this.inputFieldBounds.y() - 2, this.inputFieldBounds.xLimit() + 1, this.inputFieldBounds.yLimit() + 4);
        graphics.m_280614_(this.textRenderer, valueText, textX, this.getTextY(), this.getValueColor(), true);
        if (this.isHovered()) {
            this.ticks += delta;
            String text = this.getValueText().getString();
            graphics.m_280509_(this.inputFieldBounds.x().intValue(), this.inputFieldBounds.yLimit().intValue(), this.inputFieldBounds.xLimit().intValue(), this.inputFieldBounds.yLimit() + 1, -1);
            graphics.m_280509_(this.inputFieldBounds.x() + 1, this.inputFieldBounds.yLimit() + 1, this.inputFieldBounds.xLimit() + 1, this.inputFieldBounds.yLimit() + 2, -12566464);
            if (this.inputFieldFocused || this.focused) {
                float f;
                if (this.caretPos > text.length()) {
                    this.caretPos = text.length();
                }
                int caretX = textX + this.textRenderer.m_92895_(text.substring(0, this.caretPos));
                if (text.isEmpty()) {
                    caretX = this.inputFieldBounds.x() + this.inputFieldBounds.width() / 2;
                }
                if (this.selectionLength != 0) {
                    int selectionX = textX + this.textRenderer.m_92895_(text.substring(0, this.caretPos + this.selectionLength));
                    graphics.m_280509_(caretX, this.inputFieldBounds.y() - 2, selectionX, this.inputFieldBounds.yLimit() - 1, -2144325377);
                }
                if (this.caretPos != this.previousCaretPos) {
                    this.previousCaretPos = this.caretPos;
                    this.caretTicks = 0.0f;
                }
                this.caretTicks += delta;
                if (f % 20.0f <= 10.0f) {
                    graphics.m_280509_(caretX, this.inputFieldBounds.y() - 2, caretX + 1, this.inputFieldBounds.yLimit() - 1, -1);
                }
            }
        }
        graphics.m_280618_();
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.isAvailable() && this.getDimension().isPointInside((int)mouseX, (int)mouseY)) {
            this.inputFieldFocused = true;
            if (!this.inputFieldBounds.isPointInside((int)mouseX, (int)mouseY)) {
                this.caretPos = this.getDefaultCaretPos();
            } else {
                int textX = (int)mouseX - (this.inputFieldBounds.xLimit() - this.textRenderer.m_92852_((FormattedText)this.getValueText()));
                int pos = -1;
                int currentWidth = 0;
                for (char ch : this.inputField.toCharArray()) {
                    ++pos;
                    int charLength = this.textRenderer.m_92895_(String.valueOf(ch));
                    if (currentWidth + charLength / 2 > textX) {
                        this.caretPos = pos;
                        break;
                    }
                    if (pos == this.inputField.length() - 1) {
                        this.caretPos = pos + 1;
                    }
                    currentWidth += charLength;
                }
                this.selectionLength = 0;
            }
            return true;
        }
        this.unfocus();
        return false;
    }

    protected int getDefaultCaretPos() {
        return this.inputField.length();
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (!this.inputFieldFocused) {
            return false;
        }
        switch (keyCode) {
            case 256: 
            case 257: {
                this.unfocus();
                return true;
            }
            case 263: {
                if (Screen.m_96638_()) {
                    if (Screen.m_96637_()) {
                        int spaceChar = this.findSpaceIndex(true);
                        this.selectionLength += this.caretPos - spaceChar;
                        this.caretPos = spaceChar;
                    } else if (this.caretPos > 0) {
                        --this.caretPos;
                        ++this.selectionLength;
                    }
                    this.checkRenderOffset();
                } else {
                    if (this.caretPos > 0) {
                        this.caretPos = Screen.m_96637_() ? this.findSpaceIndex(true) : (this.selectionLength != 0 ? (this.caretPos += Math.min(this.selectionLength, 0)) : --this.caretPos);
                    }
                    this.checkRenderOffset();
                    this.selectionLength = 0;
                }
                return true;
            }
            case 262: {
                if (Screen.m_96638_()) {
                    if (Screen.m_96637_()) {
                        int spaceChar = this.findSpaceIndex(false);
                        this.selectionLength -= spaceChar - this.caretPos;
                        this.caretPos = spaceChar;
                    } else if (this.caretPos < this.inputField.length()) {
                        ++this.caretPos;
                        --this.selectionLength;
                    }
                    this.checkRenderOffset();
                } else {
                    if (this.caretPos < this.inputField.length()) {
                        this.caretPos = Screen.m_96637_() ? this.findSpaceIndex(false) : (this.selectionLength != 0 ? (this.caretPos += Math.max(this.selectionLength, 0)) : ++this.caretPos);
                        this.checkRenderOffset();
                    }
                    this.selectionLength = 0;
                }
                return true;
            }
            case 259: {
                this.doBackspace();
                return true;
            }
            case 261: {
                this.doDelete();
                return true;
            }
            case 269: {
                this.selectionLength = Screen.m_96638_() ? (this.selectionLength -= this.inputField.length() - this.caretPos) : 0;
                this.caretPos = this.inputField.length();
                this.checkRenderOffset();
                return true;
            }
            case 268: {
                if (Screen.m_96638_()) {
                    this.selectionLength += this.caretPos;
                    this.caretPos = 0;
                } else {
                    this.caretPos = 0;
                    this.selectionLength = 0;
                }
                this.checkRenderOffset();
                return true;
            }
        }
        if (Screen.m_96630_((int)keyCode)) {
            return this.doPaste();
        }
        if (Screen.m_96632_((int)keyCode)) {
            return this.doCopy();
        }
        if (Screen.m_96628_((int)keyCode)) {
            return this.doCut();
        }
        if (Screen.m_96634_((int)keyCode)) {
            return this.doSelectAll();
        }
        return false;
    }

    protected boolean doPaste() {
        this.write(this.client.f_91068_.m_90876_());
        this.updateUndoHistory();
        return true;
    }

    protected boolean doCopy() {
        if (this.selectionLength != 0) {
            this.client.f_91068_.m_90911_(this.getSelection());
            return true;
        }
        return false;
    }

    protected boolean doCut() {
        if (this.selectionLength != 0) {
            this.client.f_91068_.m_90911_(this.getSelection());
            this.write("");
            this.updateUndoHistory();
            return true;
        }
        return false;
    }

    protected boolean doSelectAll() {
        this.caretPos = this.inputField.length();
        this.checkRenderOffset();
        this.selectionLength = -this.caretPos;
        return true;
    }

    protected void checkRenderOffset() {
        if (this.textRenderer.m_92895_(this.inputField) < this.getUnshiftedLength()) {
            this.renderOffset = 0;
            return;
        }
        int textX = this.getDimension().xLimit() - this.textRenderer.m_92895_(this.inputField) - this.getXPadding();
        int caretX = textX + this.textRenderer.m_92895_(this.inputField.substring(0, this.caretPos));
        int minX = this.getDimension().xLimit() - this.getXPadding() - this.getUnshiftedLength();
        int maxX = minX + this.getUnshiftedLength();
        if (caretX + this.renderOffset < minX) {
            this.renderOffset = minX - caretX;
        } else if (caretX + this.renderOffset > maxX) {
            this.renderOffset = maxX - caretX;
        }
    }

    public boolean m_5534_(char chr, int modifiers) {
        if (!this.inputFieldFocused) {
            return false;
        }
        if (!Screen.m_96637_()) {
            this.write(Character.toString(chr));
            this.updateUndoHistory();
            return true;
        }
        return false;
    }

    protected void doBackspace() {
        if (this.selectionLength != 0) {
            this.write("");
        } else if (this.caretPos > 0 && this.modifyInput(builder -> builder.deleteCharAt(this.caretPos - 1))) {
            --this.caretPos;
            this.checkRenderOffset();
        }
        this.updateUndoHistory();
    }

    protected void doDelete() {
        if (this.selectionLength != 0) {
            this.write("");
        } else if (this.caretPos < this.inputField.length()) {
            this.modifyInput(builder -> builder.deleteCharAt(this.caretPos));
        }
        this.updateUndoHistory();
    }

    public void write(String string) {
        if (this.selectionLength == 0) {
            if (this.modifyInput(builder -> builder.insert(this.caretPos, string))) {
                this.caretPos += string.length();
                this.checkRenderOffset();
            }
        } else {
            int end;
            int start = this.getSelectionStart();
            if (this.modifyInput(arg_0 -> StringControllerElement.lambda$write$4(start, end = this.getSelectionEnd(), string, arg_0))) {
                this.caretPos = start + string.length();
                this.selectionLength = 0;
                this.checkRenderOffset();
            }
        }
    }

    public boolean modifyInput(Consumer<StringBuilder> consumer) {
        StringBuilder temp = new StringBuilder(this.inputField);
        consumer.accept(temp);
        if (!((IStringController)this.control).isInputValid(temp.toString())) {
            return false;
        }
        this.inputField = temp.toString();
        if (this.instantApply) {
            this.updateControl();
        }
        return true;
    }

    protected void updateUndoHistory() {
    }

    public int getUnshiftedLength() {
        if (this.optionNameString.isEmpty()) {
            return this.getDimension().width() - this.getXPadding() * 2;
        }
        return this.getDimension().width() / 8 * 5;
    }

    public int getMaxUnwrapLength() {
        if (this.optionNameString.isEmpty()) {
            return this.getDimension().width() - this.getXPadding() * 2;
        }
        return this.getDimension().width() / 2;
    }

    public int getSelectionStart() {
        return Math.min(this.caretPos, this.caretPos + this.selectionLength);
    }

    public int getSelectionEnd() {
        return Math.max(this.caretPos, this.caretPos + this.selectionLength);
    }

    protected String getSelection() {
        return this.inputField.substring(this.getSelectionStart(), this.getSelectionEnd());
    }

    protected int findSpaceIndex(boolean reverse) {
        int i;
        int fromIndex = this.caretPos;
        if (reverse) {
            if (this.caretPos > 0) {
                fromIndex -= 2;
            }
            i = this.inputField.lastIndexOf(" ", fromIndex) + 1;
        } else {
            if (this.caretPos < this.inputField.length()) {
                ++fromIndex;
            }
            if ((i = this.inputField.indexOf(" ", fromIndex) + 1) == 0) {
                i = this.inputField.length();
            }
        }
        return i;
    }

    @Override
    public void m_93692_(boolean focused) {
        super.m_93692_(focused);
        this.inputFieldFocused = focused;
    }

    @Override
    public void unfocus() {
        super.unfocus();
        this.inputFieldFocused = false;
        this.renderOffset = 0;
        if (!this.instantApply) {
            this.updateControl();
        }
    }

    @Override
    public void setDimension(Dimension<Integer> dim) {
        super.setDimension(dim);
        int width = Math.max(6, Math.min(this.textRenderer.m_92852_((FormattedText)this.getValueText()), this.getUnshiftedLength()));
        int n = dim.xLimit() - this.getXPadding() - width;
        int n2 = dim.centerY();
        Objects.requireNonNull(this.textRenderer);
        int n3 = n2 - 9 / 2;
        Objects.requireNonNull(this.textRenderer);
        this.inputFieldBounds = Dimension.ofInt(n, n3, width, 9);
    }

    @Override
    public boolean isHovered() {
        return super.isHovered() || this.inputFieldFocused;
    }

    protected void updateControl() {
        ((IStringController)this.control).setFromString(this.inputField);
    }

    @Override
    protected int getUnhoveredControlWidth() {
        return !this.isHovered() ? Math.min(this.getHoveredControlWidth(), this.getMaxUnwrapLength()) : this.getHoveredControlWidth();
    }

    @Override
    protected int getHoveredControlWidth() {
        return Math.min(this.textRenderer.m_92852_((FormattedText)this.getValueText()), this.getUnshiftedLength());
    }

    @Override
    protected Component getValueText() {
        if (!this.inputFieldFocused && this.inputField.isEmpty()) {
            return this.emptyText;
        }
        return this.instantApply || !this.inputFieldFocused ? ((IStringController)this.control).formatValue() : Component.m_237113_((String)this.inputField);
    }

    private static /* synthetic */ void lambda$write$4(int start, int end, String string, StringBuilder builder) {
        builder.replace(start, end, string);
    }
}

