/*
 * Decompiled with CFR 0.152.
 */
package com.mcwwindows.kikoz.objects;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class Curtain
extends Block {
    private static final EnumProperty<TiedEnum> TIED = EnumProperty.m_61587_((String)"tied", TiedEnum.class);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    String infoname;
    boolean hasTextInfo = true;
    protected static final VoxelShape WEST = Shapes.m_83124_((VoxelShape)Curtain.m_49796_((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[0]);
    protected static final VoxelShape SOUTH = Shapes.m_83124_((VoxelShape)Curtain.m_49796_((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[0]);
    protected static final VoxelShape EAST = Shapes.m_83124_((VoxelShape)Curtain.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0), (VoxelShape[])new VoxelShape[0]);
    protected static final VoxelShape NORTH = Shapes.m_83124_((VoxelShape)Curtain.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[0]);

    public VoxelShape m_5940_(BlockState state, BlockGetter blockReader, BlockPos pos, CollisionContext selectionContext) {
        switch ((Direction)state.m_61143_((Property)FACING)) {
            case NORTH: {
                return NORTH;
            }
            case SOUTH: {
                return SOUTH;
            }
            case EAST: {
                return EAST;
            }
            case WEST: {
                return WEST;
            }
        }
        return null;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return Shapes.m_83040_();
    }

    public Curtain(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(TIED, (Comparable)((Object)TiedEnum.NONE)));
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public void onBroken(Level worldIn, BlockPos pos) {
        worldIn.m_46796_(1029, pos, 0);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = super.m_5573_(context);
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122427_());
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        boolean isCrouching = player.m_6047_();
        ItemStack itemstack = player.m_21120_(hand);
        Item item = itemstack.m_41720_();
        if (item == this.m_5456_()) {
            return InteractionResult.PASS;
        }
        int cycleDirection = isCrouching ? -1 : 1;
        TiedEnum currentTied = (TiedEnum)((Object)state.m_61143_(TIED));
        int nextIndex = (currentTied.ordinal() + cycleDirection + TiedEnum.values().length) % TiedEnum.values().length;
        TiedEnum nextTied = TiedEnum.values()[nextIndex];
        state = (BlockState)state.m_61124_(TIED, (Comparable)((Object)nextTied));
        world.m_7731_(pos, state, 2);
        return InteractionResult.SUCCESS;
    }

    public BlockState updatePostPlacement(BlockState stateIn, Direction facing, BlockState facingState, Level worldIn, BlockPos currentPos, BlockPos facingPos) {
        return super.m_7417_(stateIn, facing, facingState, (LevelAccessor)worldIn, currentPos, facingPos);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{TIED, FACING});
    }

    public static enum TiedEnum implements StringRepresentable
    {
        NONE("none"),
        LEFT("left"),
        RIGHT("right"),
        HALF_RIGHT_TIE("half_right_tie"),
        HALF_RIGHT("half_right"),
        HALF_RIGHT_BOTTOM("half_right_bottom"),
        HALF_LEFT_TIE("half_left_tie"),
        HALF_LEFT("half_left"),
        HALF_LEFT_BOTTOM("half_left_bottom"),
        SINGLE("single"),
        HALF_SINGLE("half_single"),
        BASE_WAVE("base_wave"),
        BASE_HALF_WAVE("base_half_wave");

        private final String name;

        private TiedEnum(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String getString() {
            return this.name;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

