/*
 * Decompiled with CFR 0.152.
 */
package fuzs.illagerinvasion.world.entity.ai.goal;

import fuzs.illagerinvasion.init.ModRegistry;
import fuzs.illagerinvasion.world.entity.monster.Marauder;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.item.Item;

public class HatchetAttackGoal
extends RangedAttackGoal {
    public static final UniformInt COOLDOWN_RANGE = TimeUtil.m_145020_((int)1, (int)2);
    private final Monster hostile;
    private final float squaredRange;
    private final double speed;
    private int seeingTargetTicker;
    private int cooldown = -1;
    private int chargeTime = 0;

    public HatchetAttackGoal(RangedAttackMob mob, double mobSpeed, int intervalTicks, float maxShootRange) {
        super(mob, mobSpeed, intervalTicks, maxShootRange);
        this.hostile = (Marauder)mob;
        this.speed = mobSpeed;
        this.squaredRange = maxShootRange * maxShootRange;
    }

    public boolean m_8036_() {
        return super.m_8036_() && this.hostile.m_21205_().m_150930_((Item)ModRegistry.PLATINUM_INFUSED_HATCHET_ITEM.get());
    }

    public void m_8056_() {
        super.m_8056_();
        this.hostile.m_21561_(true);
        this.hostile.m_6672_(InteractionHand.MAIN_HAND);
    }

    public void m_8041_() {
        super.m_8041_();
        this.hostile.m_5810_();
        this.hostile.m_21561_(false);
        this.seeingTargetTicker = 0;
    }

    public void m_8037_() {
        LivingEntity target = this.hostile.m_5448_();
        if (target == null) {
            this.chargeTime = 0;
            if (this.hostile instanceof Marauder) {
                ((Marauder)this.hostile).setCharging(false);
            }
            return;
        }
        boolean bl = this.hostile.m_21574_().m_148306_((Entity)target);
        this.hostile.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
        boolean bl2 = this.seeingTargetTicker > 0;
        boolean bl4 = bl2;
        if (bl != bl2) {
            this.seeingTargetTicker = 0;
        }
        this.seeingTargetTicker = bl ? ++this.seeingTargetTicker : --this.seeingTargetTicker;
        double d = this.hostile.m_20280_((Entity)target);
        boolean bl3 = d > (double)this.squaredRange || this.seeingTargetTicker < 5;
        boolean bl5 = bl3;
        if (bl3) {
            --this.cooldown;
            if (this.cooldown <= 0) {
                this.hostile.m_21573_().m_5624_((Entity)target, this.speed);
                this.cooldown = COOLDOWN_RANGE.m_214085_(this.hostile.m_217043_());
            }
        } else {
            this.cooldown = 0;
            this.hostile.m_21573_().m_26573_();
        }
        --this.chargeTime;
        if (this.hostile instanceof Marauder) {
            if (this.chargeTime == -40) {
                ((Marauder)this.hostile).setCharging(true);
            }
            if (this.chargeTime == -80) {
                ((Marauder)this.hostile).m_6504_(target, 1.0f);
                ((Marauder)this.hostile).setCharging(false);
                this.chargeTime = 0;
            }
        }
    }
}

