/*
 * Decompiled with CFR 0.152.
 */
package fuzs.illagerinvasion.world.entity.monster;

import fuzs.illagerinvasion.world.entity.ai.goal.PotionBowAttackGoal;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class Alchemist
extends AbstractIllager
implements RangedAttackMob {
    private static final EntityDataAccessor<Boolean> DATA_HOLDING_POTION = SynchedEntityData.m_135353_(Alchemist.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_HOLDING_BOW = SynchedEntityData.m_135353_(Alchemist.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public int potionCooldown = 160;

    public Alchemist(EntityType<? extends Alchemist> entityType, Level world) {
        super(entityType, world);
        this.f_21364_ = 10;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(4, new PotionBowAttackGoal<Alchemist>(this, 0.5, 20, 15.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).m_26146_(300));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false).m_26146_(300));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, false));
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData, @Nullable CompoundTag entityNbt) {
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42411_));
        return super.m_6518_(world, difficulty, spawnReason, entityData, entityNbt);
    }

    public void m_6504_(LivingEntity target, float pullProgress) {
        if (this.m_6844_(EquipmentSlot.MAINHAND).m_150930_(Items.f_42739_)) {
            Potion potion = PotionUtils.m_43579_((ItemStack)this.m_6844_(EquipmentSlot.MAINHAND));
            Vec3 deltaMovement = target.m_20184_();
            double d = target.m_20185_() + deltaMovement.f_82479_ - this.m_20185_();
            double e = target.m_20188_() - 1.1 - this.m_20186_();
            double f = target.m_20189_() + deltaMovement.f_82481_ - this.m_20189_();
            double g = Math.sqrt(d * d + f * f);
            ThrownPotion potionEntity = new ThrownPotion(this.m_9236_(), (LivingEntity)this);
            potionEntity.m_37446_(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42739_), (Potion)potion));
            potionEntity.m_146926_(potionEntity.m_146909_() + 20.0f);
            potionEntity.m_6686_(d, e + g * 0.2, f, 0.75f, 8.0f);
            if (!this.m_20067_()) {
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12553_, this.m_5720_(), 1.0f, 0.8f + this.f_19796_.m_188501_() * 0.4f);
            }
            this.m_9236_().m_7967_((Entity)potionEntity);
            this.setBowState(true);
            return;
        }
        ItemStack itemStack = this.m_6298_(this.m_21120_(ProjectileUtil.m_37297_((LivingEntity)this, (Item)Items.f_42411_)));
        AbstractArrow persistentProjectileEntity = ProjectileUtil.m_37300_((LivingEntity)this, (ItemStack)itemStack, (float)pullProgress);
        double d = target.m_20185_() - this.m_20185_();
        double e = target.m_20227_(0.33) - persistentProjectileEntity.m_20186_();
        double f = target.m_20189_() - this.m_20189_();
        double g = Math.sqrt(d * d + f * f);
        persistentProjectileEntity.m_6686_(d, e + g * 0.2, f, 1.6f, (float)(14 - this.m_9236_().m_46791_().m_19028_() * 4));
        this.m_5496_(SoundEvents.f_12382_, 1.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
        this.m_9236_().m_7967_((Entity)persistentProjectileEntity);
    }

    public void m_7380_(CompoundTag nbt) {
        nbt.m_128379_("BowState", this.getBowState());
        nbt.m_128379_("PotionState", this.getPotionState());
        super.m_7380_(nbt);
    }

    private void removeEffectsInCloud(AreaEffectCloud cloudEntity) {
        List nearbyIllagers = this.m_9236_().m_6443_(AbstractIllager.class, cloudEntity.m_20191_().m_82400_(0.3), Entity::m_6084_);
        for (LivingEntity entity : nearbyIllagers) {
            cloudEntity.m_146791_().m_43488_().stream().findAny().map(MobEffectInstance::m_19544_).ifPresent(arg_0 -> ((LivingEntity)entity).m_21195_(arg_0));
        }
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.setPotionState(nbt.m_128471_("PotionState"));
        this.setBowState(nbt.m_128471_("BowState"));
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_HOLDING_POTION, (Object)false);
        this.f_19804_.m_135372_(DATA_HOLDING_BOW, (Object)true);
        super.m_8097_();
    }

    public boolean getPotionState() {
        return (Boolean)this.f_19804_.m_135370_(DATA_HOLDING_POTION);
    }

    public void setPotionState(boolean potionState) {
        this.f_19804_.m_135381_(DATA_HOLDING_POTION, (Object)potionState);
    }

    public boolean getBowState() {
        return (Boolean)this.f_19804_.m_135370_(DATA_HOLDING_BOW);
    }

    public void setBowState(boolean bowState) {
        this.f_19804_.m_135381_(DATA_HOLDING_BOW, (Object)bowState);
    }

    public SoundEvent m_7930_() {
        return SoundEvents.f_11863_;
    }

    protected void m_8024_() {
        List nearbyClouds = this.m_9236_().m_6443_(AreaEffectCloud.class, this.m_20191_().m_82400_(30.0), Entity::m_6084_);
        for (AreaEffectCloud areaEffectCloud : nearbyClouds) {
            this.removeEffectsInCloud(areaEffectCloud);
        }
        --this.potionCooldown;
        if (this.potionCooldown <= 0) {
            this.setPotionState(true);
            this.potionCooldown = 160;
        }
        ItemStack mainHandItem = this.m_21120_(InteractionHand.MAIN_HAND);
        if (this.getBowState() && mainHandItem.m_150930_(Items.f_42739_)) {
            this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42411_));
            this.setPotionState(false);
        }
        if (this.getPotionState() && mainHandItem.m_150930_(Items.f_42411_)) {
            Potion potion = null;
            int randvalue = this.f_19796_.m_188503_(3);
            if (randvalue == 0) {
                potion = Potions.f_43584_;
            }
            if (randvalue == 1) {
                potion = Potions.f_43615_;
            }
            if (randvalue == 2) {
                potion = Potions.f_43593_;
            }
            this.m_8061_(EquipmentSlot.MAINHAND, PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42739_), (Potion)potion));
            this.setBowState(false);
        }
        super.m_8024_();
    }

    public boolean m_7301_(MobEffectInstance effectInstance) {
        return effectInstance.m_19544_() != MobEffects.f_19614_ && super.m_7301_(effectInstance);
    }

    public boolean m_7307_(Entity other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (super.m_7307_(other)) {
            return true;
        }
        if (other instanceof Vex) {
            return this.m_7307_((Entity)((Vex)other).m_19749_());
        }
        return other instanceof LivingEntity && ((LivingEntity)other).m_6336_() == MobType.f_21643_ && this.m_5647_() == null && other.m_5647_() == null;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12048_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12050_;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return SoundEvents.f_12051_;
    }

    public void m_7895_(int wave, boolean unused) {
    }

    public AbstractIllager.IllagerArmPose m_6768_() {
        if (this.m_5912_() && this.m_6844_(EquipmentSlot.MAINHAND).m_150930_(Items.f_42411_)) {
            return AbstractIllager.IllagerArmPose.BOW_AND_ARROW;
        }
        if (this.m_5912_() && this.m_6844_(EquipmentSlot.MAINHAND).m_150930_(Items.f_42739_)) {
            return AbstractIllager.IllagerArmPose.ATTACKING;
        }
        return AbstractIllager.IllagerArmPose.CROSSED;
    }
}

