/*
 * Decompiled with CFR 0.152.
 */
package fuzs.illagerinvasion.world.entity.monster;

import fuzs.illagerinvasion.init.ModRegistry;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.monster.SpellcasterIllager;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;

public class Provoker
extends SpellcasterIllager
implements RangedAttackMob {
    private int buffAllyCooldown;

    public Provoker(EntityType<? extends Provoker> entityType, Level world) {
        super(entityType, world);
        this.f_21364_ = 10;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new LookAtTargetOrWololoTarget());
        this.f_21345_.m_25352_(3, (Goal)new BuffAllyGoal());
        this.f_21345_.m_25352_(4, (Goal)new RangedBowAttackGoal((Monster)this, 0.5, 20, 15.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).m_26146_(300));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false).m_26146_(300));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, false));
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData, @Nullable CompoundTag entityNbt) {
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42411_));
        return super.m_6518_(world, difficulty, spawnReason, entityData, entityNbt);
    }

    public void m_6504_(LivingEntity target, float pullProgress) {
        ItemStack itemStack = this.m_6298_(this.m_21120_(ProjectileUtil.m_37297_((LivingEntity)this, (Item)Items.f_42411_)));
        AbstractArrow persistentProjectileEntity = ProjectileUtil.m_37300_((LivingEntity)this, (ItemStack)itemStack, (float)pullProgress);
        double d = target.m_20185_() - this.m_20185_();
        double e = target.m_20227_(0.3333333333333333) - persistentProjectileEntity.m_20186_();
        double f = target.m_20189_() - this.m_20189_();
        double g = Math.sqrt(d * d + f * f);
        persistentProjectileEntity.m_6686_(d, e + g * (double)0.2f, f, 1.6f, (float)(14 - this.m_9236_().m_46791_().m_19028_() * 4));
        this.m_5496_(SoundEvents.f_12382_, 1.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
        this.m_9236_().m_7967_((Entity)persistentProjectileEntity);
    }

    public float m_5610_(BlockPos pos, LevelReader level) {
        return 0.0f;
    }

    public int m_5792_() {
        return 1;
    }

    public SoundEvent m_7930_() {
        return (SoundEvent)ModRegistry.PROVOKER_CELEBRATE_SOUND_EVENT.get();
    }

    protected void m_8024_() {
        --this.buffAllyCooldown;
        super.m_8024_();
    }

    public boolean m_7307_(Entity other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (super.m_7307_(other)) {
            return true;
        }
        if (other instanceof Vex) {
            return this.m_7307_((Entity)((Vex)other).m_19749_());
        }
        if (other instanceof LivingEntity && ((LivingEntity)other).m_6336_() == MobType.f_21643_) {
            return this.m_5647_() == null && other.m_5647_() == null;
        }
        return false;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModRegistry.PROVOKER_AMBIENT_SOUND_EVENT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModRegistry.PROVOKER_DEATH_SOUND_EVENT.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)ModRegistry.PROVOKER_HURT_SOUND_EVENT.get();
    }

    protected SoundEvent m_7894_() {
        return SoundEvents.f_11862_;
    }

    public void m_7895_(int wave, boolean unused) {
    }

    public AbstractIllager.IllagerArmPose m_6768_() {
        if (this.m_33736_()) {
            return AbstractIllager.IllagerArmPose.SPELLCASTING;
        }
        if (this.m_5912_()) {
            return AbstractIllager.IllagerArmPose.BOW_AND_ARROW;
        }
        return AbstractIllager.IllagerArmPose.CROSSED;
    }

    class LookAtTargetOrWololoTarget
    extends SpellcasterIllager.SpellcasterCastingSpellGoal {
        LookAtTargetOrWololoTarget() {
            super((SpellcasterIllager)Provoker.this);
        }

        public void m_8037_() {
            if (Provoker.this.m_5448_() != null) {
                Provoker.this.m_21563_().m_24960_((Entity)Provoker.this.m_5448_(), (float)Provoker.this.m_8085_(), (float)Provoker.this.m_8132_());
            }
        }
    }

    public class BuffAllyGoal
    extends SpellcasterIllager.SpellcasterUseSpellGoal {
        public BuffAllyGoal() {
            super((SpellcasterIllager)Provoker.this);
        }

        public boolean m_8036_() {
            if (Provoker.this.m_5448_() == null) {
                return false;
            }
            return Provoker.this.buffAllyCooldown < 0;
        }

        private List<LivingEntity> getTargets() {
            return Provoker.this.m_9236_().m_6443_(LivingEntity.class, Provoker.this.m_20191_().m_82400_(12.0), entity -> entity instanceof AbstractIllager);
        }

        public void m_8041_() {
            super.m_8041_();
        }

        private void buff(LivingEntity entity) {
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 120, 0));
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 120, 0));
            double x = entity.m_20185_();
            double y = entity.m_20186_() + 1.0;
            double z = entity.m_20189_();
            ((ServerLevel)Provoker.this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123792_, x, y, z, 10, 0.4, 0.4, 0.4, 0.15);
        }

        protected void m_8130_() {
            Provoker.this.buffAllyCooldown = 300;
            this.getTargets().forEach(this::buff);
        }

        protected int m_8069_() {
            return 40;
        }

        protected int m_8089_() {
            return 60;
        }

        protected int m_8067_() {
            return 140;
        }

        protected SoundEvent m_7030_() {
            return SoundEvents.f_12053_;
        }

        protected SpellcasterIllager.IllagerSpell m_7269_() {
            return (SpellcasterIllager.IllagerSpell)ModRegistry.PROVOKE_ILLAGER_SPELL;
        }
    }
}

