/*
 * Decompiled with CFR 0.152.
 */
package fuzs.illagerinvasion.world.entity.monster;

import fuzs.illagerinvasion.init.ModRegistry;
import fuzs.illagerinvasion.util.SetMagicFireUtil;
import fuzs.illagerinvasion.util.TeleportUtil;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.SpellcasterIllager;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;

public class Sorcerer
extends SpellcasterIllager {
    private int castTeleportCooldown;
    private int conjureFlamesCooldown;

    public Sorcerer(EntityType<? extends Sorcerer> entityType, Level world) {
        super(entityType, world);
        this.f_21364_ = 10;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new LookAtTargetOrWololoTarget());
        this.f_21345_.m_25352_(4, (Goal)new CastTeleportGoal());
        this.f_21345_.m_25352_(3, (Goal)new ConjureFlamesGoal());
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(5, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 8.0f, 0.6, 1.0));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).m_26146_(300));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false).m_26146_(300));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, false));
    }

    public SoundEvent m_7930_() {
        return (SoundEvent)ModRegistry.SORCERER_CELEBRATE_SOUND_EVENT.get();
    }

    protected void m_8024_() {
        super.m_8024_();
        --this.castTeleportCooldown;
        --this.conjureFlamesCooldown;
    }

    public boolean m_7307_(Entity other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (super.m_7307_(other)) {
            return true;
        }
        if (other instanceof Vex) {
            return this.m_7307_((Entity)((Vex)other).m_19749_());
        }
        if (other instanceof LivingEntity && ((LivingEntity)other).m_6336_() == MobType.f_21643_) {
            return this.m_5647_() == null && other.m_5647_() == null;
        }
        return false;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModRegistry.SORCERER_AMBIENT_SOUND_EVENT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModRegistry.SORCERER_DEATH_SOUND_EVENT.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)ModRegistry.SORCERER_HURT_SOUND_EVENT.get();
    }

    protected SoundEvent m_7894_() {
        return (SoundEvent)ModRegistry.SORCERER_COMPLETE_CAST_SOUND_EVENT.get();
    }

    public void m_7895_(int wave, boolean unused) {
    }

    public AbstractIllager.IllagerArmPose m_6768_() {
        if (this.m_33736_()) {
            return AbstractIllager.IllagerArmPose.SPELLCASTING;
        }
        return AbstractIllager.IllagerArmPose.CROSSED;
    }

    class LookAtTargetOrWololoTarget
    extends SpellcasterIllager.SpellcasterCastingSpellGoal {
        LookAtTargetOrWololoTarget() {
            super((SpellcasterIllager)Sorcerer.this);
        }

        public void m_8037_() {
            if (Sorcerer.this.m_5448_() != null) {
                Sorcerer.this.m_21563_().m_24960_((Entity)Sorcerer.this.m_5448_(), (float)Sorcerer.this.m_8085_(), (float)Sorcerer.this.m_8132_());
            }
        }
    }

    public class CastTeleportGoal
    extends SpellcasterIllager.SpellcasterUseSpellGoal {
        public CastTeleportGoal() {
            super((SpellcasterIllager)Sorcerer.this);
        }

        public boolean m_8036_() {
            if (Sorcerer.this.m_5448_() == null) {
                return false;
            }
            if (Sorcerer.this.m_33736_()) {
                return false;
            }
            return Sorcerer.this.castTeleportCooldown < 0 && !this.getTargets().isEmpty();
        }

        private List<LivingEntity> getTargets() {
            return Sorcerer.this.m_9236_().m_6443_(LivingEntity.class, Sorcerer.this.m_20191_().m_82400_(8.0), entity -> entity instanceof Player || entity instanceof IronGolem);
        }

        public boolean m_8045_() {
            return !this.getTargets().isEmpty();
        }

        protected void m_8130_() {
            Sorcerer.this.castTeleportCooldown = 220;
            double x = Sorcerer.this.m_20185_();
            double y = Sorcerer.this.m_20186_() + 1.0;
            double z = Sorcerer.this.m_20189_();
            if (Sorcerer.this.m_9236_() instanceof ServerLevel) {
                ((ServerLevel)Sorcerer.this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123771_, x, y, z, 30, 0.3, 0.5, 0.3, 0.015);
            }
            TeleportUtil.tryRandomTeleport((LivingEntity)Sorcerer.this);
        }

        protected int m_8069_() {
            return 30;
        }

        protected int m_8089_() {
            return 30;
        }

        protected int m_8067_() {
            return 400;
        }

        protected SoundEvent m_7030_() {
            return (SoundEvent)ModRegistry.SORCERER_CAST_SOUND_EVENT.get();
        }

        protected SpellcasterIllager.IllagerSpell m_7269_() {
            return (SpellcasterIllager.IllagerSpell)ModRegistry.CONJURE_TELEPORT_ILLAGER_SPELL;
        }
    }

    public class ConjureFlamesGoal
    extends SpellcasterIllager.SpellcasterUseSpellGoal {
        public ConjureFlamesGoal() {
            super((SpellcasterIllager)Sorcerer.this);
        }

        public boolean m_8036_() {
            if (Sorcerer.this.m_5448_() == null) {
                return false;
            }
            if (Sorcerer.this.m_33736_()) {
                return false;
            }
            return Sorcerer.this.conjureFlamesCooldown < 0;
        }

        protected void m_8130_() {
            LivingEntity target = Sorcerer.this.m_5448_();
            SetMagicFireUtil.trySetFire(target, Sorcerer.this.m_9236_());
            Sorcerer.this.conjureFlamesCooldown = 100;
            target.m_6469_(Sorcerer.this.m_269291_().m_269425_(), 3.0f);
            if (Sorcerer.this.m_9236_() instanceof ServerLevel) {
                ((ServerLevel)Sorcerer.this.m_9236_()).m_8767_((ParticleOptions)((SimpleParticleType)ModRegistry.MAGIC_FLAME_PARTICLE_TYPE.get()), target.m_20185_(), target.m_20186_() + 1.0, target.m_20189_(), 30, 0.3, 0.5, 0.3, 0.08);
            }
        }

        protected int m_8069_() {
            return 60;
        }

        protected int m_8089_() {
            return 60;
        }

        protected int m_8067_() {
            return 140;
        }

        protected SoundEvent m_7030_() {
            return (SoundEvent)ModRegistry.SORCERER_CAST_SOUND_EVENT.get();
        }

        protected SpellcasterIllager.IllagerSpell m_7269_() {
            return (SpellcasterIllager.IllagerSpell)ModRegistry.CONJURE_FLAMES_ILLAGER_SPELL;
        }
    }
}

