/*
 * Decompiled with CFR 0.152.
 */
package fuzs.illagerinvasion.world.entity.monster;

import fuzs.illagerinvasion.init.ModRegistry;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class Surrendered
extends Skeleton {
    protected static final EntityDataAccessor<Byte> DATA_VEX_FLAGS = SynchedEntityData.m_135353_(Surrendered.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final int CHARGING_FLAG = 1;
    @Nullable
    Mob owner;
    @Nullable
    private BlockPos bounds;
    private boolean alive;
    private int lifeTicks;

    public Surrendered(EntityType<? extends Surrendered> entityType, Level world) {
        super(entityType, world);
        this.f_21342_ = new VexMoveControl(this);
    }

    public void m_6478_(MoverType movementType, Vec3 movement) {
        super.m_6478_(movementType, movement);
        this.m_20101_();
    }

    public void m_8119_() {
        super.m_8119_();
        this.m_20242_(true);
        if (this.alive && --this.lifeTicks <= 0) {
            this.lifeTicks = 20;
            this.m_6469_(this.m_269291_().m_269064_(), 1.0f);
        }
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new ChargeTargetGoal());
        this.f_21345_.m_25352_(8, (Goal)new LookAtTargetGoal());
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new TrackOwnerTargetGoal((PathfinderMob)this));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_VEX_FLAGS, (Object)0);
    }

    public boolean m_142535_(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        return false;
    }

    protected float m_6431_(Pose pose, EntityDimensions dimensions) {
        return dimensions.f_20378_ * 0.8f;
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        if (nbt.m_128441_("BoundX")) {
            this.bounds = new BlockPos(nbt.m_128451_("BoundX"), nbt.m_128451_("BoundY"), nbt.m_128451_("BoundZ"));
        }
        if (nbt.m_128441_("LifeTicks")) {
            this.setLifeTicks(nbt.m_128451_("LifeTicks"));
        }
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        if (this.bounds != null) {
            nbt.m_128405_("BoundX", this.bounds.m_123341_());
            nbt.m_128405_("BoundY", this.bounds.m_123342_());
            nbt.m_128405_("BoundZ", this.bounds.m_123343_());
        }
        if (this.alive) {
            nbt.m_128405_("LifeTicks", this.lifeTicks);
        }
    }

    @Nullable
    public Mob getOwner() {
        return this.owner;
    }

    public void setOwner(Mob owner) {
        this.owner = owner;
    }

    @Nullable
    public BlockPos getBounds() {
        return this.bounds;
    }

    public void setBounds(@Nullable BlockPos pos) {
        this.bounds = pos;
    }

    private boolean areFlagsSet(int mask) {
        byte i = (Byte)this.f_19804_.m_135370_(DATA_VEX_FLAGS);
        return (i & mask) != 0;
    }

    private void setVexFlag(int mask, boolean value) {
        int i = ((Byte)this.f_19804_.m_135370_(DATA_VEX_FLAGS)).byteValue();
        i = value ? (i |= mask) : (i &= ~mask);
        this.f_19804_.m_135381_(DATA_VEX_FLAGS, (Object)((byte)(i & 0xFF)));
    }

    public boolean isCharging() {
        return this.areFlagsSet(1);
    }

    public void setCharging(boolean charging) {
        this.setVexFlag(1, charging);
    }

    public void setLifeTicks(int lifeTicks) {
        this.alive = true;
        this.lifeTicks = lifeTicks;
    }

    public boolean m_7327_(Entity target) {
        if (!super.m_7327_(target)) {
            return false;
        }
        if (target instanceof LivingEntity) {
            ((LivingEntity)target).m_147207_(new MobEffectInstance(MobEffects.f_19597_, 60, 1), (Entity)this);
        }
        return true;
    }

    public void m_8107_() {
        if (!this.m_9236_().m_5776_()) {
            for (int i = 0; i < 2; ++i) {
                ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123790_, this.f_19854_, this.f_19855_ + 1.2, this.f_19856_, 2, 0.2, 0.0, 0.2, 0.025);
            }
        }
        super.m_8107_();
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModRegistry.SURRENDERED_AMBIENT_SOUND_EVENT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModRegistry.SURRENDERED_DEATH_SOUND_EVENT.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)ModRegistry.SURRENDERED_HURT_SOUND_EVENT.get();
    }

    public float m_213856_() {
        return 1.0f;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData, @Nullable CompoundTag entityNbt) {
        this.m_213945_(world.m_213780_(), difficulty);
        this.m_213946_(world.m_213780_(), difficulty);
        return super.m_6518_(world, difficulty, spawnReason, entityData, entityNbt);
    }

    protected void m_213945_(RandomSource randomSource, DifficultyInstance difficulty) {
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_41852_));
        this.m_21409_(EquipmentSlot.MAINHAND, 0.0f);
    }

    class VexMoveControl
    extends MoveControl {
        public VexMoveControl(Surrendered owner) {
            super((Mob)owner);
        }

        public void m_8126_() {
            if (this.f_24981_ != MoveControl.Operation.MOVE_TO) {
                return;
            }
            Vec3 vec3d = new Vec3(this.f_24975_ - Surrendered.this.m_20185_(), this.f_24976_ - Surrendered.this.m_20186_(), this.f_24977_ - Surrendered.this.m_20189_());
            double d = vec3d.m_82553_();
            if (d < Surrendered.this.m_20191_().m_82309_()) {
                this.f_24981_ = MoveControl.Operation.WAIT;
                Surrendered.this.m_20256_(Surrendered.this.m_20184_().m_82490_(0.5));
            } else {
                Surrendered.this.m_20256_(Surrendered.this.m_20184_().m_82549_(vec3d.m_82490_(this.f_24978_ * 0.05 / d)));
                if (Surrendered.this.m_5448_() == null) {
                    Vec3 vec3d2 = Surrendered.this.m_20184_();
                    Surrendered.this.m_146922_(-((float)Mth.m_14136_((double)vec3d2.f_82479_, (double)vec3d2.f_82481_)) * 57.295776f);
                    Surrendered.this.f_20883_ = Surrendered.this.m_146908_();
                } else {
                    double e = Surrendered.this.m_5448_().m_20185_() - Surrendered.this.m_20185_();
                    double f = Surrendered.this.m_5448_().m_20189_() - Surrendered.this.m_20189_();
                    Surrendered.this.m_146922_(-((float)Mth.m_14136_((double)e, (double)f)) * 57.295776f);
                    Surrendered.this.f_20883_ = Surrendered.this.m_146908_();
                }
            }
        }
    }

    class ChargeTargetGoal
    extends Goal {
        public ChargeTargetGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (Surrendered.this.m_5448_() != null && !Surrendered.this.m_21566_().m_24995_() && Surrendered.this.f_19796_.m_188503_(ChargeTargetGoal.m_186073_((int)7)) == 0) {
                return Surrendered.this.m_20280_((Entity)Surrendered.this.m_5448_()) > 4.0;
            }
            return false;
        }

        public boolean m_8045_() {
            return Surrendered.this.m_21566_().m_24995_() && Surrendered.this.isCharging() && Surrendered.this.m_5448_() != null && Surrendered.this.m_5448_().m_6084_();
        }

        public void m_8056_() {
            LivingEntity livingEntity = Surrendered.this.m_5448_();
            if (livingEntity != null) {
                Vec3 vec3d = livingEntity.m_146892_();
                Surrendered.this.f_21342_.m_6849_(vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_, 1.0);
            }
            Surrendered.this.setCharging(true);
            Surrendered.this.m_5496_((SoundEvent)ModRegistry.SURRENDERED_CHARGE_SOUND_EVENT.get(), 1.0f, 1.0f);
        }

        public void m_8041_() {
            Surrendered.this.setCharging(false);
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            LivingEntity livingEntity = Surrendered.this.m_5448_();
            if (livingEntity == null) {
                return;
            }
            if (Surrendered.this.m_20191_().m_82381_(livingEntity.m_20191_())) {
                Surrendered.this.m_7327_((Entity)livingEntity);
                Surrendered.this.setCharging(false);
            } else {
                double d = Surrendered.this.m_20280_((Entity)livingEntity);
                if (d < 9.0) {
                    Vec3 vec3d = livingEntity.m_146892_();
                    Surrendered.this.f_21342_.m_6849_(vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_, 1.0);
                }
            }
        }
    }

    class LookAtTargetGoal
    extends Goal {
        public LookAtTargetGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return !Surrendered.this.m_21566_().m_24995_() && Surrendered.this.f_19796_.m_188503_(LookAtTargetGoal.m_186073_((int)7)) == 0;
        }

        public boolean m_8045_() {
            return false;
        }

        public void m_8037_() {
            BlockPos blockPos = Surrendered.this.getBounds();
            if (blockPos == null) {
                blockPos = Surrendered.this.m_20183_();
            }
            for (int i = 0; i < 3; ++i) {
                BlockPos blockPos2 = blockPos.m_7918_(Surrendered.this.f_19796_.m_188503_(15) - 7, Surrendered.this.f_19796_.m_188503_(11) - 5, Surrendered.this.f_19796_.m_188503_(15) - 7);
                if (!Surrendered.this.m_9236_().m_46859_(blockPos2)) continue;
                Surrendered.this.f_21342_.m_6849_((double)blockPos2.m_123341_() + 0.5, (double)blockPos2.m_123342_() + 0.5, (double)blockPos2.m_123343_() + 0.5, 0.25);
                if (Surrendered.this.m_5448_() != null) break;
                Surrendered.this.m_21563_().m_24950_((double)blockPos2.m_123341_() + 0.5, (double)blockPos2.m_123342_() + 0.5, (double)blockPos2.m_123343_() + 0.5, 180.0f, 20.0f);
                break;
            }
        }
    }

    class TrackOwnerTargetGoal
    extends TargetGoal {
        private final TargetingConditions targetPredicate;

        public TrackOwnerTargetGoal(PathfinderMob mob) {
            super((Mob)mob, false);
            this.targetPredicate = TargetingConditions.m_148353_().m_148355_().m_26893_();
        }

        public boolean m_8036_() {
            return Surrendered.this.owner != null && Surrendered.this.owner.m_5448_() != null && this.m_26150_(Surrendered.this.owner.m_5448_(), this.targetPredicate);
        }

        public void m_8056_() {
            Surrendered.this.m_6710_(Surrendered.this.owner.m_5448_());
            super.m_8056_();
        }
    }
}

