/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adlods;

import com.endertech.common.CommonString;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.data.ServerCommand;
import com.endertech.minecraft.forge.math.RandomWrapper;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.forge.world.ChunkBounds;
import com.endertech.minecraft.mods.adlods.AdLods;
import com.endertech.minecraft.mods.adlods.deposit.Deposit;
import com.endertech.minecraft.mods.adlods.deposit.DepositGenerator;
import com.endertech.minecraft.mods.adlods.geode.Geode;
import com.endertech.minecraft.mods.adlods.geode.GeodeGenerator;
import com.endertech.minecraft.mods.adlods.ore.AbstractOre;
import com.endertech.minecraft.mods.adlods.target.AbstractTarget;
import com.endertech.minecraft.mods.adlods.target.AbstractTargetGenerator;
import com.endertech.minecraft.mods.adlods.target.TargetGenResult;
import com.endertech.minecraft.mods.adlods.vanilla.VanillaController;
import com.endertech.minecraft.mods.adlods.vanilla.VanillaOre;
import com.endertech.minecraft.mods.adlods.world.ChunkStripper;
import com.endertech.minecraft.mods.adlods.world.WorldTargets;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.StringJoiner;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.blocks.BlockInput;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.commands.arguments.coordinates.Coordinates;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fml.loading.FMLPaths;
import org.slf4j.Logger;

final class Commands {
    Commands() {
    }

    private static DepositGenerator depositGenerator() {
        return (DepositGenerator)((Object)AdLods.getInstance().features.depositGenerator.get());
    }

    private static GeodeGenerator geodeGenerator() {
        return (GeodeGenerator)((Object)AdLods.getInstance().features.geodeGenerator.get());
    }

    private static VanillaController vanillaController() {
        return (VanillaController)((Object)AdLods.getInstance().features.vanillaController.get());
    }

    public static ServerCommand.Arg<String> depositName() {
        return Commands.targetNameArgument(Commands.depositGenerator());
    }

    public static ServerCommand.Arg<String> geodeName() {
        return Commands.targetNameArgument(Commands.geodeGenerator());
    }

    public static ServerCommand.Arg<String> veinName() {
        return ServerCommand.Arg.word((String)"name", (context, builder) -> SharedSuggestionProvider.m_82981_(Commands.vanillaController().streamOres().map(VanillaOre::getName), (SuggestionsBuilder)builder));
    }

    private static String getTargetName(ServerCommand.Context context) {
        return (String)context.getArgument("name", String.class);
    }

    public static ServerCommand.Arg<String> targetNameArgument(AbstractTargetGenerator<?> generator) {
        return ServerCommand.Arg.word((String)"name", (context, builder) -> SharedSuggestionProvider.m_82981_(generator.getTargets().stream().map(AbstractTarget::getName), (SuggestionsBuilder)builder));
    }

    public static void listActiveDeposits(ServerCommand.Context context) {
        Commands.listTargets(context, Commands.depositGenerator());
    }

    public static void listActiveGeodes(ServerCommand.Context context) {
        Commands.listTargets(context, Commands.geodeGenerator());
    }

    public static <T extends AbstractTarget> void listTargets(ServerCommand.Context context, AbstractTargetGenerator<T> generator) {
        StringJoiner joiner = new StringJoiner(", ");
        for (AbstractTarget target : generator.getTargets()) {
            joiner.add(target.getName());
        }
        context.sendMessage(generator.getCategory() + ": " + joiner);
    }

    public static void listAllGenerated(ServerCommand.Context context) {
        Collection<TargetGenResult> targets = WorldTargets.get(context.getLevel()).generated().values();
        Commands.listGenerated(context, targets);
    }

    public static void listGeneratedAround(ServerCommand.Context context) {
        int radius = context.getLevel().m_7654_().m_6846_().m_11312_();
        List<TargetGenResult> targets = WorldTargets.get(context.getLevel()).generated().values().stream().filter(res -> AbstractOre.withinRadius(new ChunkPos(res.pos), new ChunkPos(context.getBlockPos()), radius)).toList();
        Commands.listGenerated(context, targets);
    }

    private static void listGenerated(ServerCommand.Context context, Collection<TargetGenResult> targets) {
        Logger logger = AdLods.getInstance().getLogger();
        if (targets.isEmpty()) {
            context.sendMessage("No data on generated targets is available");
        } else {
            logger.info("Targets: {");
            targets.forEach(data -> logger.info("\t" + data));
            logger.info("}");
            context.sendMessage("List of generated targets (" + targets.size() + ") was written to .minecraft/logs/latest.log");
        }
    }

    public static void locateNearestDeposit(ServerCommand.Context context) {
        Commands.locateNearestTarget(context, "Deposit");
    }

    public static void locateNearestGeode(ServerCommand.Context context) {
        Commands.locateNearestTarget(context, "Geode");
    }

    private static void locateNearestTarget(ServerCommand.Context context, String target) {
        BlockPos currentPos = context.getBlockPos();
        String name = Commands.getTargetName(context);
        Optional<TargetGenResult> result = WorldTargets.get(context.getLevel()).generated().values().stream().filter(res -> res.target.equals(target) && res.name.equals(name)).min(Comparator.comparingDouble(res -> res.pos.m_123331_((Vec3i)currentPos)));
        if (result.isPresent()) {
            BlockPos pos = result.get().pos;
            MutableComponent blocksAway = Component.m_237113_((String)("(" + (int)Math.sqrt(pos.m_123331_((Vec3i)currentPos)) + " blocks away)"));
            MutableComponent tpLink = Component.m_237113_((String)" [->] ").m_130938_(style -> style.m_131140_(ChatFormatting.GREEN).m_131142_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/tp @s " + pos.m_123341_() + " ~ " + pos.m_123343_())).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"chat.coordinates.tooltip"))));
            MutableComponent message = Component.m_237113_((String)result.get().toString()).m_7220_((Component)tpLink).m_7220_((Component)blocksAway);
            context.source.m_288197_(() -> message, false);
        } else {
            context.sendMessage("Nothing found");
        }
    }

    private static void openFile(Path path) {
        Util.m_137581_().m_137644_(path.toFile());
    }

    public static void openConfigsFolder(ServerCommand.Context context) {
        Commands.openFile(AdLods.getInstance().getConfigsDir());
    }

    public static void openLatestLog(ServerCommand.Context context) {
        Path latestLog = FMLPaths.GAMEDIR.get().resolve(Paths.get("logs", "latest.log"));
        Commands.openFile(latestLog);
    }

    public static void openDepositConfig(ServerCommand.Context context) {
        Commands.openTargetConfig(context, Commands.depositGenerator());
    }

    public static void openGeodeConfig(ServerCommand.Context context) {
        Commands.openTargetConfig(context, Commands.geodeGenerator());
    }

    private static void openTargetConfig(ServerCommand.Context context, AbstractTargetGenerator<?> generator) {
        Path baseDir = generator.getConfigsDir();
        String name = Commands.getTargetName(context);
        Path config = UnitConfig.buildPath((Path)baseDir, (String)name);
        Commands.openFile(config);
    }

    public static void defineDeposit(ServerCommand.Context context) {
        Commands.defineTarget(context, Commands.depositGenerator(), Commands::createCustomDeposit, false);
    }

    public static void defineDepositAndEdit(ServerCommand.Context context) {
        Commands.defineTarget(context, Commands.depositGenerator(), Commands::createCustomDeposit, true);
    }

    public static void defineGeode(ServerCommand.Context context) {
        Commands.defineTarget(context, Commands.geodeGenerator(), Commands::createCustomGeode, false);
    }

    public static void defineGeodeAndEdit(ServerCommand.Context context) {
        Commands.defineTarget(context, Commands.geodeGenerator(), Commands::createCustomGeode, true);
    }

    private static <T extends AbstractTarget> void defineTarget(ServerCommand.Context context, AbstractTargetGenerator<T> generator, ICustomTargetFactory<T> factory, boolean openConfig) {
        Path baseDir = generator.getConfigsDir();
        String name = Commands.getTargetName(context);
        File configFile = UnitConfig.buildPath((Path)baseDir, (String)name).toFile();
        AbstractTarget target = generator.findByName(name).orElse(null);
        if (target != null) {
            String fileName = target.getConfig().getConfigFile().getName();
            context.sendMessage("Target with this name already defined in: " + fileName);
            context.sendMessage("Make a unique name or use the </lods remove> command");
            return;
        }
        target = factory.create(context, baseDir, name);
        context.sendMessage("Config file <" + configFile.getName() + "> created");
        if (generator.addTarget(target)) {
            context.sendMessage("New definition loaded");
            if (openConfig) {
                context.sendMessage("Use </lods reload_configs> after editing and saving changes in the config file");
            }
        } else {
            context.sendMessage("Failed to load new definition! Check the config file");
            if (!openConfig) {
                context.sendMessage("Use the </lods open> command");
            }
        }
        if (openConfig) {
            Commands.openFile(configFile.toPath());
        }
    }

    private static Deposit createCustomDeposit(ServerCommand.Context context, Path baseDir, String name) {
        UnitId oreId = UnitId.from((BlockState)((BlockInput)context.getArgument("oreId", BlockInput.class)).m_114669_());
        int rarity = (Integer)context.getArgument("rarity", Integer.TYPE);
        Deposit.Size size = Deposit.Size.from((MinMaxBounds.Ints)context.getArgument("size", MinMaxBounds.Ints.class));
        Deposit.Altitude altitude = Deposit.Altitude.from((MinMaxBounds.Ints)context.getArgument("altitude", MinMaxBounds.Ints.class));
        return Commands.depositGenerator().createCustomDeposit(baseDir, name, size, altitude, rarity, new String[]{oreId.toString()}, new String[0]);
    }

    private static Geode createCustomGeode(ServerCommand.Context context, Path baseDir, String name) {
        UnitId oreId = UnitId.from((BlockState)((BlockInput)context.getArgument("oreId", BlockInput.class)).m_114669_());
        int rarity = (Integer)context.getArgument("rarity", Integer.TYPE);
        Deposit.Size size = Deposit.Size.from((MinMaxBounds.Ints)context.getArgument("size", MinMaxBounds.Ints.class));
        Deposit.Altitude altitude = Deposit.Altitude.from((MinMaxBounds.Ints)context.getArgument("altitude", MinMaxBounds.Ints.class));
        return null;
    }

    public static void removeDeposit(ServerCommand.Context context) {
        Commands.removeTarget(context, Commands.depositGenerator());
    }

    public static void removeGeode(ServerCommand.Context context) {
        Commands.removeTarget(context, Commands.geodeGenerator());
    }

    private static <T extends AbstractTarget> void removeTarget(ServerCommand.Context context, AbstractTargetGenerator<T> generator) {
        Path baseDir = generator.getConfigsDir();
        String name = Commands.getTargetName(context);
        File configFile = UnitConfig.buildPath((Path)baseDir, (String)name).toFile();
        AbstractTarget target = generator.findByName(name).orElse(null);
        if (target != null) {
            if (generator.removeTarget(target)) {
                context.sendMessage("Definition unloaded");
            }
            configFile = target.getConfig().getConfigFile();
        }
        if (configFile.delete()) {
            context.sendMessage("Config file <" + configFile.getName() + "> deleted");
        }
    }

    public static void spawnDepositUnderground(ServerCommand.Context context) {
        BlockPos startPos = context.getBlockPos();
        Commands.spawnTargetAt(context, Commands.depositGenerator(), startPos.m_123341_(), startPos.m_123343_());
    }

    public static void spawnGeodeUnderground(ServerCommand.Context context) {
        BlockPos startPos = context.getBlockPos();
        Commands.spawnTargetAt(context, Commands.geodeGenerator(), startPos.m_123341_(), startPos.m_123343_());
    }

    public static void spawnDepositHere(ServerCommand.Context context) {
        Commands.spawnTargetAt(context, Commands.depositGenerator(), context.getBlockPos(), Optional.empty(), true);
    }

    public static void spawnGeodeHere(ServerCommand.Context context) {
        Commands.spawnTargetAt(context, Commands.geodeGenerator(), context.getBlockPos(), Optional.empty(), true);
    }

    public static void spawnDepositAtPos(ServerCommand.Context context) {
        Commands.spawnTargetAtPos(context, Commands.depositGenerator(), false);
    }

    public static void spawnGeodeAtPos(ServerCommand.Context context) {
        Commands.spawnTargetAtPos(context, Commands.geodeGenerator(), false);
    }

    private static void spawnTargetAtPos(ServerCommand.Context context, AbstractTargetGenerator<?> generator, boolean testing) {
        BlockPos pos = ((Coordinates)context.getArgument("pos", Coordinates.class)).m_119568_(context.source);
        Commands.spawnTargetAt(context, generator, pos, Optional.empty(), false);
    }

    public static void spawnDepositAtChunk(ServerCommand.Context context) {
        Commands.spawnTargetAtChunk(context, Commands.depositGenerator());
    }

    public static void spawnGeodeAtChunk(ServerCommand.Context context) {
        Commands.spawnTargetAtChunk(context, Commands.geodeGenerator());
    }

    public static void spawnTargetAtChunk(ServerCommand.Context context, AbstractTargetGenerator<?> generator) {
        int x = (Integer)context.getArgument("chunkX", Integer.TYPE);
        int z = (Integer)context.getArgument("chunkZ", Integer.TYPE);
        ChunkBounds chunkBounds = ChunkBounds.from((LevelHeightAccessor)context.getLevel(), (ChunkPos)new ChunkPos(x, z));
        Commands.spawnTargetAt(context, generator, chunkBounds.getX().randomBetween(), chunkBounds.getZ().randomBetween());
    }

    private static void spawnTargetAt(ServerCommand.Context context, AbstractTargetGenerator<?> generator, int posX, int posZ) {
        String name = Commands.getTargetName(context);
        BlockPos pos = new BlockPos(posX, 0, posZ);
        ServerLevel level = context.getLevel();
        Random random = RandomWrapper.of((RandomSource)level.m_213780_());
        Commands.getTargetAndCheckPosition(context, generator, name, pos).ifPresent(target -> {
            TargetGenResult result = target.generateAt((WorldGenLevel)level, posX, posZ, random);
            context.sendMessage(result.toString());
        });
    }

    private static void spawnTargetAt(ServerCommand.Context context, AbstractTargetGenerator<?> generator, BlockPos pos, Optional<Integer> size, boolean testing) {
        String name = Commands.getTargetName(context);
        ServerLevel level = context.getLevel();
        Random random = RandomWrapper.of((RandomSource)level.m_213780_());
        Commands.getTargetAndCheckPosition(context, generator, name, pos).ifPresent(target -> {
            int amount = size.orElse(target.pickSizeToGenerate((WorldGenLevel)level, pos, random));
            TargetGenResult result = target.generateAt((WorldGenLevel)level, pos, amount, testing, random);
            context.sendMessage(result.toString());
        });
    }

    private static <T extends AbstractTarget> Optional<T> getTargetAndCheckPosition(ServerCommand.Context context, AbstractTargetGenerator<T> generator, String targetName, BlockPos pos) {
        Optional<T> target = generator.findByName(targetName);
        if (target.isPresent()) {
            if (context.getLevel().m_46749_(pos)) {
                return target;
            }
            context.sendMessage(BlockPosArgument.f_118234_.toString());
        } else {
            context.sendMessage(Commands.invalidNameMsg(targetName));
        }
        return Optional.empty();
    }

    private static <T extends AbstractOre> void testGenerationHere(ServerCommand.Context context, Function<String, Optional<T>> oreGetter, String argumentName) {
        ServerLevel level = context.getLevel();
        BlockPos pos = context.getBlockPos();
        String name = Commands.getTargetName(context);
        Random random = RandomWrapper.of((RandomSource)level.m_213780_());
        int amount = (Integer)context.getArgument(argumentName, Integer.TYPE);
        Optional<T> ore = oreGetter.apply(name);
        if (ore.isPresent()) {
            int count = ((AbstractOre)ore.get()).test((WorldGenLevel)level, pos, amount, random);
            context.sendMessage(((AbstractOre)ore.get()).getClassCategory() + "<" + name + "> generated " + count + " blocks");
        } else {
            context.sendMessage(Commands.invalidNameMsg(name));
        }
    }

    public static void testDepositHere(ServerCommand.Context context) {
        Commands.testGenerationHere(context, Commands.depositGenerator()::findByName, "size");
    }

    public static void testGeodeHere(ServerCommand.Context context) {
        Commands.testGenerationHere(context, Commands.geodeGenerator()::findByName, "radius");
    }

    public static void testVeinHere(ServerCommand.Context context) {
        Commands.testGenerationHere(context, Commands.vanillaController()::findOreByName, "size");
    }

    public static void reloadConfigs(ServerCommand.Context context) {
        AdLods.getInstance().features.reload();
        context.sendMessage("Configs reloaded");
    }

    public static void stripChunk(ServerCommand.Context context) {
        ChunkPos centerPos = new ChunkPos(context.getBlockPos());
        ChunkStripper stripper = ChunkStripper.getFor((Level)context.getLevel());
        stripper.stripChunk((Level)context.getLevel(), centerPos);
        context.sendMessage("Chunk at " + centerPos + " stripped");
    }

    public static void stripChunksAround(ServerCommand.Context context) {
        ChunkPos centerPos = new ChunkPos(context.getBlockPos());
        ChunkStripper stripper = ChunkStripper.getFor((Level)context.getLevel());
        stripper.stripChunksAround((Level)context.getLevel(), centerPos);
        context.sendMessage("Chunks around " + centerPos + " stripped");
    }

    public static void dressChunk(ServerCommand.Context context) {
        ChunkPos centerPos = new ChunkPos(context.getBlockPos());
        ChunkStripper stripper = ChunkStripper.getFor((Level)context.getLevel());
        stripper.dressChunk((Level)context.getLevel(), centerPos);
        context.sendMessage("Chunk at " + centerPos + " dressed");
    }

    public static void dressChunksAround(ServerCommand.Context context) {
        ChunkPos centerPos = new ChunkPos(context.getBlockPos());
        ChunkStripper stripper = ChunkStripper.getFor((Level)context.getLevel());
        stripper.dressChunksAround((Level)context.getLevel(), centerPos);
        context.sendMessage("Chunks around " + centerPos + " dressed");
    }

    public static void dressAllChunks(ServerCommand.Context context) {
        ChunkStripper stripper = ChunkStripper.getFor((Level)context.getLevel());
        stripper.dressAllChunks((Level)context.getLevel());
        context.sendMessage("All stripped chunks dressed");
    }

    public static String invalidNameMsg(String name) {
        return "Invalid name: " + CommonString.quoted((String)name);
    }

    private static interface ICustomTargetFactory<T extends AbstractTarget> {
        public T create(ServerCommand.Context var1, Path var2, String var3);
    }
}

