/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adlods.deposit;

import com.endertech.common.CommonCollect;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.math.Percentage;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.forge.world.Dimensions;
import com.endertech.minecraft.mods.adlods.deposit.DepositOreChain;
import com.endertech.minecraft.mods.adlods.ore.CustomReplacements;
import com.endertech.minecraft.mods.adlods.ore.WeightedOre;
import com.endertech.minecraft.mods.adlods.target.AbstractTarget;
import java.nio.file.Path;
import java.util.Random;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraftforge.common.ForgeConfigSpec;

public class Deposit
extends AbstractTarget {
    public static ForgeConfigSpec.ConfigValue<Double> globalSizeMultiplier;
    public static ForgeConfigSpec.ConfigValue<Double> globalSpawnRateMultiplier;
    protected final boolean vanilla;
    protected final IntBounds size;
    protected final CommonCollect.WeightedList<WeightedOre> ores;
    protected final CustomReplacements placements;

    public Deposit(UnitConfig config, Properties<?> props) {
        super(config, (AbstractTarget.Properties<?>)props);
        String category = this.getClassCategory();
        this.vanilla = UnitConfig.getBool((UnitConfig)config, (String)category, (String)"vanilla", (boolean)props.vanilla, (String)"Determines whether this deposit is considered vanilla.");
        this.size = UnitConfig.getIntBounds((UnitConfig)config, (String)category, (String)"Size", (IntBounds)props.size, (IntBounds)Size.BOUNDS, (String)"Size limits (in blocks) of this deposit.");
        this.ores = Deposit.parseOresFrom(UnitConfig.getStrArray((UnitConfig)config, (String)category, (String)"ores", (String[])props.ores, (String)"List of ores and their weights for this deposit.\nSyntax: oreId [, weight]\n\nId is a basic unit (block or item) identifier in <modId:unitName:meta> format.\nModId can be omitted for vanilla items. Meta can be omitted too if it equals 0.\nUnitName must be lowercase, words separated by '_', words order - from private to common (example: black_iron_ore).\nUse '*' char or '[]' as meta value to specify all possible values (all block states).\nTo define multiple block states, you can use block properties. The format is <modId:blockName:[prop1=value1, prop2=value2]>\nAlso you may use tags. The format is <#modId:tagPath> (example: #forge:ores/copper).\n\nWeight is used to define the proportions of the ores.\nFor example, the definition:\n     #forge:ores/gold, 1\n     #forge:ores/iron, 5\nmeans that gold and iron will be in the proportion 1 to 5.\n"), x$0 -> this.pickState((UnitId)x$0));
        this.placements = CustomReplacements.createAndLoad(config, category, props.customReplacements, this.replaceableBlocks, x$0 -> this.pickState((UnitId)x$0));
        this.ores.getElements().forEach(this.placements::addOre);
        this.saveConfig();
    }

    public static Deposit in(Path dir, Properties<?> props) {
        return new Deposit(UnitConfig.in((Path)dir, (String)props.name), props);
    }

    @Override
    public int pickSizeToGenerate(WorldGenLevel level, BlockPos originPos, Random random) {
        return Math.round((float)this.size.randomBetween(random).intValue() * ((Double)globalSizeMultiplier.get()).floatValue());
    }

    @Override
    protected int generate(WorldGenLevel level, BlockPos origin, BlockPos start, int size, boolean testing, Random random, int part) {
        return new DepositOreChain(level, this, origin, start, size, this.miscellaneous, testing, random).generate().getCount();
    }

    @Override
    public int test(WorldGenLevel level, BlockPos startPos, int amount, Random random) {
        return this.generate(level, startPos, amount, true, random);
    }

    @Override
    public boolean isValid() {
        return !this.name.isEmpty() && !this.placements.isEmpty() && this.size.getMin() > 0;
    }

    public boolean isVanilla() {
        return this.vanilla;
    }

    @Override
    public CustomReplacements getPlacements() {
        return this.placements;
    }

    @Override
    public Percentage getChance() {
        return Percentage.value((float)(this.chance.getValue() * ((Double)globalSpawnRateMultiplier.get()).floatValue()));
    }

    public static class Properties<T extends Properties<T>>
    extends AbstractTarget.Properties<T> {
        public IntBounds size = IntBounds.ZERO;
        public boolean vanilla = false;
        public String[] ores = new String[0];

        protected Properties(Class<T> selfClass, String name) {
            super(selfClass, name);
        }

        public static Properties<?> deposit(String name) {
            Properties<Properties> props = new Properties<Properties>(Properties.class, name);
            return (Properties)((Object)props.dimensionByName());
        }

        public static Properties<?> overworld(String name) {
            Properties<Properties> props = new Properties<Properties>(Properties.class, name);
            return (Properties)((Object)props.dimension(Dimensions.OVERWORLD));
        }

        public static Properties<?> nether(String name) {
            Properties<Properties> props = new Properties<Properties>(Properties.class, name);
            return (Properties)((Object)props.dimension(Dimensions.THE_NETHER));
        }

        public T size(int min, int max) {
            this.size = IntBounds.between((Integer)min, (Integer)max);
            return (T)((Object)((Properties)this.self));
        }

        public T vanilla() {
            this.vanilla = true;
            return (T)((Object)((Properties)this.self));
        }

        public T ores(String ... ores) {
            this.ores = ores;
            return (T)((Object)((Properties)this.self));
        }
    }

    public static class Size
    extends IntBounds {
        public static final IntBounds BOUNDS = IntBounds.between((Integer)1, (Integer)256000);
        public static final Size ZERO = new Size(0, 0);

        public static Size from(IntBounds bounds) {
            return new Size(bounds.getMin(), bounds.getMax());
        }

        public static Size from(MinMaxBounds.Ints bounds) {
            return Size.from(BOUNDS.fit(bounds));
        }

        public Size(Integer bound1, Integer bound2) {
            super(bound1, bound2);
        }
    }

    public static class Rarity
    extends IntBounds {
        public static final IntBounds BOUNDS = IntBounds.between((Integer)0, (Integer)256000);

        public Rarity(Integer bound1, Integer bound2) {
            super(bound1, bound2);
        }
    }

    public static class Altitude
    extends IntBounds {
        public static final IntBounds BOUNDS = IntBounds.INTEGER;
        public static final Altitude ZERO = new Altitude(0, 0);

        public static Altitude from(IntBounds bounds) {
            return new Altitude(bounds.getMin(), bounds.getMax());
        }

        public static Altitude from(MinMaxBounds.Ints bounds) {
            return Altitude.from(BOUNDS.fit(bounds));
        }

        public Altitude(Integer bound1, Integer bound2) {
            super(bound1, bound2);
        }
    }
}

