/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adlods.geode;

import com.endertech.common.FloatBounds;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.blocks.BlockStatesSet;
import com.endertech.minecraft.forge.configs.IHaveConfig;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.math.GameBounds;
import com.endertech.minecraft.forge.math.Percentage;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.forge.world.Dimensions;
import com.endertech.minecraft.mods.adlods.geode.GeodeLayer;
import com.endertech.minecraft.mods.adlods.geode.GeodeOreChain;
import com.endertech.minecraft.mods.adlods.ore.AbstractOrePlacements;
import com.endertech.minecraft.mods.adlods.target.AbstractTarget;
import com.endertech.minecraft.mods.adlods.target.AbstractTargetState;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;

public class Geode
extends AbstractTarget {
    public static final IntBounds RADIUS_BOUNDS = IntBounds.between((Integer)0, (Integer)64);
    public static final FloatBounds NOISE_BOUNDS = FloatBounds.between((Float)Float.valueOf(0.0f), (Float)Float.valueOf(10.0f));
    protected final float noiseMultiplier;
    protected final Placements placements;
    protected final Filling filling;
    protected final Layers layers;
    protected final Crystals crystals;
    protected final Crack crack;

    public Geode(UnitConfig config, Properties<?> props) {
        super(config, (AbstractTarget.Properties<?>)props);
        String category = this.getClassCategory();
        this.noiseMultiplier = UnitConfig.getFloat((UnitConfig)config, (String)category, (String)"noiseMultiplier", (float)props.noiseMultiplier, (FloatBounds)NOISE_BOUNDS, (String)"Determines how much noise will be applied to the final shape of the geode");
        this.placements = Placements.noConfig(this.replaceableBlocks, x$0 -> this.pickState((UnitId)x$0));
        this.filling = new Filling(config, category, props.fillingRadius, props.fillingPlacements, this.replaceableBlocks, x$0 -> this.pickState((UnitId)x$0));
        this.layers = new Layers(config, category, props.layers, this.replaceableBlocks, x$0 -> this.pickState((UnitId)x$0));
        this.crystals = new Crystals(config, category, props.crystalPlacements, this.replaceableBlocks, x$0 -> this.pickState((UnitId)x$0));
        this.crack = new Crack(config, category, props.crackChance, props.crackRadius, props.crackPlacements, this.replaceableBlocks, x$0 -> this.pickState((UnitId)x$0));
        this.placements.putAll(this.filling.placements());
        this.layers.stream().map(GeodeLayer.Data::placements).forEach(this.placements::putAll);
        this.placements.addOreBlocks(this.crystals.placements().getOreBlocks());
        this.placements.putAll(this.crack.placements());
        this.saveConfig();
    }

    public static float sphereVolume(float sphereRadius) {
        return 4.1887903f * sphereRadius * sphereRadius * sphereRadius;
    }

    public static float spheroidVolume(float vertRadius, float horizRadius) {
        return 4.1887903f * vertRadius * horizRadius * horizRadius;
    }

    public static int geodeSize(float outerRadius, float proportions, float noiseMultiplier) {
        float radius = outerRadius + 2.0f * noiseMultiplier;
        return Mth.m_14167_((float)Geode.spheroidVolume(Geode.vertRadius(radius, proportions), Geode.horizRadius(radius, proportions)));
    }

    public static float sphereRadius(float sphereVolume) {
        return (float)Math.cbrt(sphereVolume * 3.0f / ((float)Math.PI * 4));
    }

    public static float vertRadius(float radius, float proportions) {
        return proportions < 1.0f ? radius * proportions : radius;
    }

    public static float horizRadius(float radius, float proportions) {
        return proportions > 1.0f ? radius / proportions : radius;
    }

    @Override
    public Placements getPlacements() {
        return this.placements;
    }

    @Override
    public int pickSizeToGenerate(WorldGenLevel level, BlockPos originPos, Random random) {
        return new State(level, originPos, this, Optional.empty()).size();
    }

    @Override
    protected int generate(WorldGenLevel level, BlockPos origin, BlockPos start, int size, boolean testing, Random random, int part) {
        State geode = new State(level, origin, this, Optional.empty());
        return new GeodeOreChain(geode, start, size, this.miscellaneous, testing, random).generate().getCount();
    }

    @Override
    public int test(WorldGenLevel level, BlockPos startPos, int radius, Random random) {
        State geode = new State(level, startPos, this, Optional.of(radius));
        return new GeodeOreChain(geode, startPos, geode.size, this.miscellaneous, true, random).generate().getCount();
    }

    @Override
    public boolean isValid() {
        return !this.name.isEmpty() && (!this.filling.isEmpty() || !this.layers.allEmpty());
    }

    public static class Properties<T extends Properties<T>>
    extends AbstractTarget.Properties<T> {
        public EnumMap<GeodeLayer.Type, Pair<IntBounds, String[]>> layers = new EnumMap(GeodeLayer.Type.class);
        public IntBounds fillingRadius = IntBounds.ZERO;
        public String[] fillingPlacements = new String[0];
        public String[] crystalPlacements = new String[0];
        public String[] crackPlacements = new String[0];
        public Percentage crackChance = Percentage.ZERO;
        public IntBounds crackRadius = IntBounds.ZERO;
        public float noiseMultiplier = 0.0f;

        protected Properties(Class<T> selfClass, String name) {
            super(selfClass, name);
            Arrays.stream(GeodeLayer.Type.values()).forEach(l -> this.layers.put((GeodeLayer.Type)((Object)l), (Pair<IntBounds, String[]>)Pair.of((Object)IntBounds.of((Integer)1), (Object)new String[0])));
        }

        public static Properties<?> geode(String name) {
            Properties<Properties> props = new Properties<Properties>(Properties.class, name);
            return (Properties)((Object)props.dimensionByName());
        }

        public static Properties<?> overworld(String name) {
            Properties<Properties> props = new Properties<Properties>(Properties.class, name);
            return ((Properties)((Object)props.dimension(Dimensions.OVERWORLD))).defaultReplaceableBlocks();
        }

        public static Properties<?> nether(String name) {
            Properties<Properties> props = new Properties<Properties>(Properties.class, name);
            return ((Properties)((Object)props.dimension(Dimensions.THE_NETHER))).defaultReplaceableBlocks();
        }

        public T defaultReplaceableBlocks() {
            return this.addReplaceableBlocks("#minecraft:deepslate_ore_replaceables", "#minecraft:replaceable", "water:*", "lava:*");
        }

        public T addReplaceableBlocks(String ... blocks) {
            this.replaceableBlocks = (String[])ArrayUtils.addAll((Object[])this.replaceableBlocks, (Object[])blocks);
            return (T)((Object)((Properties)this.self));
        }

        public T filling(IntBounds radius, String ... placements) {
            this.fillingRadius = radius;
            this.fillingPlacements = placements;
            return (T)((Object)((Properties)this.self));
        }

        public T layer(GeodeLayer.Type layer, IntBounds width, String ... ores) {
            this.layers.put(layer, (Pair<IntBounds, String[]>)Pair.of((Object)width, (Object)ores));
            return (T)((Object)((Properties)this.self));
        }

        public T crystals(String ... placements) {
            this.crystalPlacements = placements;
            return (T)((Object)((Properties)this.self));
        }

        public T crack(Percentage chance, IntBounds radius, String ... placements) {
            this.crackChance = chance;
            this.crackRadius = radius;
            this.crackPlacements = placements;
            return (T)((Object)((Properties)this.self));
        }

        public T noise(float multiplier) {
            this.noiseMultiplier = multiplier;
            return (T)((Object)((Properties)this.self));
        }
    }

    public static class Placements
    extends AbstractOrePlacements {
        public static Placements createAndLoad(UnitConfig config, String category, String[] defaultPlacements, BlockStatesSet replaceableBlocks, Function<UnitId, Optional<BlockState>> oreMapper) {
            Placements placements = new Placements(config, category, "placements", defaultPlacements, replaceableBlocks, oreMapper);
            placements.loadData();
            return placements;
        }

        public static Placements noConfig(BlockStatesSet replaceableBlocks, Function<UnitId, Optional<BlockState>> oreMapper) {
            return new Placements(null, "", "", new String[0], replaceableBlocks, oreMapper);
        }

        protected Placements(UnitConfig config, String category, String key, String[] defaultPlacements, BlockStatesSet replaceableBlocks, Function<UnitId, Optional<BlockState>> oreMapper) {
            super(config, category, key, defaultPlacements, replaceableBlocks, oreMapper);
        }

        protected String getComment() {
            return " ";
        }
    }

    public static class Filling
    extends ConfiguredPart
    implements IPlacementsProvider {
        private final IntBounds radius;
        private final Placements placements;

        public Filling(UnitConfig config, String headCategory, IntBounds defaultRadius, String[] defaultPlacements, BlockStatesSet replaceableBlocks, Function<UnitId, Optional<BlockState>> mapper) {
            super(config);
            String category = this.expandClassCategory(headCategory);
            if (config != null) {
                config.setCategoryComment(category, "Geode internal filling\n\n  <placements> - list of blocks and their weights the filling will consist of.\n     Syntax:\n          Block: blockId\n          Block with weight: blockId, weight\n          Replacement: targetId -> replacementId\n          Replacement with weight: targetId -> replacementId, weight\n\n  <radius> - radius (in blocks) of the filling.\n");
            }
            this.radius = UnitConfig.getIntBounds((UnitConfig)config, (String)category, (String)"Radius", (IntBounds)defaultRadius, (IntBounds)RADIUS_BOUNDS, (String)"");
            this.placements = Placements.createAndLoad(config, category, defaultPlacements, replaceableBlocks, mapper);
        }

        public boolean isEmpty() {
            return this.radius.getMax() == 0 || this.placements.isEmpty();
        }

        public IntBounds radius() {
            return this.radius;
        }

        @Override
        public Placements placements() {
            return this.placements;
        }
    }

    public static class Layers
    extends ConfiguredPart {
        private final Map<GeodeLayer.Type, GeodeLayer.Data> layers = new EnumMap<GeodeLayer.Type, GeodeLayer.Data>(GeodeLayer.Type.class);

        public Layers(UnitConfig config, String headCategory, Map<GeodeLayer.Type, Pair<IntBounds, String[]>> layers, BlockStatesSet replaceableBlocks, Function<UnitId, Optional<BlockState>> mapper) {
            super(config);
            String category = this.expandClassCategory(headCategory);
            if (config != null) {
                config.setCategoryComment(category, "Geode wall layers\n\n  <placements> - list of blocks and their weights the geode layer will consist of.\n     Syntax:\n          Block: blockId\n          Block with weight: blockId, weight\n          Replacement: targetId -> replacementId\n          Replacement with weight: targetId -> replacementId, weight\n\n  <thickness> - thickness (in blocks) of the layer.\n");
            }
            for (GeodeLayer.Type layer : GeodeLayer.Type.values()) {
                String subcategory = this.expandClassCategory(headCategory, layer.toString());
                IntBounds thickness = UnitConfig.getIntBounds((UnitConfig)config, (String)subcategory, (String)"thickness", (IntBounds)((IntBounds)layers.get((Object)layer).getLeft()), (IntBounds)GeodeLayer.THICKNESS_BOUNDS, (String)"");
                Placements placements = Placements.createAndLoad(config, subcategory, (String[])layers.get((Object)layer).getRight(), replaceableBlocks, mapper);
                this.layers.put(layer, new GeodeLayer.Data(thickness, placements));
            }
        }

        public GeodeLayer.Data get(GeodeLayer.Type layer) {
            return this.layers.get((Object)layer);
        }

        public boolean allEmpty() {
            return this.stream().allMatch(GeodeLayer.Data::isEmpty);
        }

        public Stream<GeodeLayer.Data> stream() {
            return this.layers.values().stream();
        }
    }

    public static class Crystals
    extends ConfiguredPart
    implements IPlacementsProvider {
        private final Placements placements;

        public Crystals(UnitConfig config, String headCategory, String[] defaultPlacements, BlockStatesSet defaultReplaceableBlocks, Function<UnitId, Optional<BlockState>> mapper) {
            super(config);
            String category = this.expandClassCategory(headCategory);
            if (config != null) {
                config.setCategoryComment(category, "Geode crystals that appear on the inner wall layer of the geode.\n\n  <placements> - list of crystals and their chances of appearing (in percent).\n     Syntax:\n          groundId -> crystalId, chance\n");
            }
            this.placements = Placements.createAndLoad(config, category, defaultPlacements, defaultReplaceableBlocks, mapper);
        }

        @Override
        public Placements placements() {
            return this.placements;
        }
    }

    public static class Crack
    extends ConfiguredPart
    implements IPlacementsProvider {
        private final Percentage chance;
        private final IntBounds radius;
        private final Placements placements;

        public Crack(UnitConfig config, String headCategory, Percentage defaultChance, IntBounds defaultRadius, String[] defaultPlacements, BlockStatesSet replaceableBlocks, Function<UnitId, Optional<BlockState>> mapper) {
            super(config);
            String category = this.expandClassCategory(headCategory);
            if (config != null) {
                config.setCategoryComment(category, "\n  <placements> - list of blocks and their weights the crack will consist of.\n     Syntax:\n          Block: blockId\n          Block with weight: blockId, weight\n          Replacement: targetId -> replacementId\n          Replacement with weight: targetId -> replacementId, weight\n\n  <chance> - chance (in percent) of generating a crack.\n\n  <radius> - radius (in blocks) of the crack.\n");
            }
            this.chance = UnitConfig.getPercentage((UnitConfig)config, (String)category, (String)"chance", (Percentage)defaultChance, (FloatBounds)GameBounds.PERCENTAGE.getFloatBounds(), (String)"");
            this.radius = UnitConfig.getIntBounds((UnitConfig)config, (String)category, (String)"Radius", (IntBounds)defaultRadius, (IntBounds)RADIUS_BOUNDS, (String)"");
            this.placements = Placements.createAndLoad(config, category, defaultPlacements, replaceableBlocks, mapper);
        }

        public BlockPos position(BlockPos geodeOrigin, int geodeOuterRadius, int crackRadius, float proportions, Random random) {
            IntBounds radius = IntBounds.between((Integer)geodeOuterRadius, (Integer)crackRadius);
            int k = crackRadius > geodeOuterRadius ? -1 : 1;
            int scale = radius.getMax() - k * random.nextInt(radius.getMin());
            float horizLimit = Geode.horizRadius(geodeOuterRadius, proportions);
            float vertLimit = Geode.vertRadius(geodeOuterRadius, proportions);
            FloatBounds dxz = FloatBounds.between((Float)Float.valueOf(-horizLimit), (Float)Float.valueOf(horizLimit));
            FloatBounds dy = FloatBounds.between((Float)Float.valueOf(-vertLimit), (Float)Float.valueOf(vertLimit));
            Vec3 offset = new Vec3((double)dxz.randomBetween(random).floatValue(), (double)dy.randomBetween(random).floatValue(), (double)dxz.randomBetween(random).floatValue()).m_82541_().m_82490_((double)scale);
            return BlockPos.m_274446_((Position)Vec3.m_82528_((Vec3i)geodeOrigin).m_82549_(offset));
        }

        public Percentage chance() {
            return this.chance;
        }

        public IntBounds radius() {
            return this.radius;
        }

        @Override
        public Placements placements() {
            return this.placements;
        }
    }

    public static class State
    extends AbstractTargetState<Geode> {
        private final int fillingRadius;
        private final Map<GeodeLayer.Type, Integer> layerThickness;
        private final int outerRadius;
        private final float proportions;
        private final boolean hasCrack;
        private final int crackRadius;
        private final BlockPos crackPos;
        private final int size;

        public State(WorldGenLevel level, BlockPos originPos, Geode geode, Optional<Integer> fillingRadius) {
            super(level, originPos, geode);
            this.fillingRadius = fillingRadius.orElse(geode.filling.radius().randomBetween(this.random()));
            this.layerThickness = new HashMap<GeodeLayer.Type, Integer>();
            for (GeodeLayer.Type layer : GeodeLayer.Type.values()) {
                this.layerThickness.put(layer, geode.layers.get(layer).thickness().randomBetween(this.random()));
            }
            this.outerRadius = this.fillingRadius + this.layerThickness.values().stream().mapToInt(thick -> thick).sum();
            this.proportions = geode.getMiscellaneous().proportions;
            this.hasCrack = geode.crack.chance.takeChance(this.random());
            this.crackRadius = geode.crack.radius.randomBetween(this.random());
            this.crackPos = geode.crack.position(originPos, this.outerRadius, this.crackRadius, this.proportions, this.random());
            this.size = Geode.geodeSize(this.outerRadius, this.proportions, geode.noiseMultiplier);
        }

        public int fillingRadius() {
            return this.fillingRadius;
        }

        public int layerThickness(GeodeLayer.Type layer) {
            return this.layerThickness.get((Object)layer);
        }

        public int outerRadius() {
            return this.outerRadius;
        }

        public float proportions() {
            return this.proportions;
        }

        @Override
        public int size() {
            return this.size;
        }

        public boolean hasCrack() {
            return this.hasCrack;
        }

        public int crackRadius() {
            return this.crackRadius;
        }

        public BlockPos crackPos() {
            return this.crackPos;
        }
    }

    public static interface IPlacementsProvider {
        public Placements placements();
    }

    static abstract class ConfiguredPart
    implements IHaveConfig {
        private final UnitConfig config;

        public ConfiguredPart(UnitConfig config) {
            this.config = config;
        }

        public UnitConfig getConfig() {
            return this.config;
        }
    }
}

