/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adlods.geode;

import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.math.Percentage;
import com.endertech.minecraft.mods.adlods.AdLods;
import com.endertech.minecraft.mods.adlods.geode.Geode;
import com.endertech.minecraft.mods.adlods.geode.GeodeLayer;
import com.endertech.minecraft.mods.adlods.target.AbstractTarget;
import com.endertech.minecraft.mods.adlods.target.AbstractTargetGenerator;
import com.mojang.serialization.Codec;
import java.nio.file.Path;
import net.minecraftforge.common.world.BiomeModifier;

public class GeodeGenerator
extends AbstractTargetGenerator<Geode> {
    public GeodeGenerator(AbstractForgeMod mod) {
        super(mod, "Geodes");
    }

    public Codec<? extends BiomeModifier> codec() {
        return (Codec)AdLods.getInstance().codecs.geodeGenerator.get();
    }

    @Override
    protected Geode createTarget(UnitConfig config, String name) {
        return new Geode(config, Geode.Properties.overworld(name));
    }

    @Override
    protected void createDefaultTargets(Path dir) {
        if (dir.toFile().exists()) {
            return;
        }
        String name = "amethyst";
        new Geode(UnitConfig.in((Path)dir, (String)name), (Geode.Properties)((Object)((AbstractTarget.Properties)((Object)((Geode.Properties)((Object)((Geode.Properties)((Object)((Geode.Properties)((Object)((Geode.Properties)((Object)((Geode.Properties)((Object)((Geode.Properties)((Object)((Geode.Properties)((Object)((AbstractTarget.Properties)((Object)Geode.Properties.overworld(name).noise(0.9f))).rarity(2400))).altitude(-58, 30))).filling(IntBounds.between((Integer)6, (Integer)12), "air", "water -> water", "lava -> lava"))).layer(GeodeLayer.Type.INNER_WALL, IntBounds.between((Integer)1, (Integer)4), "amethyst_block, 12", "budding_amethyst, 1"))).layer(GeodeLayer.Type.MIDDLE_WALL, IntBounds.between((Integer)1, (Integer)3), "calcite"))).layer(GeodeLayer.Type.OUTER_WALL, IntBounds.between((Integer)1, (Integer)2), "smooth_basalt"))).crystals("budding_amethyst -> amethyst_cluster, 25", "budding_amethyst -> large_amethyst_bud, 45", "budding_amethyst -> medium_amethyst_bud, 65", "budding_amethyst -> small_amethyst_bud, 85"))).crack(Percentage.value((float)95.0f), IntBounds.between((Integer)8, (Integer)20), "air", "water -> water", "lava -> lava"))).indicators("minecraft:allium, 3", "minecraft:lily_of_the_valley, 6")));
    }
}

