/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adlods.geode;

import com.endertech.common.CommonMath;
import com.endertech.minecraft.forge.blocks.IWaterLoggable;
import com.endertech.minecraft.forge.math.Percentage;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.mods.adlods.geode.Geode;
import com.endertech.minecraft.mods.adlods.geode.GeodeLayer;
import com.endertech.minecraft.mods.adlods.ore.AbstractOrePlacements;
import com.endertech.minecraft.mods.adlods.ore.Miscellaneous;
import com.endertech.minecraft.mods.adlods.ore.WeightedOre;
import com.endertech.minecraft.mods.adlods.target.AbstractTargetOreChain;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.synth.NormalNoise;

public class GeodeOreChain
extends AbstractTargetOreChain<Geode> {
    protected final Geode.State geode;
    protected final Set<ChunkPos> entryPointChunks = new HashSet<ChunkPos>();
    protected final List<BlockPos> crystalGrounds = new ArrayList<BlockPos>();
    protected final boolean deferredPart;
    protected final NormalNoise normalNoise;

    protected GeodeOreChain(Geode.State geode, BlockPos startPos, int size, Miscellaneous miscellaneous, boolean testing, Random random) {
        super(geode.level(), (Geode)geode.target(), geode.originPos(), startPos, size, miscellaneous, testing, random);
        this.geode = geode;
        this.deferredPart = size < geode.size();
        this.normalNoise = NormalNoise.m_230504_((RandomSource)geode.level().m_213780_(), (int)-4, (double[])new double[]{1.0});
    }

    @Override
    protected boolean replaceWithOre(BlockPos pos) {
        AbstractOrePlacements placements = this.getPlacements(pos).orElse(null);
        if (placements != null) {
            boolean replaced = ((Geode)this.target).replaceWithOre((LevelAccessor)this.worldGenLevel, pos, placements, this.testing, this.random);
            if (replaced && placements == ((Geode)this.target).layers.get(GeodeLayer.Type.INNER_WALL).placements()) {
                this.crystalGrounds.add(pos);
            }
            return replaced;
        }
        return false;
    }

    protected Optional<AbstractOrePlacements> getPlacements(BlockPos pos) {
        if (this.geode.hasCrack() && this.withinRadius(this.geode.crackPos(), pos, this.geode.crackRadius())) {
            return Optional.of(((Geode)this.target).crack.placements());
        }
        int radius = this.geode.fillingRadius();
        if (this.withinRadius(this.originPos, pos, radius)) {
            return Optional.of(((Geode)this.target).filling.placements());
        }
        for (GeodeLayer.Type layer : GeodeLayer.Type.values()) {
            if (!this.withinRadius(this.originPos, pos, radius += this.geode.layerThickness(layer))) continue;
            return Optional.of(((Geode)this.target).layers.get(layer).placements());
        }
        return Optional.empty();
    }

    protected void placeCrystals() {
        Geode.Placements placements = ((Geode)this.target).crystals.placements();
        block0: for (BlockPos groundPos : this.crystalGrounds) {
            BlockState groundState = this.level.m_8055_(groundPos);
            Optional<WeightedOre> crystalOre = placements.pickOreFor(groundState, this.random);
            boolean crystalExists = crystalOre.map(WeightedOre::getWeight).map(Percentage::value).map(Percentage::takeChance).orElse(false);
            if (!crystalExists) continue;
            for (Direction direction : GameWorld.Directions.of().all().shuffle().toArray()) {
                BlockPos pos = groundPos.m_121945_(direction);
                if (!this.withinRadius(this.originPos, pos, this.geode.fillingRadius()) || !this.inFullWorld() && !this.inGenRegion(new ChunkPos(pos))) continue;
                BlockState crystal = crystalOre.get().getBlockState();
                if (crystal.m_61138_((Property)BlockStateProperties.f_61372_)) {
                    crystal = (BlockState)crystal.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)direction);
                }
                if (((Geode)this.target).placeAndUpdate(this.level, pos, crystal = IWaterLoggable.getStateForPlacementAt((LevelReader)this.level, (BlockPos)pos, (BlockState)crystal))) continue block0;
            }
        }
    }

    @Override
    protected boolean isOutsideBounds(BlockPos pos) {
        return !this.withinRadius(this.originPos, pos, this.geode.outerRadius()) || super.isOutsideBounds(pos);
    }

    protected boolean withinRadius(BlockPos centerPos, BlockPos pos, float radius) {
        float noiseMultiplier = (float)this.geode.fillingRadius() * ((Geode)this.target).noiseMultiplier;
        float noiseOffset = (float)this.normalNoise.m_75380_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()) * noiseMultiplier;
        float noisyRadius = radius + noiseOffset;
        float proportions = ((Geode)this.target).getMiscellaneous().proportions;
        float horizRadiusSqr = Mth.m_14207_((float)Geode.horizRadius(noisyRadius, proportions));
        float vertRadiusSqr = Mth.m_14207_((float)Geode.vertRadius(noisyRadius, proportions));
        if (CommonMath.isAlmostZero((double)horizRadiusSqr) || CommonMath.isAlmostZero((double)vertRadiusSqr)) {
            return false;
        }
        float distXSqr = Mth.m_144944_((int)(pos.m_123341_() - centerPos.m_123341_()));
        if (distXSqr > horizRadiusSqr) {
            return false;
        }
        float distYSqr = Mth.m_144944_((int)(pos.m_123342_() - centerPos.m_123342_()));
        if (distYSqr > vertRadiusSqr) {
            return false;
        }
        float distZSqr = Mth.m_144944_((int)(pos.m_123343_() - centerPos.m_123343_()));
        if (distZSqr > horizRadiusSqr) {
            return false;
        }
        return distXSqr / horizRadiusSqr + distYSqr / vertRadiusSqr + distZSqr / horizRadiusSqr <= 1.0f;
    }

    @Override
    protected boolean isValidPath(BlockPos pos) {
        if (this.deferredPart && !this.getStartPos().equals((Object)pos) && this.inOriginGenRegion(new ChunkPos(pos))) {
            return false;
        }
        return super.isValidPath(pos);
    }

    @Override
    protected boolean isValidBlock(BlockPos pos) {
        if (this.deferredPart && !this.getStartPos().equals((Object)pos) && this.inOriginGenRegion(new ChunkPos(pos))) {
            return false;
        }
        return super.isValidBlock(pos);
    }

    @Override
    protected boolean onValidFound(BlockPos pos) {
        ChunkPos chunk = new ChunkPos(pos);
        if (this.inFullWorld() || this.inGenRegion(chunk)) {
            if (this.replaceWithOre(pos)) {
                ++this.count;
            }
        } else if (this.inDeferredRegion(chunk)) {
            ++this.deferred;
            this.getEntryPoint(pos).ifPresent(entryPoint -> {
                if (this.entryPointChunks.add(new ChunkPos(entryPoint))) {
                    this.saveDeferredEntryPoint((BlockPos)entryPoint);
                }
            });
        }
        return true;
    }

    @Override
    public void build() {
        this.crystalGrounds.clear();
        super.build();
        this.placeCrystals();
    }
}

