/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adlods.ore;

import com.endertech.common.CommonCollect;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.blocks.BlockStatesSet;
import com.endertech.minecraft.forge.blocks.ForgeBlock;
import com.endertech.minecraft.forge.configs.IHaveConfig;
import com.endertech.minecraft.forge.configs.Parsers;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.data.Names;
import com.endertech.minecraft.forge.units.RelatedUnit;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.forge.world.BiomeId;
import com.endertech.minecraft.forge.world.Biomes;
import com.endertech.minecraft.forge.world.DimensionId;
import com.endertech.minecraft.forge.world.Dimensions;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.mods.adlods.AdLods;
import com.endertech.minecraft.mods.adlods.ore.AbstractOrePlacements;
import com.endertech.minecraft.mods.adlods.ore.Miscellaneous;
import com.endertech.minecraft.mods.adlods.ore.WeightedOre;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.AmethystBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class AbstractOre
implements IHaveConfig {
    protected final UnitConfig config;
    protected final CommonCollect.BlackWhiteList<BiomeId> biomes;
    protected final CommonCollect.BlackWhiteList<DimensionId> dimensions;
    protected final IntBounds altitude;
    protected final BlockStatesSet replaceableBlocks;
    protected final Miscellaneous miscellaneous;

    public AbstractOre(UnitConfig config, Properties<?> props) {
        String category = this.getClassCategory();
        this.config = config;
        this.dimensions = Dimensions.from((UnitConfig)config, (String)category, (String)"List of dimensions which this ore can be generated in.", (String[])new String[0], (String[])props.allowedDimensions);
        this.biomes = Biomes.from((UnitConfig)config, (String)category, (String)"List of biomes which this ore can be generated in.");
        this.altitude = UnitConfig.getIntBounds((UnitConfig)config, (String)category, (String)"Altitude", (IntBounds)props.altitude, (IntBounds)IntBounds.INTEGER, (String)"Altitude which this ore can be generated at.");
        this.replaceableBlocks = BlockStatesSet.parseFrom((String[])UnitConfig.getStrArray((UnitConfig)config, (String)category, (String)"replaceableBlocks", (String[])props.replaceableBlocks, (String)"List of blocks that can be replaced with this ore."));
        this.miscellaneous = Miscellaneous.of(config, category, props.miscellaneous);
    }

    protected abstract int generate(WorldGenLevel var1, BlockPos var2, int var3, boolean var4, Random var5);

    public abstract int test(WorldGenLevel var1, BlockPos var2, int var3, Random var4);

    public abstract boolean isValid();

    public static boolean inAdjacentChunk(BlockPos pos, ChunkPos center, boolean includeCorners) {
        ChunkPos check = new ChunkPos(pos);
        int dX = Math.abs(center.f_45578_ - check.f_45578_);
        int dZ = Math.abs(center.f_45579_ - check.f_45579_);
        return includeCorners ? dX <= 1 && dZ <= 1 : dX == 0 && dZ <= 1 || dZ == 0 && dX <= 1;
    }

    public static CommonCollect.WeightedList<WeightedOre> parseOresFrom(String[] array, Function<UnitId, Optional<BlockState>> mapper) {
        CommonCollect.WeightedList ores = new CommonCollect.WeightedList();
        Parsers.UnitId_OptInteger parser = new Parsers.UnitId_OptInteger(IntBounds.INTEGER_POSITIVE, ",");
        for (String str : array) {
            if ((str = str.trim()).isEmpty()) continue;
            try {
                UnitId id = parser.getId((CharSequence)str);
                int weight = parser.getInteger((CharSequence)str).orElse(1);
                mapper.apply(id).ifPresent(state -> ores.add((CommonCollect.IWeighted)new WeightedOre((BlockState)state, weight)));
            }
            catch (Exception e) {
                parser.logError((AbstractForgeMod)AdLods.getInstance(), "ore", (CharSequence)str, e);
            }
        }
        return ores;
    }

    public static boolean withinGenRegion(ChunkPos chunk, ChunkPos start) {
        return AbstractOre.withinRadius(chunk, start, 1);
    }

    public static boolean withinRadius(ChunkPos chunk, ChunkPos center, int radius) {
        int dX = Math.abs(center.f_45578_ - chunk.f_45578_);
        int dZ = Math.abs(center.f_45579_ - chunk.f_45579_);
        return dX <= radius && dZ <= radius;
    }

    public UnitConfig getConfig() {
        return this.config;
    }

    public IntBounds getAltitude() {
        return this.altitude;
    }

    public Miscellaneous getMiscellaneous() {
        return this.miscellaneous;
    }

    public abstract AbstractOrePlacements getPlacements();

    public boolean inAllowedDimenstion(ServerLevelAccessor level) {
        return this.dimensions.isEmpty() || this.dimensions.isAllowed((Object)DimensionId.from((Level)level.m_6018_()));
    }

    public boolean inAllowedBiome(LevelAccessor level, BlockPos pos) {
        return this.biomes.isEmpty() || this.biomes.isAllowed((Object)BiomeId.from((LevelAccessor)level, (BlockPos)pos));
    }

    protected boolean isAllowedOre(BlockState state) {
        String name = ForgeBlock.getRegistryName((Block)state.m_60734_()).m_135815_();
        if (name.contains("nether")) {
            return this.dimensions.isAllowed((Object)Dimensions.THE_NETHER.dimensionId);
        }
        if (name.startsWith("end_")) {
            return this.dimensions.isAllowed((Object)Dimensions.THE_END.dimensionId);
        }
        return true;
    }

    protected Optional<BlockState> pickState(UnitId oreId) {
        Predicate<BlockState> filter = this::isAllowedOre;
        return Optional.ofNullable(oreId.getFirstMatchedState()).filter(filter).or(() -> Optional.ofNullable(oreId.getAllMatchedBlockStates()).flatMap(set -> set.getBlocksWithAllStates().stream().map(Block::m_49966_).filter(filter).findFirst().or(() -> set.stream().filter(filter).findFirst())));
    }

    public boolean replaceWithOre(LevelAccessor level, BlockPos pos, boolean testing, Random random) {
        return this.replaceWithOre(level, pos, this.getPlacements(), testing, random);
    }

    public boolean replaceWithOre(LevelAccessor level, BlockPos pos, AbstractOrePlacements placements, boolean testing, Random random) {
        BlockState replaceableBlock = level.m_8055_(pos);
        Optional<WeightedOre> pickedOre = testing && replaceableBlock.m_60795_() && !placements.isReplaceable(replaceableBlock) ? placements.pickOre(random) : placements.pickOreFor(replaceableBlock, random);
        return pickedOre.filter(ore -> this.placeAndUpdate(level, pos, ore.getBlockState())).isPresent();
    }

    public boolean placeAndUpdate(LevelAccessor level, BlockPos pos, BlockState state) {
        if (this.canBePlaced(state, level, pos) && level.m_7731_(pos, state, 18)) {
            this.updateFluidState(level, pos, state);
            return true;
        }
        return false;
    }

    protected void updateFluidState(LevelAccessor level, BlockPos pos, BlockState state) {
        if (!state.m_60819_().m_76178_()) {
            level.m_186469_(pos, state.m_60819_().m_76152_(), level.m_213780_().m_216332_(0, 60));
        }
    }

    protected Optional<Direction> getClusterFacing(BlockState state) {
        if (state.m_60734_() instanceof AmethystBlock && state.m_61138_((Property)BlockStateProperties.f_61372_)) {
            return Optional.of((Direction)state.m_61143_((Property)BlockStateProperties.f_61372_));
        }
        return Optional.empty();
    }

    protected boolean canBePlaced(BlockState state, LevelAccessor level, BlockPos pos) {
        if (!state.m_60710_((LevelReader)level, pos)) {
            return false;
        }
        return this.getClusterFacing(state).flatMap(facing -> {
            BlockState blockOnTop = level.m_8055_(pos.m_121945_(facing));
            return this.getClusterFacing(blockOnTop).map(arg_0 -> facing.equals(arg_0));
        }).orElse(false) == false;
    }

    public boolean canBeReplaced(LevelAccessor level, BlockPos pos, BlockPos start, BlockPos origin, boolean testing) {
        BlockState state = level.m_8055_(pos);
        if (testing && state.m_60795_()) {
            return true;
        }
        if (this.miscellaneous.strictStart && !testing && pos.equals((Object)origin)) {
            return this.replaceableBlocks.contains((Object)state);
        }
        return this.getPlacements().isReplaceable(state);
    }

    public boolean isValidPosition(WorldGenLevel level, BlockPos pos, BlockPos start, BlockPos origin, boolean testing) {
        if (level instanceof WorldGenRegion && !AbstractOre.withinGenRegion(new ChunkPos(pos), new ChunkPos(start))) {
            return false;
        }
        if (!this.withinHeightBounds(level, pos, start, origin, testing)) {
            return false;
        }
        if ((this.miscellaneous.strictBounds || pos.equals((Object)origin)) && !testing && !this.inAllowedBiome((LevelAccessor)level, pos)) {
            return false;
        }
        return testing || this.miscellaneous.exposed || !this.exposedToAir((LevelAccessor)level, pos);
    }

    public boolean withinHeightBounds(WorldGenLevel level, BlockPos pos, BlockPos start, BlockPos origin, boolean testing) {
        if (level.m_151570_(pos)) {
            return false;
        }
        if (this.miscellaneous.strictBounds || pos.equals((Object)origin)) {
            return testing ? Math.abs(pos.m_123342_() - start.m_123342_()) <= this.altitude.length() / 2 : this.altitude.encloses(Integer.valueOf(pos.m_123342_()));
        }
        return true;
    }

    protected boolean exposedToAir(LevelAccessor world, BlockPos posIn) {
        for (BlockPos pos : GameWorld.Positions.getAroundCube((BlockPos)posIn)) {
            if (!GameWorld.isBlockLoaded((LevelReader)world, (BlockPos)pos)) {
                return true;
            }
            if (!GameWorld.isAirBlock((LevelReader)world, (BlockPos)pos)) continue;
            return true;
        }
        return false;
    }

    public static class Properties<T extends Properties<T>>
    extends RelatedUnit.Properties<T> {
        public IntBounds altitude = IntBounds.ZERO;
        public String[] replaceableBlocks = new String[0];
        public String[] allowedDimensions = new String[0];
        public String[] customReplacements = new String[0];
        public Miscellaneous.Properties<?> miscellaneous = Miscellaneous.Properties.of();

        protected Properties(Class<T> selfClass) {
            super(selfClass);
        }

        public T dimension(Dimensions dimension) {
            return ((Properties)((Object)this.allowedDimensions(dimension.dimensionId.toResourceLocation().toString()))).replaceableBlocks(dimension.replaceableBlockId.toString());
        }

        public T altitude(int min, int max) {
            this.altitude = IntBounds.between((Integer)min, (Integer)max);
            return (T)((Object)((Properties)this.self));
        }

        public T allowedDimensions(String ... dimensions) {
            this.allowedDimensions = dimensions;
            return (T)((Object)((Properties)this.self));
        }

        public T deepslate(String ore) {
            String deepslate = "deepslate";
            String target = "#minecraft:deepslate_ore_replaceables";
            String replacement = ore.contains("deepslate") ? ore : Names.registry().join(new String[]{"deepslate", ore});
            return this.customReplacements("#minecraft:deepslate_ore_replaceables -> " + replacement);
        }

        public T replaceableBlocks(String ... blocks) {
            this.replaceableBlocks = blocks;
            return (T)((Object)((Properties)this.self));
        }

        public T customReplacements(String ... replacements) {
            this.customReplacements = replacements;
            return (T)((Object)((Properties)this.self));
        }

        public T exposed(boolean value) {
            this.miscellaneous.exposed(value);
            return (T)((Object)((Properties)this.self));
        }
    }
}

