/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adlods.target;

import com.endertech.minecraft.forge.math.Percentage;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.mods.adlods.target.AbstractTarget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.Structure;

public class Anchors<T extends AbstractTarget> {
    @Nullable
    protected Map<ConfiguredFeature<?, ?>, List<T>> features = null;
    @Nullable
    protected Map<Structure, List<T>> structures = null;

    protected <N> Map<N, List<T>> map(ResourceKey<Registry<N>> registryKey, WorldGenLevel level, List<T> targets) {
        ConcurrentHashMap anchorMap = new ConcurrentHashMap();
        for (AbstractTarget target : targets) {
            UnitId id = target.indicator.getCenterId();
            Percentage threshold = target.indicator.threshold;
            if (id.isEmpty() || id.hasMetaData() || !threshold.isGreaterThan((Object)Percentage.ZERO)) continue;
            Optional registry = level.m_9598_().m_6632_(registryKey);
            List<Object> anchors = Collections.emptyList();
            ResourceLocation name = id.toResLoc();
            if (id.isTag()) {
                TagKey tagKey = TagKey.m_203882_(registryKey, (ResourceLocation)name);
                anchors = registry.stream().map(reg -> reg.m_203431_(tagKey)).flatMap(Optional::stream).flatMap(HolderSet.ListBacked::m_203614_).filter(Holder::m_203633_).map(Holder::m_203334_).toList();
            } else {
                anchors = registry.map(reg -> reg.m_7745_(name)).stream().toList();
            }
            anchors.forEach(anchor -> anchorMap.computeIfAbsent(anchor, k -> new ArrayList()).add(target));
        }
        return anchorMap;
    }

    public boolean contain(PlacedFeature feature) {
        return this.features != null && this.features.containsKey(feature);
    }

    public boolean contain(Structure structure) {
        return this.structures != null && this.structures.containsKey(structure);
    }

    public Optional<List<T>> targets(ConfiguredFeature<?, ?> feature) {
        return this.features != null ? Optional.ofNullable(this.features.get(feature)) : Optional.empty();
    }

    public Optional<List<T>> targets(Structure structure) {
        return this.structures != null ? Optional.ofNullable(this.structures.get(structure)) : Optional.empty();
    }

    public boolean hasFeatures() {
        return this.features != null && !this.features.isEmpty();
    }

    public boolean hasStructures() {
        return this.structures != null && !this.structures.isEmpty();
    }

    public boolean initialized() {
        return this.features != null && this.structures != null;
    }

    public void initialize(WorldGenLevel level, List<T> targets) {
        this.features = this.map(Registries.f_256911_, level, targets);
        this.structures = this.map(Registries.f_256944_, level, targets);
    }

    public void clear() {
        this.features = null;
        this.structures = null;
    }
}

