/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adlods.target;

import com.endertech.minecraft.forge.configs.AbstractParsableList;
import com.endertech.minecraft.forge.configs.IHaveConfig;
import com.endertech.minecraft.forge.configs.Parsers;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.math.Percentage;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.mods.adlods.AdLods;
import com.endertech.minecraft.mods.adlods.deposit.DepositGenerator;
import com.endertech.minecraft.mods.adlods.geode.GeodeGenerator;
import com.endertech.minecraft.mods.adlods.init.Features;
import com.endertech.minecraft.mods.adlods.target.AbstractTarget;
import com.endertech.minecraft.mods.adlods.target.AbstractTargetGenerator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;

public class Descendants
extends AbstractParsableList
implements IHaveConfig {
    protected final List<Descendant> descendants = new ArrayList<Descendant>();

    public static Descendants createAndLoad(UnitConfig config, String category, String[] defaultValues) {
        Descendants descendants = new Descendants(config, category, "descendants", defaultValues);
        descendants.loadData();
        return descendants;
    }

    protected Descendants(UnitConfig config, String category, String key, String[] defaultValues) {
        super(config, category, key, defaultValues);
    }

    public List<Descendant> list() {
        return Collections.unmodifiableList(this.descendants);
    }

    public List<Descendant> shuffledList(Random random) {
        ArrayList<Descendant> list = new ArrayList<Descendant>(this.descendants);
        Collections.shuffle(list);
        return list;
    }

    protected String getComment() {
        return "List of descendants (deposits/geodes) that will attempt to be generated after this (parent) one.\nFormat: threshold% -> descendant, chance% [:group]\n  <threshold> - minimum percentage of the parent's size that must be reached to begin generating this descendant\n  <descendant> - ID of the descendant in the following format: deposit:name or geode:name\n  <chance> - chance of generating the descendant (from 0 to 100%)\n  <group> - group name (optional parameter). Can contain only letters, digits or underscores [a-zA-Z0-9_].\nAll listed descendants will attempt to be generated in random order.\nGroup descendants to achieve logical \"or\" behaviour (only one descendant from each group will be generated).\nStarting position will be chosen within the chunk where the parent's size has reached the threshold value.\nExamples:\n   90% -> deposit:diamond, 10%\n   80% -> deposit:iron, 40% :metals\n   70% -> geode:amethyst, 20%";
    }

    protected void parseConfigValues() {
        this.descendants.clear();
        Parser parser = new Parser();
        for (String string : this.configValues) {
            try {
                parser.parse(string).ifPresent(this.descendants::add);
            }
            catch (Exception e) {
                parser.logError(AdLods.getInstance(), this.getConfig(), "Descendant", string, e);
            }
        }
    }

    public UnitConfig getConfig() {
        return this.config;
    }

    public static class Parser
    extends Parsers.AbstractParser {
        public Optional<Descendant> parse(CharSequence input) throws Exception {
            Percentage threshold = this.getGroup("threshold", input).map(Percentage::parse).orElseThrow(() -> new Exception("Invalid threshold"));
            UnitId id = this.getGroup("id", input).map(UnitId::from).filter(UnitId::notEmpty).orElseThrow(() -> new Exception("Invalid id"));
            Percentage chance = this.getGroup("chance", input).map(Percentage::parse).orElseThrow(() -> new Exception("Invalid chance"));
            String group = this.getGroup("group", input).orElse("");
            Features features = AdLods.getInstance().features;
            AbstractTargetGenerator generator = switch (id.getModId()) {
                case "deposit" -> (DepositGenerator)((Object)features.depositGenerator.get());
                case "geode" -> (GeodeGenerator)((Object)features.geodeGenerator.get());
                default -> throw new Exception("Invalid target ID: " + id);
            };
            return generator.findByName(id.getRegName()).map(target -> new Descendant(threshold, (AbstractTarget)target, chance, group));
        }

        protected String percentage() {
            return "\\b(0|[1-9][0-9]?|100)(\\.\\d+)?%";
        }

        protected String regex() {
            return "^" + this.grp("threshold", this.percentage()) + this.delim("->") + this.grp("id", this.unit_id()) + this.delim(",") + this.grp("chance", this.percentage()) + this.grp_non(this.delim(":") + this.grp("group", "\\w+"), true) + "$";
        }
    }

    public record Descendant(Percentage threshold, AbstractTarget target, Percentage chance, String group) {
    }
}

