/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adlods.vanilla;

import com.endertech.minecraft.forge.units.UnitId;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.Tags;

public class OreConfigurationProvider {
    @Nullable
    private OreConfiguration oreConfiguration;
    @Nullable
    private BlockState firstTargetBlockState;
    private boolean isOreBlock;

    public static OreConfigurationProvider of(Holder<PlacedFeature> featureHolder) {
        return new OreConfigurationProvider(featureHolder);
    }

    protected OreConfigurationProvider(Holder<PlacedFeature> featureHolder) {
        FeatureConfiguration featureConfiguration;
        ConfiguredFeature configuredFeature;
        Feature feature;
        List featureList;
        if (featureHolder.m_203633_() && !(featureList = ((PlacedFeature)featureHolder.m_203334_()).m_191781_().toList()).isEmpty() && ((feature = (configuredFeature = (ConfiguredFeature)featureList.get(0)).f_65377_()) == Feature.f_65731_ || feature == Feature.f_159727_) && (featureConfiguration = configuredFeature.f_65378_()) instanceof OreConfiguration) {
            OreConfiguration configuration = (OreConfiguration)featureConfiguration;
            if (!configuration.f_161005_.isEmpty()) {
                this.oreConfiguration = configuration;
                this.firstTargetBlockState = ((OreConfiguration.TargetBlockState)configuration.f_161005_.get((int)0)).f_161033_;
                this.isOreBlock = this.firstTargetBlockState.m_204336_(Tags.Blocks.ORES);
            }
        }
    }

    public Optional<OreConfiguration> getOreConfiguration() {
        return Optional.ofNullable(this.oreConfiguration);
    }

    public Optional<BlockState> getFirstTargetBlockState() {
        return Optional.ofNullable(this.firstTargetBlockState);
    }

    public boolean isOreBlock() {
        return this.isOreBlock;
    }

    public boolean matches(UnitId id) {
        return this.getFirstTargetBlockState().filter(arg_0 -> ((UnitId)id).matches(arg_0)).isPresent();
    }
}

