/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adlods.vanilla;

import com.endertech.common.CommonPath;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.units.IRelatedUnit;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.forge.world.Dimensions;
import com.endertech.minecraft.mods.adlods.AdLods;
import com.endertech.minecraft.mods.adlods.ore.AbstractOre;
import com.endertech.minecraft.mods.adlods.ore.CustomReplacements;
import com.endertech.minecraft.mods.adlods.ore.OreChain;
import com.endertech.minecraft.mods.adlods.ore.WeightedOre;
import com.endertech.minecraft.mods.adlods.vanilla.OreConfigurationProvider;
import java.nio.file.Path;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public class VanillaOre
extends AbstractOre
implements IRelatedUnit {
    public static final IntBounds VEIN_SIZE_BOUNDS = IntBounds.between((Integer)1, (Integer)1024);
    public static final IntBounds VEINS_IN_CHUNK_BOUNDS = IntBounds.between((Integer)1, (Integer)1024);
    protected final UnitId oreId;
    protected final Generation generation;
    protected final IntBounds veinsInChunk;
    protected final IntBounds blocksInVein;
    protected final CustomReplacements placements;

    public VanillaOre(UnitConfig config, Properties<?> props) {
        super(config, props);
        String category = this.getClassCategory();
        this.oreId = UnitConfig.getUnitId((UnitConfig)config, (String)category, (String)"oreId", (UnitId)props.id, (String)"Id is a basic unit (block or item) identifier in <modId:unitName:meta> format.\nModId can be omitted for vanilla items. Meta can be omitted too if it equals 0.\nUnitName must be lowercase, words separated by '_', words order - from private to common (example: black_iron_ore).\nUse '*' char or '[]' as meta value to specify all possible values (all block states).\nTo define multiple block states, you can use block properties. The format is <modId:blockName:[prop1=value1, prop2=value2]>\nAlso you may use tags. The format is <#modId:tagPath> (example: #forge:ores/copper).\n");
        this.generation = Generation.from(config, category, "Generation type used for this ore. Possible values:\n    VANILLA - vanilla generation without any changes,\n    CUSTOM - generation according to this config,\n    NONE - no generation at all.\nNote that changing this setting requires a WORLD RESTART in order to update every biome's features.");
        this.veinsInChunk = UnitConfig.getIntBounds((UnitConfig)config, (String)category, (String)"VeinsInChunk", (IntBounds)props.veins, (IntBounds)VEINS_IN_CHUNK_BOUNDS, (String)"Number of ore veins to generate in each chunk.");
        this.blocksInVein = UnitConfig.getIntBounds((UnitConfig)config, (String)category, (String)"BlocksInVein", (IntBounds)props.size, (IntBounds)VEIN_SIZE_BOUNDS, (String)"Number of ore blocks in each vein.");
        this.placements = CustomReplacements.createAndLoad(config, category, props.customReplacements, this.replaceableBlocks, x$0 -> this.pickState((UnitId)x$0));
        this.pickState(this.oreId).ifPresent(ore -> this.placements.addOre(new WeightedOre((BlockState)ore, 1)));
        this.saveConfig();
    }

    @Override
    public CustomReplacements getPlacements() {
        return this.placements;
    }

    public UnitId getRelatedId() {
        return this.oreId;
    }

    public Generation getGeneration() {
        return this.generation;
    }

    public String getName() {
        return CommonPath.getFileNameOnly((Path)this.config.getConfigFile().toPath());
    }

    public IntBounds getVeinsInChunk() {
        return this.veinsInChunk;
    }

    public IntBounds getBlocksInVein() {
        return this.blocksInVein;
    }

    @Override
    protected int generate(final WorldGenLevel world, final BlockPos start, int amount, final boolean testing, Random random) {
        return new OreChain((LevelAccessor)world, start, amount, this.miscellaneous, random){

            @Override
            public boolean replaceWithOre(BlockPos pos) {
                return VanillaOre.this.replaceWithOre((LevelAccessor)world, pos, testing, this.random);
            }

            protected boolean isValidBlock(BlockPos pos) {
                return VanillaOre.this.isValidPosition(world, pos, start, start, testing) && VanillaOre.this.canBeReplaced((LevelAccessor)world, pos, start, start, testing);
            }
        }.generate().getCount();
    }

    @Override
    public int test(WorldGenLevel level, BlockPos startPos, int amount, Random random) {
        return this.generate(level, startPos, amount, true, random);
    }

    public boolean matches(Holder<PlacedFeature> featureHolder) {
        return OreConfigurationProvider.of(featureHolder).matches(this.getRelatedId());
    }

    public boolean matches(BlockState state) {
        return this.getRelatedId().matches(state);
    }

    public boolean is(TagKey<Block> tag) {
        return Optional.ofNullable(this.getRelatedId().getFirstMatchedState()).filter(state -> state.m_204336_(tag)).isPresent();
    }

    @Override
    public boolean isValid() {
        return !this.placements.isEmpty();
    }

    public static class Properties<T extends Properties<T>>
    extends AbstractOre.Properties<T> {
        public IntBounds size = IntBounds.ZERO;
        public IntBounds veins = IntBounds.ZERO;

        protected Properties(Class<T> selfClass) {
            super(selfClass);
            this.miscellaneous.maxAttempts(1);
        }

        public static Properties<?> overworld() {
            Properties<Properties> props = new Properties<Properties>(Properties.class);
            return (Properties)((Object)props.dimension(Dimensions.OVERWORLD));
        }

        public static Properties<?> nether() {
            Properties<Properties> props = new Properties<Properties>(Properties.class);
            return (Properties)((Object)props.dimension(Dimensions.THE_NETHER));
        }

        public T veins(int max) {
            this.veins = IntBounds.between((Integer)max, (Integer)max);
            return (T)((Object)((Properties)this.self));
        }

        public T size(int max) {
            this.size = IntBounds.between((Integer)1, (Integer)max);
            return (T)((Object)((Properties)this.self));
        }
    }

    public static enum Generation {
        VANILLA,
        CUSTOM,
        NONE;


        public static Generation from(UnitConfig config, String category, String comment) {
            String name = UnitConfig.getStr((UnitConfig)config, (String)category, (String)"generation", (String)"vanilla", (String)comment);
            for (Generation type : Generation.values()) {
                if (!type.name().equalsIgnoreCase(name)) continue;
                return type;
            }
            AdLods.getInstance().getLogger().error("Invalid generation type: " + name);
            return VANILLA;
        }
    }
}

