/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adlods.world;

import com.endertech.minecraft.forge.world.ChunkBounds;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.mods.adlods.ore.AbstractOre;
import com.endertech.minecraft.mods.adlods.ore.AbstractOrePlacements;
import com.endertech.minecraft.mods.adlods.target.AbstractTarget;
import com.endertech.minecraft.mods.adlods.target.AbstractTargetGenerator;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraftforge.common.ForgeConfigSpec;

public class ChunkStripper {
    protected static final Map<Level, ChunkStripper> STRIPPERS = new ConcurrentHashMap<Level, ChunkStripper>();
    protected static final Set<Block> ORE_BLOCKS = ConcurrentHashMap.newKeySet();
    public static ForgeConfigSpec.ConfigValue<Boolean> dressUnloadedChunks;
    protected final Map<ChunkPos, BlockState[][][]> strippedChunks = new ConcurrentHashMap<ChunkPos, BlockState[][][]>();

    public static ChunkStripper getFor(Level level) {
        ChunkStripper stripper = STRIPPERS.get(level);
        if (stripper == null) {
            stripper = new ChunkStripper();
            STRIPPERS.put(level, stripper);
        }
        return stripper;
    }

    public static void removeFor(Level level) {
        STRIPPERS.remove(level);
    }

    public static void enumerateOres(AbstractTargetGenerator<? extends AbstractTarget> ... generators) {
        ORE_BLOCKS.clear();
        List<AbstractOrePlacements> orePlacements = Arrays.stream(generators).map(AbstractTargetGenerator::getTargets).flatMap(Collection::stream).map(AbstractOre::getPlacements).toList();
        orePlacements.stream().map(AbstractOrePlacements::getOreBlocks).forEach(ORE_BLOCKS::addAll);
        orePlacements.forEach(placements -> ORE_BLOCKS.removeIf(placements::isReplaceableBlock));
    }

    public boolean isOreBlock(Level level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        if (state.m_60795_()) {
            return false;
        }
        return ORE_BLOCKS.contains(state.m_60734_()) || GameWorld.isOreBlock((LevelReader)level, (BlockPos)pos, (BlockState)state);
    }

    public void stripChunk(Level level, ChunkPos chunkPos) {
        if (this.strippedChunks.containsKey(chunkPos)) {
            return;
        }
        ChunkBounds bounds = ChunkBounds.from((LevelHeightAccessor)level, (ChunkPos)chunkPos);
        BlockState[][][] data = new BlockState[16][bounds.getHeight()][16];
        int bottomLayer = bounds.getY().getMin();
        bounds.forEach(pos -> {
            BlockState state;
            BlockPos rel = bounds.relative((BlockPos)pos);
            if (level.m_46859_((BlockPos)pos) || this.isOreBlock(level, (BlockPos)pos) || level.m_7702_((BlockPos)pos) != null) {
                return;
            }
            data[rel.m_123341_()][rel.m_123342_()][rel.m_123343_()] = state = level.m_8055_((BlockPos)pos);
            if (pos.m_123342_() != bottomLayer) {
                level.m_7731_((BlockPos)pos, Blocks.f_50016_.m_49966_(), 50);
            }
        });
        this.strippedChunks.put(chunkPos, data);
    }

    public void stripChunksAround(Level level, ChunkPos centerPos) {
        for (ChunkPos chunkPos : GameWorld.Positions.getAroundHoriz((ChunkPos)centerPos, (boolean)true, (ChunkPos[])new ChunkPos[]{centerPos})) {
            this.stripChunk(level, chunkPos);
        }
    }

    public void dressChunksAround(Level level, ChunkPos centerPos) {
        for (ChunkPos chunkPos : GameWorld.Positions.getAroundHoriz((ChunkPos)centerPos, (boolean)true, (ChunkPos[])new ChunkPos[]{centerPos})) {
            this.dressChunk(level, chunkPos);
        }
    }

    public void dressAllChunks(Level level) {
        for (ChunkPos chunkPos : new HashSet<ChunkPos>(this.strippedChunks.keySet())) {
            this.dressChunk(level, chunkPos);
        }
    }

    public void dressChunk(Level level, ChunkPos chunkPos) {
        this.dressChunk((ChunkAccess)level.m_6325_(chunkPos.f_45578_, chunkPos.f_45579_));
    }

    public void dressChunk(ChunkAccess chunk) {
        LevelAccessor level = chunk.getWorldForge();
        ChunkPos chunkPos = chunk.m_7697_();
        BlockState[][][] data = this.strippedChunks.get(chunkPos);
        if (level == null || data == null) {
            return;
        }
        ChunkBounds chunkBounds = ChunkBounds.from((LevelHeightAccessor)level, (ChunkPos)chunkPos);
        ChunkSource chunkSource = level.m_7726_();
        boolean chunkLoaded = chunkSource.m_5563_(chunkPos.f_45578_, chunkPos.f_45579_);
        chunk.m_8092_(true);
        chunkBounds.forEach(pos -> {
            BlockPos rel = chunkBounds.relative((BlockPos)pos);
            BlockState state = data[rel.m_123341_()][rel.m_123342_()][rel.m_123343_()];
            if (state != null) {
                if (chunkLoaded) {
                    level.m_7731_((BlockPos)pos, state, 2);
                } else {
                    int x = pos.m_123341_() & 0xF;
                    int y = pos.m_123342_() & 0xF;
                    int z = pos.m_123343_() & 0xF;
                    LevelChunkSection section = chunk.m_183278_(chunk.m_151564_(pos.m_123342_()));
                    section.m_62986_(x, y, z, state);
                    chunkSource.m_7827_().m_75834_((BlockPos)pos, section.m_188008_());
                }
            }
        });
        this.strippedChunks.remove(chunkPos);
    }
}

