/*
 * Decompiled with CFR 0.152.
 */
package com.smashingmods.alchemistry.client.jei;

import com.smashingmods.alchemistry.client.jei.RecipeTypes;
import com.smashingmods.alchemistry.client.jei.category.AtomizerRecipeCategory;
import com.smashingmods.alchemistry.client.jei.category.CombinerRecipeCategory;
import com.smashingmods.alchemistry.client.jei.category.CompactorRecipeCategory;
import com.smashingmods.alchemistry.client.jei.category.DissolverRecipeCategory;
import com.smashingmods.alchemistry.client.jei.category.FissionRecipeCategory;
import com.smashingmods.alchemistry.client.jei.category.FusionRecipeCategory;
import com.smashingmods.alchemistry.client.jei.category.LiquifierRecipeCategory;
import com.smashingmods.alchemistry.common.block.atomizer.AtomizerScreen;
import com.smashingmods.alchemistry.common.block.combiner.CombinerScreen;
import com.smashingmods.alchemistry.common.block.compactor.CompactorScreen;
import com.smashingmods.alchemistry.common.block.dissolver.DissolverScreen;
import com.smashingmods.alchemistry.common.block.fission.FissionControllerScreen;
import com.smashingmods.alchemistry.common.block.fusion.FusionControllerScreen;
import com.smashingmods.alchemistry.common.block.liquifier.LiquifierScreen;
import com.smashingmods.alchemistry.common.network.jei.CombinerTransferPacket;
import com.smashingmods.alchemistry.common.network.jei.CompactorTransferPacket;
import com.smashingmods.alchemistry.common.network.jei.DissolverTransferPacket;
import com.smashingmods.alchemistry.common.network.jei.FissionTransferPacket;
import com.smashingmods.alchemistry.common.network.jei.FusionTransferPacket;
import com.smashingmods.alchemistry.common.network.jei.LiquifierTransferPacket;
import com.smashingmods.alchemistry.registry.BlockRegistry;
import com.smashingmods.alchemistry.registry.RecipeRegistry;
import java.util.Objects;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("alchemistry", "jei_plugin");
    }

    public void registerCategories(IRecipeCategoryRegistration pRegistration) {
        IGuiHelper guiHelper = pRegistration.getJeiHelpers().getGuiHelper();
        pRegistration.addRecipeCategories(new IRecipeCategory[]{new AtomizerRecipeCategory(guiHelper), new CombinerRecipeCategory(guiHelper), new CompactorRecipeCategory(guiHelper), new DissolverRecipeCategory(guiHelper), new FissionRecipeCategory(guiHelper), new FusionRecipeCategory(guiHelper), new LiquifierRecipeCategory(guiHelper)});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration pRegistration) {
        pRegistration.addRecipeClickArea(AtomizerScreen.class, 78, 35, 30, 9, new RecipeType[]{RecipeTypes.ATOMIZER});
        pRegistration.addRecipeClickArea(CombinerScreen.class, 87, 35, 30, 9, new RecipeType[]{RecipeTypes.COMBINER});
        pRegistration.addRecipeClickArea(CompactorScreen.class, 78, 54, 30, 9, new RecipeType[]{RecipeTypes.COMPACTOR});
        pRegistration.addRecipeClickArea(DissolverScreen.class, 69, 35, 30, 9, new RecipeType[]{RecipeTypes.DISSOLVER});
        pRegistration.addRecipeClickArea(FissionControllerScreen.class, 74, 35, 30, 9, new RecipeType[]{RecipeTypes.FISSION});
        pRegistration.addRecipeClickArea(FusionControllerScreen.class, 78, 35, 30, 9, new RecipeType[]{RecipeTypes.FUSION});
        pRegistration.addRecipeClickArea(LiquifierScreen.class, 79, 35, 30, 9, new RecipeType[]{RecipeTypes.LIQUIFIER});
    }

    public void registerRecipes(IRecipeRegistration pRegistration) {
        RecipeManager recipeManager = Objects.requireNonNull(Minecraft.m_91087_().f_91073_).m_7465_();
        pRegistration.addRecipes(RecipeTypes.ATOMIZER, recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)RecipeRegistry.ATOMIZER_TYPE.get()));
        pRegistration.addRecipes(RecipeTypes.COMBINER, recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)RecipeRegistry.COMBINER_TYPE.get()));
        pRegistration.addRecipes(RecipeTypes.COMPACTOR, recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)RecipeRegistry.COMPACTOR_TYPE.get()));
        pRegistration.addRecipes(RecipeTypes.DISSOLVER, recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)RecipeRegistry.DISSOLVER_TYPE.get()));
        pRegistration.addRecipes(RecipeTypes.FISSION, recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)RecipeRegistry.FISSION_TYPE.get()));
        pRegistration.addRecipes(RecipeTypes.FUSION, recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)RecipeRegistry.FUSION_TYPE.get()));
        pRegistration.addRecipes(RecipeTypes.LIQUIFIER, recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)RecipeRegistry.LIQUIFIER_TYPE.get()));
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration pRegistration) {
        pRegistration.addRecipeTransferHandler((IRecipeTransferHandler)new CombinerTransferPacket.TransferHandler(), RecipeTypes.COMBINER);
        pRegistration.addRecipeTransferHandler((IRecipeTransferHandler)new CompactorTransferPacket.TransferHandler(), RecipeTypes.COMPACTOR);
        pRegistration.addRecipeTransferHandler((IRecipeTransferHandler)new DissolverTransferPacket.TransferHandler(), RecipeTypes.DISSOLVER);
        pRegistration.addRecipeTransferHandler((IRecipeTransferHandler)new FissionTransferPacket.TransferHandler(), RecipeTypes.FISSION);
        pRegistration.addRecipeTransferHandler((IRecipeTransferHandler)new FusionTransferPacket.TransferHandler(), RecipeTypes.FUSION);
        pRegistration.addRecipeTransferHandler((IRecipeTransferHandler)new LiquifierTransferPacket.TransferHandler(), RecipeTypes.LIQUIFIER);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration pRegistration) {
        pRegistration.addRecipeCatalyst(new ItemStack((ItemLike)((Block)BlockRegistry.ATOMIZER.get()).m_5456_()), new RecipeType[]{RecipeTypes.ATOMIZER});
        pRegistration.addRecipeCatalyst(new ItemStack((ItemLike)((Block)BlockRegistry.COMBINER.get()).m_5456_()), new RecipeType[]{RecipeTypes.COMBINER});
        pRegistration.addRecipeCatalyst(new ItemStack((ItemLike)((Block)BlockRegistry.COMPACTOR.get()).m_5456_()), new RecipeType[]{RecipeTypes.COMPACTOR});
        pRegistration.addRecipeCatalyst(new ItemStack((ItemLike)((Block)BlockRegistry.DISSOLVER.get()).m_5456_()), new RecipeType[]{RecipeTypes.DISSOLVER});
        pRegistration.addRecipeCatalyst(new ItemStack((ItemLike)((Block)BlockRegistry.FISSION_CONTROLLER.get()).m_5456_()), new RecipeType[]{RecipeTypes.FISSION});
        pRegistration.addRecipeCatalyst(new ItemStack((ItemLike)((Block)BlockRegistry.FUSION_CONTROLLER.get()).m_5456_()), new RecipeType[]{RecipeTypes.FUSION});
        pRegistration.addRecipeCatalyst(new ItemStack((ItemLike)((Block)BlockRegistry.LIQUIFIER.get()).m_5456_()), new RecipeType[]{RecipeTypes.LIQUIFIER});
    }
}

