/*
 * Decompiled with CFR 0.152.
 */
package com.smashingmods.alchemistry.client.jei.category;

import com.smashingmods.alchemistry.client.jei.RecipeTypes;
import com.smashingmods.alchemistry.common.recipe.dissolver.DissolverRecipe;
import com.smashingmods.alchemistry.common.recipe.dissolver.ProbabilityGroup;
import com.smashingmods.alchemistry.registry.BlockRegistry;
import java.text.NumberFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class DissolverRecipeCategory
implements IRecipeCategory<DissolverRecipe> {
    private IGuiHelper guiHelper;

    public DissolverRecipeCategory() {
    }

    public DissolverRecipeCategory(IGuiHelper pGuiHelper) {
        this.guiHelper = pGuiHelper;
    }

    public Component getTitle() {
        return MutableComponent.m_237204_((ComponentContents)new TranslatableContents("alchemistry.jei.dissolver", null, TranslatableContents.f_237494_));
    }

    public IDrawable getBackground() {
        return this.guiHelper.createDrawable(new ResourceLocation("alchemistry", "textures/gui/dissolver_jei.png"), 0, 0, 150, 150);
    }

    public IDrawable getIcon() {
        return this.guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)BlockRegistry.DISSOLVER.get()));
    }

    public RecipeType<DissolverRecipe> getRecipeType() {
        return RecipeTypes.DISSOLVER;
    }

    public void draw(DissolverRecipe pRecipe, IRecipeSlotsView pRecipeSlotsView, GuiGraphics pGuiGraphics, double pMouseX, double pMouseY) {
        Font font = Minecraft.m_91087_().f_91062_;
        LinkedList probabilities = new LinkedList();
        pRecipe.getOutput().getProbabilityGroups().forEach(group -> group.getOutput().forEach(itemStack -> probabilities.add(group.getProbability())));
        Collections.sort(probabilities);
        Collections.reverse(probabilities);
        double totalProbability = pRecipe.getOutput().getProbabilityGroups().stream().mapToDouble(ProbabilityGroup::getProbability).sum();
        boolean weighted = pRecipe.getOutput().isWeighted();
        int rolls = pRecipe.getOutput().getRolls();
        String typeString = I18n.m_118938_((String)"alchemistry.jei.dissolver.type", (Object[])new Object[0]);
        String relativeString = I18n.m_118938_((String)"alchemistry.jei.dissolver.relative", (Object[])new Object[0]);
        String absoluteString = I18n.m_118938_((String)"alchemistry.jei.dissolver.absolute", (Object[])new Object[0]);
        String rollsString = I18n.m_118938_((String)"alchemistry.jei.dissolver.rolls", (Object[])new Object[0]);
        pGuiGraphics.m_280056_(font, String.format("%s: %s", typeString, weighted ? relativeString : absoluteString), 0, 0, -1, true);
        pGuiGraphics.m_280056_(font, String.format("%s: %s", rollsString, rolls), 0, 24, -1, true);
        int xOrigin = 43;
        int yOrigin = 52;
        for (int row = 0; row <= probabilities.size() / 2; ++row) {
            for (int column = 0; column < 2; ++column) {
                int index = column + row * 2;
                int x = xOrigin + column * 52;
                int y = yOrigin + row * 18;
                if (probabilities.size() <= index) continue;
                NumberFormat numberFormat = NumberFormat.getInstance();
                numberFormat.setMaximumFractionDigits(2);
                double percent = (Double)probabilities.get(index) / totalProbability * 100.0;
                pGuiGraphics.m_280056_(font, numberFormat.format(percent) + "%", x, y, -1, true);
            }
        }
    }

    public void setRecipe(IRecipeLayoutBuilder pBuilder, DissolverRecipe pRecipe, IFocusGroup pFocusGroup) {
        pBuilder.addSlot(RecipeIngredientRole.INPUT, 78, 17).addItemStacks(pRecipe.getInput().toStacks());
        int xOrigin = 25;
        int yOrigin = 46;
        HashMap itemProbabilityMap = new HashMap();
        pRecipe.getOutput().getProbabilityGroups().forEach(group -> group.getOutput().forEach(itemStack -> itemProbabilityMap.put(itemStack, group.getProbability())));
        List<ItemStack> items = itemProbabilityMap.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getValue).reversed()).map(Map.Entry::getKey).toList();
        items.forEach(itemStack -> {
            for (int row = 0; row <= items.size() / 2; ++row) {
                for (int column = 0; column < 2; ++column) {
                    int itemIndex = column + row * 2;
                    int x = xOrigin + column * 52;
                    int y = yOrigin + row * 18;
                    if (items.size() <= itemIndex) continue;
                    if (!((ItemStack)items.get(itemIndex)).m_41619_()) {
                        pBuilder.addSlot(RecipeIngredientRole.OUTPUT, x, y).addItemStack((ItemStack)items.get(itemIndex));
                        continue;
                    }
                    ((IRecipeSlotBuilder)pBuilder.addSlot(RecipeIngredientRole.RENDER_ONLY, x, y).addItemStack(new ItemStack((ItemLike)Items.f_42127_))).addTooltipCallback((iRecipeSlotView, list) -> {
                        list.clear();
                        list.add(MutableComponent.m_237204_((ComponentContents)new TranslatableContents("alchemistry.container.nothing", null, TranslatableContents.f_237494_)));
                    });
                }
            }
        });
    }
}

