/*
 * Decompiled with CFR 0.152.
 */
package com.smashingmods.alchemistry.common.block.atomizer;

import com.smashingmods.alchemistry.Alchemistry;
import com.smashingmods.alchemistry.Config;
import com.smashingmods.alchemistry.common.block.atomizer.AtomizerMenu;
import com.smashingmods.alchemistry.common.network.SetRecipePacket;
import com.smashingmods.alchemistry.common.recipe.atomizer.AtomizerRecipe;
import com.smashingmods.alchemistry.registry.BlockEntityRegistry;
import com.smashingmods.alchemistry.registry.RecipeRegistry;
import com.smashingmods.alchemylib.api.blockentity.processing.AbstractFluidBlockEntity;
import com.smashingmods.alchemylib.api.recipe.AbstractProcessingRecipe;
import com.smashingmods.alchemylib.api.storage.EnergyStorageHandler;
import com.smashingmods.alchemylib.api.storage.FluidStorageHandler;
import com.smashingmods.alchemylib.api.storage.ProcessingSlotHandler;
import java.util.LinkedList;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;

public class AtomizerBlockEntity
extends AbstractFluidBlockEntity {
    private AtomizerRecipe currentRecipe;
    private ResourceLocation recipeId;

    public AtomizerBlockEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        super("alchemistry", (BlockEntityType)BlockEntityRegistry.ATOMIZER_BLOCK_ENTITY.get(), pWorldPosition, pBlockState);
        this.setEnergyPerTick((Integer)Config.Common.atomizerEnergyPerTick.get());
        this.setMaxProgress((Integer)Config.Common.atomizerTicksPerOperation.get());
    }

    public void onLoad() {
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            RecipeRegistry.getAtomizerRecipe(recipe -> recipe.m_6423_().equals((Object)this.recipeId), this.f_58857_).ifPresent(this::setRecipe);
        }
        super.onLoad();
    }

    public void updateRecipe() {
        if (this.f_58857_ != null && !this.f_58857_.m_5776_() && !this.getFluidStorage().isEmpty()) {
            RecipeRegistry.getAtomizerRecipe(recipe -> recipe.getInput().getFluid().equals(this.getFluidStorage().getFluidStack().getFluid()), this.f_58857_).ifPresent(recipe -> {
                if (this.currentRecipe == null || !((Object)((Object)this.currentRecipe)).equals(recipe)) {
                    this.setProgress(0);
                    this.setRecipe(recipe.copy());
                }
            });
        }
    }

    public boolean canProcessRecipe() {
        if (this.currentRecipe != null) {
            return this.getEnergyHandler().getEnergyStored() >= this.getEnergyPerTick() && this.getFluidStorage().getFluidAmount() >= this.currentRecipe.getInput().getAmount() && (ItemStack.m_150942_((ItemStack)this.getOutputHandler().getStackInSlot(0), (ItemStack)this.currentRecipe.getOutput()) || this.getOutputHandler().getStackInSlot(0).m_41619_()) && this.getOutputHandler().getStackInSlot(0).m_41613_() + this.currentRecipe.getOutput().m_41613_() <= this.currentRecipe.getOutput().m_41741_();
        }
        return false;
    }

    public void processRecipe() {
        if (this.getProgress() < this.getMaxProgress()) {
            this.incrementProgress();
        } else {
            AtomizerRecipe tempRecipe = this.currentRecipe.copy();
            this.setProgress(0);
            this.getOutputHandler().setOrIncrement(0, tempRecipe.getOutput().m_41777_());
            this.getFluidStorage().drain(tempRecipe.getInput().getAmount(), IFluidHandler.FluidAction.EXECUTE);
        }
        this.getEnergyHandler().extractEnergy(this.getEnergyPerTick(), false);
        this.m_6596_();
    }

    public <R extends AbstractProcessingRecipe> void setRecipe(@Nullable R pRecipe) {
        if (pRecipe instanceof AtomizerRecipe) {
            AtomizerRecipe atomizerRecipe;
            this.currentRecipe = atomizerRecipe = (AtomizerRecipe)pRecipe;
        }
    }

    public AtomizerRecipe getRecipe() {
        return this.currentRecipe;
    }

    public LinkedList<AtomizerRecipe> getAllRecipes() {
        if (this.f_58857_ != null) {
            return new LinkedList<AtomizerRecipe>(RecipeRegistry.getAtomizerRecipes(this.f_58857_));
        }
        return new LinkedList<AtomizerRecipe>();
    }

    public EnergyStorageHandler initializeEnergyStorage() {
        return new EnergyStorageHandler((Integer)Config.Common.atomizerEnergyCapacity.get()){

            protected void onEnergyChanged() {
                super.onEnergyChanged();
                AtomizerBlockEntity.this.m_6596_();
            }
        };
    }

    public FluidStorageHandler initializeFluidStorage() {
        return new FluidStorageHandler((Integer)Config.Common.atomizerFluidCapacity.get(), FluidStack.EMPTY){

            protected void onContentsChanged() {
                if (!this.isEmpty()) {
                    AtomizerBlockEntity.this.updateRecipe();
                }
                AtomizerBlockEntity.this.setCanProcess(AtomizerBlockEntity.this.canProcessRecipe());
                AtomizerBlockEntity.this.m_6596_();
            }
        };
    }

    public ProcessingSlotHandler initializeInputHandler() {
        return new ProcessingSlotHandler(0);
    }

    public ProcessingSlotHandler initializeOutputHandler() {
        return new ProcessingSlotHandler(1){

            public boolean isItemValid(int pSlot, ItemStack pItemStack) {
                return false;
            }
        };
    }

    protected void m_183515_(CompoundTag pTag) {
        if (this.currentRecipe != null) {
            pTag.m_128359_("recipeId", this.currentRecipe.m_6423_().toString());
        }
        super.m_183515_(pTag);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.recipeId = ResourceLocation.m_135820_((String)pTag.m_128461_("recipeId"));
        if (this.f_58857_ != null && this.f_58857_.m_5776_()) {
            RecipeRegistry.getAtomizerRecipe(recipe -> recipe.m_6423_().equals((Object)this.recipeId), this.f_58857_).ifPresent(recipe -> {
                if (!((Object)recipe).equals((Object)this.currentRecipe)) {
                    this.setRecipe(recipe);
                    Alchemistry.PACKET_HANDLER.sendToServer(new SetRecipePacket(this.m_58899_(), recipe.m_6423_(), recipe.m_6076_()));
                }
            });
        }
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pInventory, Player pPlayer) {
        return new AtomizerMenu(pContainerId, pInventory, (BlockEntity)this);
    }
}

