/*
 * Decompiled with CFR 0.152.
 */
package com.smashingmods.alchemistry.datagen.recipe.atomizer;

import com.smashingmods.alchemistry.datagen.recipe.atomizer.AtomizerRecipeBuilder;
import com.smashingmods.alchemylib.datagen.DatagenHelpers;
import com.smashingmods.chemlib.api.Chemical;
import com.smashingmods.chemlib.api.MatterState;
import com.smashingmods.chemlib.registry.FluidRegistry;
import com.smashingmods.chemlib.registry.ItemRegistry;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.crafting.ConditionalRecipe;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class AtomizerRecipeProvider {
    private final Consumer<FinishedRecipe> consumer;

    public AtomizerRecipeProvider(Consumer<FinishedRecipe> pConsumer) {
        this.consumer = pConsumer;
    }

    public static void register(Consumer<FinishedRecipe> pConsumer) {
        new AtomizerRecipeProvider(pConsumer).register();
    }

    private void register() {
        ItemRegistry.getElements().stream().filter(element -> element.getMatterState().equals((Object)MatterState.LIQUID) || element.getMatterState().equals((Object)MatterState.GAS) && !element.isArtificial()).forEach(this.chemicalToFluidRecipe());
        ItemRegistry.getCompounds().stream().filter(compound -> compound.getMatterState().equals((Object)MatterState.LIQUID) || compound.getMatterState().equals((Object)MatterState.GAS)).forEach(this.chemicalToFluidRecipe());
        ItemRegistry.getCompoundByName((String)"water").ifPresent(water -> this.atomizer(new FluidStack((Fluid)Fluids.f_76193_, 500), new ItemStack((ItemLike)water, 8)));
    }

    private Consumer<? super Chemical> chemicalToFluidRecipe() {
        return chemical -> FluidRegistry.FLUIDS.getEntries().stream().map(RegistryObject::get).filter(fluid -> Objects.requireNonNull(ForgeRegistries.FLUIDS.getKey(fluid)).m_135815_().contains(chemical.getChemicalName())).findFirst().map(fluid -> new FluidStack(fluid, 500)).ifPresent(fluidStack -> this.atomizer((FluidStack)fluidStack, new ItemStack((ItemLike)chemical, 8)));
    }

    private void atomizer(FluidStack pInput, ItemStack pOutput, ICondition pCondition) {
        ResourceLocation recipeId = ForgeRegistries.ITEMS.getKey((Object)pOutput.m_41720_());
        ConditionalRecipe.builder().addCondition(pCondition).addRecipe(arg_0 -> ((RecipeBuilder)AtomizerRecipeBuilder.createRecipe(pInput, pOutput, Objects.requireNonNull(recipeId)).m_126145_(String.format("%s:atomizer", "alchemistry")).m_126132_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)DatagenHelpers.getLocation((ItemStack)pOutput, (String)"atomizer", (String)"alchemistry")))).m_176498_(arg_0)).build(this.consumer, new ResourceLocation("alchemistry", String.format("atomizer/%s", recipeId.m_135815_())));
    }

    private void atomizer(FluidStack pInput, ItemStack pOutput) {
        ResourceLocation recipeId = ForgeRegistries.ITEMS.getKey((Object)pOutput.m_41720_());
        AtomizerRecipeBuilder.createRecipe(pInput, pOutput, Objects.requireNonNull(recipeId)).m_126145_(String.format("%s:atomizer", "alchemistry")).m_126132_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)DatagenHelpers.getLocation((ItemStack)pOutput, (String)"atomizer", (String)"alchemistry"))).m_176498_(this.consumer);
    }
}

