/*
 * Decompiled with CFR 0.152.
 */
package dev.smolinacadena.refinedcooking.config;

import net.minecraftforge.common.ForgeConfigSpec;

public class ServerConfig {
    private final ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
    private final ForgeConfigSpec spec;
    private final KitchenStation kitchenStation = new KitchenStation();
    private final KitchenAccessPoint kitchenAccessPoint = new KitchenAccessPoint();

    public ServerConfig() {
        this.spec = this.builder.build();
    }

    public ForgeConfigSpec getSpec() {
        return this.spec;
    }

    public KitchenStation getKitchenStation() {
        return this.kitchenStation;
    }

    public KitchenAccessPoint getKitchenAccessPoint() {
        return this.kitchenAccessPoint;
    }

    public class KitchenStation {
        private final ForgeConfigSpec.IntValue usage;

        public KitchenStation() {
            ServerConfig.this.builder.push("kitchenStation");
            this.usage = ServerConfig.this.builder.comment("The energy used by the Kitchen Station").defineInRange("usage", 1, 0, Integer.MAX_VALUE);
            ServerConfig.this.builder.pop();
        }

        public int getUsage() {
            return (Integer)this.usage.get();
        }
    }

    public class KitchenAccessPoint {
        private final ForgeConfigSpec.IntValue usage;

        public KitchenAccessPoint() {
            ServerConfig.this.builder.push("kitchenAccessPoint");
            this.usage = ServerConfig.this.builder.comment("The energy used by the Kitchen Access Point").defineInRange("usage", 1, 0, Integer.MAX_VALUE);
            ServerConfig.this.builder.pop();
        }

        public int getUsage() {
            return (Integer)this.usage.get();
        }
    }
}

