/*
 * Decompiled with CFR 0.152.
 */
package com.github.mnesikos.simplycats.compat;

import com.github.mnesikos.simplycats.item.SCItems;
import com.google.common.collect.Lists;
import com.simibubi.create.content.fluids.transfer.EmptyingRecipe;
import com.simibubi.create.content.fluids.transfer.FillingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import umpaz.farmersrespite.common.fluid.TeaFluidType;
import umpaz.farmersrespite.common.tag.FRTags;
import umpaz.farmersrespite.data.builder.KettlePouringRecipeBuilder;
import umpaz.farmersrespite.data.builder.KettleRecipeBuilder;
import vectorwing.farmersdelight.common.item.DrinkableItem;
import vectorwing.farmersdelight.common.registry.ModEffects;
import vectorwing.farmersdelight.common.tag.ForgeTags;

public class FarmersRespiteCompat {
    public static final FoodProperties CATNIP_TEA_FOOD = new FoodProperties.Builder().m_38765_().effect(() -> new MobEffectInstance((MobEffect)ModEffects.COMFORT.get(), 3600, 0), 1.0f).m_38767_();
    public static final FoodProperties LONG_CATNIP_TEA_FOOD = new FoodProperties.Builder().m_38765_().effect(() -> new MobEffectInstance((MobEffect)ModEffects.COMFORT.get(), 5400, 0), 1.0f).m_38767_();
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"simplycats");
    public static final RegistryObject<Item> CATNIP_TEA = ITEMS.register("catnip_tea", () -> new DrinkableItem(new Item.Properties().m_41495_(Items.f_42590_).m_41487_(16).m_41489_(CATNIP_TEA_FOOD), true, false));
    public static final RegistryObject<Item> LONG_CATNIP_TEA = ITEMS.register("long_catnip_tea", () -> new DrinkableItem(new Item.Properties().m_41495_(Items.f_42590_).m_41487_(16).m_41489_(LONG_CATNIP_TEA_FOOD), true, false));
    public static final DeferredRegister<FluidType> FLUID_TYPES = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.FLUID_TYPES, (String)"simplycats");
    public static final DeferredRegister<Fluid> FLUIDS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FLUIDS, (String)"simplycats");
    public static final RegistryObject<FluidType> CATNIP_TEA_FLUID = FLUID_TYPES.register("catnip_tea_type", () -> new TeaFluidType(-1260712));
    public static final RegistryObject<FlowingFluid> CATNIP_TEA_SOURCE = FLUIDS.register("catnip_tea", () -> new ForgeFlowingFluid.Source(CATNIP_TEA_FLUID_PROPERTIES));
    public static final RegistryObject<FlowingFluid> CATNIP_TEA_FLOWING = FLUIDS.register("flowing_catnip_tea", () -> new ForgeFlowingFluid.Flowing(CATNIP_TEA_FLUID_PROPERTIES));
    public static final ForgeFlowingFluid.Properties CATNIP_TEA_FLUID_PROPERTIES = new ForgeFlowingFluid.Properties(CATNIP_TEA_FLUID, CATNIP_TEA_SOURCE, CATNIP_TEA_FLOWING);
    public static final RegistryObject<FluidType> LONG_CATNIP_TEA_FLUID = FLUID_TYPES.register("long_catnip_tea_type", () -> new TeaFluidType(-1260712));
    public static final RegistryObject<FlowingFluid> LONG_CATNIP_TEA_SOURCE = FLUIDS.register("long_catnip_tea", () -> new ForgeFlowingFluid.Source(LONG_CATNIP_TEA_FLUID_PROPERTIES));
    public static final RegistryObject<FlowingFluid> LONG_CATNIP_TEA_FLOWING = FLUIDS.register("flowing_long_catnip_tea", () -> new ForgeFlowingFluid.Flowing(LONG_CATNIP_TEA_FLUID_PROPERTIES));
    public static final ForgeFlowingFluid.Properties LONG_CATNIP_TEA_FLUID_PROPERTIES = new ForgeFlowingFluid.Properties(LONG_CATNIP_TEA_FLUID, LONG_CATNIP_TEA_SOURCE, LONG_CATNIP_TEA_FLOWING);

    public static void register(IEventBus bus) {
        ITEMS.register(bus);
        FLUID_TYPES.register(bus);
        FLUIDS.register(bus);
    }

    public static void buildRecipes(Consumer<FinishedRecipe> consumer) {
        SCKettleRecipeBuilder.kettleRecipe(new FluidStack((Fluid)Fluids.f_76193_, 1000), new FluidStack((Fluid)CATNIP_TEA_SOURCE.get(), 1000), 2400, 0.35f).addIngredient((ItemLike)SCItems.CATNIP.get()).addIngredient((TagKey<Item>)FRTags.TEA_LEAVES).build(consumer);
        SCKettleRecipeBuilder.kettleRecipe(new FluidStack((Fluid)CATNIP_TEA_SOURCE.get(), 1000), new FluidStack((Fluid)LONG_CATNIP_TEA_SOURCE.get(), 1000), 2400, 0.35f).addIngredient((TagKey<Item>)ForgeTags.MILK).build(consumer);
        SCKettlePouringRecipeBuilder.kettlePouringRecipe((ItemLike)Items.f_42590_, (Fluid)CATNIP_TEA_SOURCE.get(), 250, (ItemLike)CATNIP_TEA.get(), consumer);
        SCKettlePouringRecipeBuilder.kettlePouringRecipe((ItemLike)Items.f_42590_, (Fluid)LONG_CATNIP_TEA_SOURCE.get(), 250, (ItemLike)LONG_CATNIP_TEA.get(), consumer);
    }

    public static class SCKettleRecipeBuilder {
        private final List<Ingredient> ingredients = Lists.newArrayList();
        private final int brewingTime;
        private final float experience;
        private final FluidStack fluidIn;
        private final FluidStack fluidOut;

        public SCKettleRecipeBuilder(FluidStack fluidIn, FluidStack fluidOut, int brewingTime, float experience) {
            this.fluidIn = fluidIn;
            this.fluidOut = fluidOut;
            this.brewingTime = brewingTime;
            this.experience = experience;
        }

        public static SCKettleRecipeBuilder kettleRecipe(FluidStack fluidIn, FluidStack fluidOut, int cookingTime, float experience) {
            return new SCKettleRecipeBuilder(fluidIn, fluidOut, cookingTime, experience);
        }

        public SCKettleRecipeBuilder addIngredient(TagKey<Item> itemTagKey) {
            this.ingredients.add(Ingredient.m_204132_(itemTagKey));
            return this;
        }

        public SCKettleRecipeBuilder addIngredient(ItemLike itemLike) {
            this.ingredients.add(Ingredient.m_43929_((ItemLike[])new ItemLike[]{itemLike}));
            return this;
        }

        public void build(Consumer<FinishedRecipe> consumer) {
            ResourceLocation baseFluidLocation = ForgeRegistries.FLUIDS.getKey((Object)this.fluidIn.getFluid());
            ResourceLocation resultFluidLocation = ForgeRegistries.FLUIDS.getKey((Object)this.fluidOut.getFluid());
            ResourceLocation id = new ResourceLocation("simplycats:brewing/" + resultFluidLocation.m_135815_() + "_from_" + baseFluidLocation.m_135815_());
            consumer.accept((FinishedRecipe)new KettleRecipeBuilder.Result(id, this.fluidIn, this.fluidOut, this.ingredients, this.brewingTime, this.experience));
        }
    }

    public static class SCKettlePouringRecipeBuilder {
        private final ItemStack container;
        private final Fluid fluid;
        private final int amount;
        private final ItemStack output;

        public SCKettlePouringRecipeBuilder(ItemStack container, Fluid fluid, int amount, ItemStack output) {
            this.container = container;
            this.fluid = fluid;
            this.amount = amount;
            this.output = output;
        }

        public static void kettlePouringRecipe(ItemLike container, Fluid fluid, int amount, ItemLike output, Consumer<FinishedRecipe> consumer) {
            new SCKettlePouringRecipeBuilder(container.m_5456_().m_7968_(), fluid, amount, output.m_5456_().m_7968_()).build(consumer);
        }

        public void build(Consumer<FinishedRecipe> consumer) {
            ResourceLocation id = new ResourceLocation("simplycats:pouring/" + ForgeRegistries.ITEMS.getKey((Object)this.output.m_41720_()).m_135815_());
            consumer.accept((FinishedRecipe)new KettlePouringRecipeBuilder.Result(id, this.container, this.fluid, this.amount, this.output));
            if (ModList.get().isLoaded("create")) {
                new ProcessingRecipeBuilder(FillingRecipe::new, new ResourceLocation("simplycats", id.m_135815_().replace("pouring/", ""))).require(this.fluid, this.amount).require((ItemLike)this.container.m_41720_()).output(this.output).build(consumer);
                new ProcessingRecipeBuilder(EmptyingRecipe::new, new ResourceLocation("simplycats", id.m_135815_().replace("pouring/", ""))).require((ItemLike)this.output.m_41720_()).output(this.fluid, this.amount).output(this.container).build(consumer);
            }
        }
    }
}

