/*
 * Decompiled with CFR 0.152.
 */
package com.github.mnesikos.simplycats.entity.core;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.RandomSource;

public class Genetics {
    public static MutableComponent getPhenotypeDescription(CompoundTag nbt, boolean includeSex) {
        Component sex = Sex.getPrettyName(nbt.m_128461_("Phaeomelanin"));
        String eumelanin = Eumelanin.getPhenotype(nbt.m_128461_("Eumelanin"));
        String phaeomelanin = Phaeomelanin.getPhenotype(nbt.m_128461_("Phaeomelanin"));
        String dilution = Dilution.getPhenotype(nbt.m_128461_("Dilution"));
        String diluteMod = DiluteMod.getPhenotype(nbt.m_128461_("DiluteMod"));
        boolean isRed = phaeomelanin.equals(Phaeomelanin.RED.toString().toLowerCase());
        String redElseBlack = isRed ? phaeomelanin : eumelanin;
        MutableComponent base = Component.m_237115_((String)("cat.base." + redElseBlack + ".name"));
        if (dilution.equals(Dilution.DILUTE.toString().toLowerCase())) {
            base = Component.m_237115_((String)("cat.base." + redElseBlack + "_" + dilution + ".name"));
            if (diluteMod.equals(DiluteMod.CARAMELIZED.toString().toLowerCase())) {
                base = Component.m_237115_((String)("cat.base." + redElseBlack + "_" + diluteMod + ".name"));
            }
        }
        String agouti = Agouti.getPhenotype(nbt.m_128461_("Agouti"));
        boolean isAgouti = agouti.equals(Agouti.TABBY.toString().toLowerCase());
        String inhibitor = Inhibitor.getPhenotype(nbt.m_128461_("Inhibitor"));
        if (inhibitor.equals(Inhibitor.SILVER.toString().toLowerCase())) {
            base = Component.m_237113_((String)(base.getString() + " " + Component.m_237115_((String)("cat.base." + inhibitor + (isAgouti ? "" : "_smoke") + ".name")).getString()));
        }
        if (phaeomelanin.equals(Phaeomelanin.TORTOISESHELL.toString().toLowerCase())) {
            base = Component.m_237113_((String)(base.getString() + " " + Component.m_237115_((String)("cat.base." + phaeomelanin + ".name")).getString()));
        }
        String tabby1 = Tabby.getPhenotype(nbt.m_128461_("Tabby"));
        String spotted = Spotted.getPhenotype(nbt.m_128461_("Spotted"));
        String ticked = Ticked.getPhenotype(nbt.m_128461_("Ticked"));
        MutableComponent tabby = Component.m_237115_((String)"");
        if (isAgouti || isRed) {
            tabby = Component.m_237115_((String)("cat.tabby." + tabby1 + ".name"));
            if (spotted.equals(Spotted.BROKEN.toString().toLowerCase()) || spotted.equals(Spotted.SPOTTED.toString().toLowerCase())) {
                tabby = Component.m_237115_((String)("cat.tabby." + spotted + ".name"));
            }
            if (ticked.equals(Ticked.TICKED.toString().toLowerCase())) {
                tabby = Component.m_237115_((String)("cat.tabby." + ticked + ".name"));
            }
        }
        String colorpoint = Colorpoint.getPhenotype(nbt.m_128461_("Colorpoint"));
        MutableComponent point = Component.m_237115_((String)"");
        if (!colorpoint.equals(Colorpoint.NOT_POINTED.toString().toLowerCase())) {
            point = Component.m_237115_((String)("cat.point." + colorpoint + ".name"));
            if (colorpoint.equals(Colorpoint.ALBINO.toString().toLowerCase())) {
                MutableComponent eyes = Component.m_237115_((String)"cat.point.red_eyed.name");
                if (nbt.m_128461_("Colorpoint").contains(Colorpoint.BLUE_EYED_ALBINO.getAllele())) {
                    eyes = Component.m_237115_((String)"cat.point.blue_eyed.name");
                }
                return Component.m_237113_((String)(eyes.getString() + " " + point.getString() + (String)(includeSex ? " " + sex.getString() : "")));
            }
        }
        String whitePh = White.getPhenotype(nbt.m_128461_("White"));
        MutableComponent white = Component.m_237115_((String)"");
        if (!whitePh.equals(White.NONE.toString().toLowerCase())) {
            if (whitePh.equals(White.DOMINANT.toString().toLowerCase()) || nbt.m_128461_("White_0").contains("6")) {
                white = Component.m_237115_((String)"cat.white.solid_white.name");
                return Component.m_237113_((String)(white.getString() + (String)(includeSex ? " " + sex.getString() : "")));
            }
            if (nbt.m_128461_("White_0").contains("5")) {
                white = Component.m_237115_((String)"cat.white.mostly_white.name");
                return Component.m_237113_((String)(white.getString() + " " + base.getString() + (String)(tabby.getString().equals("") ? "" : " " + tabby.getString()) + (String)(point.getString().equals("") ? "" : " " + point.getString()) + (String)(includeSex ? " " + sex.getString() : "")));
            }
            white = Component.m_237115_((String)"cat.white.some_white.name");
        }
        return Component.m_237113_((String)(base.getString() + (String)(tabby.getString().equals("") ? "" : " " + tabby.getString()) + (String)(point.getString().equals("") ? "" : " " + point.getString()) + (String)(white.getString().equals("") ? "" : " " + white.getString()) + (String)(includeSex ? " " + sex.getString() : "")));
    }

    public static enum Sex {
        MALE("male"),
        FEMALE("female");

        private String name;

        private Sex(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static Component getPrettyName(String phaeomelanin) {
            if (phaeomelanin.contains(Phaeomelanin.MALE.getAllele())) {
                return Component.m_237115_((String)"cat.sex.male.name");
            }
            if (!phaeomelanin.contains(Phaeomelanin.MALE.getAllele())) {
                return Component.m_237115_((String)"cat.sex.female.name");
            }
            return Component.m_237113_((String)phaeomelanin);
        }
    }

    public static enum Eumelanin {
        BLACK("B"),
        CHOCOLATE("b"),
        CINNAMON("b1");

        private String allele;

        private Eumelanin(String allele) {
            this.allele = allele;
        }

        public String getAllele() {
            return this.allele;
        }

        public static String init(RandomSource rand) {
            float chance = rand.m_188501_();
            if (chance <= 0.8f) {
                return BLACK.getAllele();
            }
            if (chance > 0.8f && chance <= 0.96f) {
                return CHOCOLATE.getAllele();
            }
            return CINNAMON.getAllele();
        }

        public static String getPhenotype(String alleles) {
            if (alleles.isEmpty()) {
                return BLACK.toString().toLowerCase();
            }
            String[] value = alleles.split("-");
            if (value[0].equals("B") || value[1].equals("B")) {
                return BLACK.toString().toLowerCase();
            }
            if (value[0].equals("b") || value[1].equals("b")) {
                return CHOCOLATE.toString().toLowerCase();
            }
            return CINNAMON.toString().toLowerCase();
        }
    }

    public static enum Phaeomelanin {
        NOT_RED("Xo"),
        RED("XO"),
        MALE("Y"),
        TORTOISESHELL;

        private String allele;

        private Phaeomelanin(String allele) {
            this.allele = allele;
        }

        private Phaeomelanin() {
        }

        public String getAllele() {
            return this.allele;
        }

        public static String init(RandomSource rand) {
            float chance1 = rand.m_188501_();
            String allele1 = chance1 <= 0.75f ? NOT_RED.getAllele() : RED.getAllele();
            float chance2 = rand.m_188501_();
            String allele2 = allele1.equals(NOT_RED.getAllele()) ? (chance2 <= 0.75f ? NOT_RED.getAllele() : RED.getAllele()) : (chance2 <= 0.75f ? RED.getAllele() : NOT_RED.getAllele());
            return allele1 + "-" + (rand.m_188503_(2) == 0 ? MALE.getAllele() : allele2);
        }

        public static String getPhenotype(String alleles) {
            switch (alleles) {
                case "XO-Y": 
                case "XO-XO": {
                    return RED.toString().toLowerCase();
                }
                default: {
                    return NOT_RED.toString().toLowerCase();
                }
                case "XO-Xo": 
                case "Xo-XO": 
            }
            return TORTOISESHELL.toString().toLowerCase();
        }
    }

    public static enum Dilution {
        NON_DILUTE("D"),
        DILUTE("d");

        private String allele;

        private Dilution(String allele) {
            this.allele = allele;
        }

        public String getAllele() {
            return this.allele;
        }

        public static String init(RandomSource rand) {
            float chance = rand.m_188501_();
            if (chance <= 0.6f) {
                return NON_DILUTE.getAllele();
            }
            return DILUTE.getAllele();
        }

        public static String getPhenotype(String alleles) {
            if (alleles.isEmpty()) {
                return NON_DILUTE.toString().toLowerCase();
            }
            String[] value = alleles.split("-");
            if (value[0].equals("D") || value[1].equals("D")) {
                return NON_DILUTE.toString().toLowerCase();
            }
            return DILUTE.toString().toLowerCase();
        }
    }

    public static enum DiluteMod {
        NON_CARAMEL("dm"),
        CARAMELIZED("Dm");

        private String allele;

        private DiluteMod(String allele) {
            this.allele = allele;
        }

        public String getAllele() {
            return this.allele;
        }

        public static String init(RandomSource rand) {
            float chance = rand.m_188501_();
            if (chance <= 0.96f) {
                return NON_CARAMEL.getAllele();
            }
            return CARAMELIZED.getAllele();
        }

        public static String getPhenotype(String alleles) {
            if (alleles.isEmpty()) {
                return NON_CARAMEL.toString().toLowerCase();
            }
            String[] value = alleles.split("-");
            if (value[0].equals("Dm") || value[1].equals("Dm")) {
                return CARAMELIZED.toString().toLowerCase();
            }
            return NON_CARAMEL.toString().toLowerCase();
        }
    }

    public static enum Agouti {
        SOLID("a"),
        TABBY("A");

        private String allele;

        private Agouti(String allele) {
            this.allele = allele;
        }

        public String getAllele() {
            return this.allele;
        }

        public static String init(RandomSource rand) {
            float chance = rand.m_188501_();
            if (chance <= 0.8f) {
                return SOLID.getAllele();
            }
            return TABBY.getAllele();
        }

        public static String getPhenotype(String alleles) {
            if (alleles.isEmpty()) {
                return SOLID.toString().toLowerCase();
            }
            String[] value = alleles.split("-");
            if (value[0].equals("A") || value[1].equals("A")) {
                return TABBY.toString().toLowerCase();
            }
            return SOLID.toString().toLowerCase();
        }
    }

    public static enum Inhibitor {
        NORMAL("i"),
        SILVER("I");

        private String allele;

        private Inhibitor(String allele) {
            this.allele = allele;
        }

        public String getAllele() {
            return this.allele;
        }

        public static String init(RandomSource rand) {
            float chance = rand.m_188501_();
            if (chance <= 0.96f) {
                return NORMAL.getAllele();
            }
            return SILVER.getAllele();
        }

        public static String getPhenotype(String alleles) {
            if (alleles.isEmpty()) {
                return NORMAL.toString().toLowerCase();
            }
            String[] value = alleles.split("-");
            if (value[0].equals("I") || value[1].equals("I")) {
                return SILVER.toString().toLowerCase();
            }
            return NORMAL.toString().toLowerCase();
        }
    }

    public static enum Tabby {
        MACKEREL("Mc"),
        CLASSIC("mc");

        private String allele;

        private Tabby(String allele) {
            this.allele = allele;
        }

        public String getAllele() {
            return this.allele;
        }

        public static String init(RandomSource rand) {
            float chance = rand.m_188501_();
            if (chance <= 0.5f) {
                return MACKEREL.getAllele();
            }
            return CLASSIC.getAllele();
        }

        public static String getPhenotype(String alleles) {
            if (alleles.isEmpty()) {
                return MACKEREL.toString().toLowerCase();
            }
            String[] value = alleles.split("-");
            if (value[0].equals("Mc") || value[1].equals("Mc")) {
                return MACKEREL.toString().toLowerCase();
            }
            return CLASSIC.toString().toLowerCase();
        }
    }

    public static enum Spotted {
        NON_SPOTTED("sp"),
        SPOTTED("Sp"),
        BROKEN;

        private String allele;

        private Spotted(String allele) {
            this.allele = allele;
        }

        private Spotted() {
        }

        public String getAllele() {
            return this.allele;
        }

        public static String init(RandomSource rand) {
            float chance = rand.m_188501_();
            if (chance <= 0.8f) {
                return NON_SPOTTED.getAllele();
            }
            return SPOTTED.getAllele();
        }

        public static String getPhenotype(String alleles) {
            switch (alleles) {
                case "Sp-Sp": {
                    return SPOTTED.toString().toLowerCase();
                }
                case "Sp-sp": 
                case "sp-Sp": {
                    return BROKEN.toString().toLowerCase();
                }
            }
            return NON_SPOTTED.toString().toLowerCase();
        }
    }

    public static enum Ticked {
        NON_TICKED("ta"),
        TICKED("Ta");

        private String allele;

        private Ticked(String allele) {
            this.allele = allele;
        }

        public String getAllele() {
            return this.allele;
        }

        public static String init(RandomSource rand) {
            float chance = rand.m_188501_();
            if (chance <= 0.96f) {
                return NON_TICKED.getAllele();
            }
            return TICKED.getAllele();
        }

        public static String getPhenotype(String alleles) {
            if (alleles.isEmpty()) {
                return NON_TICKED.toString().toLowerCase();
            }
            String[] value = alleles.split("-");
            if (value[0].equals("Ta") || value[1].equals("Ta")) {
                return TICKED.toString().toLowerCase();
            }
            return NON_TICKED.toString().toLowerCase();
        }
    }

    public static enum Colorpoint {
        NOT_POINTED("C"),
        COLORPOINT("cs"),
        SEPIA("cb"),
        MINK,
        BLUE_EYED_ALBINO("ca"),
        RED_EYED_ALBINO("c"),
        ALBINO;

        private String allele;

        private Colorpoint(String allele) {
            this.allele = allele;
        }

        private Colorpoint() {
        }

        public String getAllele() {
            return this.allele;
        }

        public static String init(RandomSource rand) {
            float chance = rand.m_188501_();
            if (chance <= 0.8f) {
                return NOT_POINTED.getAllele();
            }
            if (chance <= 0.94f) {
                return COLORPOINT.getAllele();
            }
            if (chance <= 0.98f) {
                return SEPIA.getAllele();
            }
            if (rand.m_188501_() <= 0.7f) {
                return BLUE_EYED_ALBINO.getAllele();
            }
            return RED_EYED_ALBINO.getAllele();
        }

        public static String getPhenotype(String alleles) {
            if (alleles.contains("C")) {
                return NOT_POINTED.toString().toLowerCase();
            }
            if (alleles.contains("cs") && alleles.contains("cb")) {
                return MINK.toString().toLowerCase();
            }
            if (alleles.contains("cs")) {
                return COLORPOINT.toString().toLowerCase();
            }
            if (alleles.contains("cb")) {
                return SEPIA.toString().toLowerCase();
            }
            if (alleles.contains("ca") || alleles.contains("c")) {
                return ALBINO.toString().toLowerCase();
            }
            return NOT_POINTED.toString().toLowerCase();
        }
    }

    public static enum White {
        NONE("w"),
        SPOTTING("Ws"),
        DOMINANT("Wd");

        private String allele;

        private White(String allele) {
            this.allele = allele;
        }

        public String getAllele() {
            return this.allele;
        }

        public static String init(RandomSource rand) {
            float chance = rand.m_188501_();
            if (chance <= 0.49f) {
                return NONE.getAllele();
            }
            if (chance > 0.49f && chance <= 0.98f) {
                return SPOTTING.getAllele();
            }
            return DOMINANT.getAllele();
        }

        public static String getPhenotype(String alleles) {
            switch (alleles) {
                case "Wd-Wd": 
                case "Wd-w": 
                case "Wd-Ws": 
                case "w-Wd": 
                case "Ws-Wd": {
                    return DOMINANT.toString().toLowerCase();
                }
                case "Ws-Ws": 
                case "Ws-w": 
                case "w-Ws": {
                    return SPOTTING.toString().toLowerCase();
                }
            }
            return NONE.toString().toLowerCase();
        }
    }

    public static enum Bobtail {
        FULL("Jb"),
        BOBTAIL("jb");

        private String allele;

        private Bobtail(String allele) {
            this.allele = allele;
        }

        public String getAllele() {
            return this.allele;
        }

        public static String init(RandomSource rand) {
            float chance = rand.m_188501_();
            if (chance <= 0.98f) {
                return FULL.getAllele();
            }
            return BOBTAIL.getAllele();
        }

        public static boolean isBobtail(String alleles) {
            return !alleles.isEmpty() && alleles.equals("jb-jb");
        }
    }

    public static enum FurLength {
        SHORT("L"),
        LONG("l");

        private String allele;

        private FurLength(String allele) {
            this.allele = allele;
        }

        public String getAllele() {
            return this.allele;
        }

        public static String init(RandomSource rand) {
            float chance = rand.m_188501_();
            if (chance <= 0.75f) {
                return SHORT.getAllele();
            }
            return LONG.getAllele();
        }

        public static String getPhenotype(String alleles) {
            if (alleles.isEmpty()) {
                return SHORT.toString().toLowerCase();
            }
            String[] value = alleles.split("-");
            if (value[0].equals("L") || value[1].equals("L")) {
                return SHORT.toString().toLowerCase();
            }
            return LONG.toString().toLowerCase();
        }
    }

    public static enum EyeColor {
        COPPER,
        GOLD,
        HAZEL,
        GREEN,
        BLUE,
        ALBINO_BLUE,
        ALBINO_RED;


        public static String init(int value) {
            switch (value) {
                case 0: {
                    return COPPER.toString().toLowerCase();
                }
                case 1: {
                    return GOLD.toString().toLowerCase();
                }
                default: {
                    return HAZEL.toString().toLowerCase();
                }
                case 3: {
                    return GREEN.toString().toLowerCase();
                }
                case 4: {
                    return BLUE.toString().toLowerCase();
                }
                case 5: {
                    return ALBINO_BLUE.toString().toLowerCase();
                }
                case 6: 
            }
            return ALBINO_RED.toString().toLowerCase();
        }

        public static String getPhenotype(String eyes) {
            switch (eyes) {
                case "copper": {
                    return COPPER.toString().toLowerCase();
                }
                case "gold": {
                    return GOLD.toString().toLowerCase();
                }
                default: {
                    return HAZEL.toString().toLowerCase();
                }
                case "green": {
                    return GREEN.toString().toLowerCase();
                }
                case "blue": {
                    return BLUE.toString().toLowerCase();
                }
                case "albino_blue": {
                    return ALBINO_BLUE.toString().toLowerCase();
                }
                case "albino_red": 
            }
            return ALBINO_RED.toString().toLowerCase();
        }
    }
}

