/*
 * Decompiled with CFR 0.152.
 */
package com.github.mnesikos.simplycats.entity.goal;

import com.github.mnesikos.simplycats.entity.SimplyCatEntity;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;

public class SCRelaxOnOwnerGoal
extends Goal {
    private final SimplyCatEntity cat;
    @Nullable
    private Player owner;
    @Nullable
    private BlockPos goalPos;
    private int onBedTicks;

    public SCRelaxOnOwnerGoal(SimplyCatEntity cat) {
        this.cat = cat;
    }

    public boolean m_8036_() {
        if (!this.cat.m_21824_()) {
            return false;
        }
        if (this.cat.m_21827_()) {
            return false;
        }
        LivingEntity living = this.cat.m_269323_();
        if (living instanceof Player) {
            this.owner = (Player)living;
            if (!living.m_5803_()) {
                return false;
            }
            if (this.cat.m_20280_((Entity)this.owner) > 12.0) {
                return false;
            }
            BlockPos blockpos = this.owner.m_20183_();
            BlockState blockstate = this.cat.m_9236_().m_8055_(blockpos);
            if (blockstate.m_204336_(BlockTags.f_13038_)) {
                this.goalPos = blockstate.m_61145_((Property)BedBlock.f_54117_).map(direction -> blockpos.m_121945_(direction.m_122424_())).orElseGet(() -> new BlockPos((Vec3i)blockpos));
                return !this.spaceIsOccupied();
            }
        }
        return false;
    }

    private boolean spaceIsOccupied() {
        for (SimplyCatEntity catCheck : this.cat.m_9236_().m_45976_(SimplyCatEntity.class, new AABB(this.goalPos).m_82400_(2.0))) {
            if (catCheck == this.cat || !catCheck.isResting()) continue;
            return true;
        }
        return false;
    }

    public boolean m_8045_() {
        return this.cat.m_21824_() && !this.cat.m_21827_() && this.owner != null && this.owner.m_5803_() && this.goalPos != null && !this.spaceIsOccupied();
    }

    public void m_8056_() {
        if (this.goalPos != null) {
            this.cat.m_21837_(false);
            this.cat.m_21573_().m_26519_((double)this.goalPos.m_123341_(), (double)this.goalPos.m_123342_(), (double)this.goalPos.m_123343_(), (double)1.1f);
        }
    }

    public void m_8041_() {
        this.cat.setRestingState(SimplyCatEntity.RestingState.AWAKE.ordinal());
        float timeOfDay = this.cat.m_9236_().m_46942_(1.0f);
        if (this.owner.m_36318_() >= 100 && (double)timeOfDay > 0.77 && (double)timeOfDay < 0.8 && (double)this.cat.m_9236_().m_213780_().m_188501_() < 0.7) {
            this.giveMorningGift();
        }
        this.onBedTicks = 0;
        this.cat.m_21573_().m_26573_();
    }

    private void giveMorningGift() {
        RandomSource random = this.cat.m_217043_();
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        mutableBlockPos.m_122190_((Vec3i)(this.cat.m_21523_() ? this.cat.m_21524_().m_20183_() : this.cat.m_20183_()));
        this.cat.m_20984_(mutableBlockPos.m_123341_() + random.m_188503_(11) - 5, mutableBlockPos.m_123342_() + random.m_188503_(5) - 2, mutableBlockPos.m_123343_() + random.m_188503_(11) - 5, false);
        mutableBlockPos.m_122190_((Vec3i)this.cat.m_20183_());
        LootTable lootTable = this.cat.m_9236_().m_7654_().m_278653_().m_278676_(BuiltInLootTables.f_78724_);
        LootParams lootParams = new LootParams.Builder((ServerLevel)this.cat.m_9236_()).m_287286_(LootContextParams.f_81460_, (Object)this.cat.m_20182_()).m_287286_(LootContextParams.f_81455_, (Object)this.cat).m_287235_(LootContextParamSets.f_81416_);
        for (ItemStack itemStack : lootTable.m_287195_(lootParams)) {
            this.cat.m_9236_().m_7967_((Entity)new ItemEntity(this.cat.m_9236_(), (double)mutableBlockPos.m_123341_() - (double)Mth.m_14031_((float)(this.cat.f_20883_ * ((float)Math.PI / 180))), (double)mutableBlockPos.m_123342_(), (double)mutableBlockPos.m_123343_() + (double)Mth.m_14089_((float)(this.cat.f_20883_ * ((float)Math.PI / 180))), itemStack));
        }
    }

    public void m_8037_() {
        if (this.owner != null && this.goalPos != null) {
            this.cat.m_21837_(false);
            this.cat.m_21573_().m_26519_((double)this.goalPos.m_123341_(), (double)this.goalPos.m_123342_(), (double)this.goalPos.m_123343_(), (double)1.1f);
            if (this.cat.m_20280_((Entity)this.owner) < 2.5) {
                ++this.onBedTicks;
                if (this.onBedTicks > this.m_183277_(16) && !this.cat.isResting()) {
                    this.cat.setRestingState(this.cat.m_217043_().m_188503_(3) + 1);
                } else {
                    this.cat.m_21391_((Entity)this.owner, 45.0f, 45.0f);
                }
            } else {
                this.cat.setRestingState(SimplyCatEntity.RestingState.AWAKE.ordinal());
            }
        }
    }
}

