/*
 * Decompiled with CFR 0.152.
 */
package com.github.mnesikos.simplycats.item;

import com.github.mnesikos.simplycats.SimplyCats;
import com.github.mnesikos.simplycats.entity.SimplyCatEntity;
import com.github.mnesikos.simplycats.entity.core.Genetics;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PetCarrierItem
extends Item {
    public PetCarrierItem() {
        super(new Item.Properties().m_41487_(1));
    }

    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        if ((target instanceof SimplyCatEntity || target instanceof Cat || target instanceof Wolf || target instanceof Parrot) && (((TamableAnimal)target).m_269323_() == player || !((TamableAnimal)target).m_21824_() || player.m_20310_(2))) {
            if (stack.m_41782_()) {
                player.m_5661_((Component)Component.m_237115_((String)"chat.pet_carrier.full"), true);
                return InteractionResult.PASS;
            }
            target.revive();
            if (player.m_9236_().f_46443_) {
                return InteractionResult.SUCCESS;
            }
            CompoundTag tags = new CompoundTag();
            target.m_20223_(tags);
            ResourceLocation key = EntityType.m_20613_((EntityType)target.m_6095_());
            tags.m_128359_("id", key.toString());
            if (!(target instanceof SimplyCatEntity) && ((TamableAnimal)target).m_21830_((LivingEntity)player)) {
                tags.m_128359_("OwnerName", player.m_7755_().getString());
            }
            if (target.m_8077_()) {
                tags.m_128359_("DisplayName", target.m_5446_().getString());
            }
            target.m_146870_();
            player.m_5661_((Component)Component.m_237115_((String)"chat.pet_carrier.retrieve_pet"), true);
            ItemStack newStack = new ItemStack((ItemLike)this);
            newStack.m_41751_(tags);
            if (target instanceof SimplyCatEntity) {
                newStack.m_41721_(1);
            } else {
                newStack.m_41721_(2);
            }
            player.m_21008_(hand, newStack);
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        Level world = context.m_43725_();
        ItemStack item = context.m_43722_();
        if (!item.m_41782_() || item.m_41773_() == 0) {
            player.m_5661_((Component)Component.m_237115_((String)"chat.pet_carrier.empty"), true);
            return InteractionResult.PASS;
        }
        if (!world.f_46443_) {
            BlockPos blockPos = new BlockPos((Vec3i)context.m_8083_()).m_121945_(context.m_43719_());
            if (item.m_41773_() >= 3 && item.m_41773_() <= 6) {
                this.newPet(item, player, world, blockPos);
                if (!player.m_7500_()) {
                    item.m_41774_(1);
                }
            } else {
                Entity entity;
                CompoundTag tags = item.m_41783_();
                if ((item.m_41773_() == 1 || item.m_41773_() == 2) && (entity = EntityType.m_20645_((CompoundTag)tags, (Level)world, entity1 -> entity1)) != null && entity instanceof TamableAnimal) {
                    entity.m_19890_((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_(), (double)blockPos.m_123343_() + 0.5, context.m_7074_(), 0.0f);
                    if (((TamableAnimal)entity).m_21824_()) {
                        ((TamableAnimal)entity).m_21839_(true);
                    }
                    entity.m_20084_(tags.m_128342_("UUID"));
                    world.m_7967_(entity);
                    item.m_41774_(1);
                    player.m_21008_(context.m_43724_(), new ItemStack((ItemLike)this));
                    player.m_5661_((Component)Component.m_237115_((String)"chat.pet_carrier.release_pet"), true);
                }
            }
        }
        return InteractionResult.SUCCESS;
    }

    private void newPet(ItemStack item, Player player, Level world, BlockPos blockPos) {
        Rabbit rabbit;
        TamableAnimal pet = null;
        if (item.m_41773_() == 3) {
            pet = (TamableAnimal)((EntityType)SimplyCats.CAT.get()).m_20592_((ServerLevel)world, null, player, blockPos, MobSpawnType.SPAWN_EGG, false, false);
        } else if (item.m_41773_() == 4) {
            pet = (TamableAnimal)EntityType.f_20499_.m_20592_((ServerLevel)world, null, player, blockPos, MobSpawnType.SPAWN_EGG, false, false);
        } else if (item.m_41773_() == 5) {
            pet = (TamableAnimal)EntityType.f_20508_.m_20592_((ServerLevel)world, null, player, blockPos, MobSpawnType.SPAWN_EGG, false, false);
        }
        if (pet instanceof SimplyCatEntity && !((SimplyCatEntity)pet).canBeTamed(player)) {
            player.m_5661_((Component)Component.m_237115_((String)"chat.info.tamed_limit_reached"), true);
        } else if (pet != null) {
            pet.m_21839_(true);
            if (pet instanceof SimplyCatEntity) {
                ((SimplyCatEntity)pet).setTamed(true, player);
            } else {
                pet.m_21828_(player);
            }
            if (pet instanceof SimplyCatEntity) {
                ((SimplyCatEntity)pet).setHomePos(blockPos);
                player.m_5661_((Component)Component.m_237110_((String)"chat.info.set_home", (Object[])new Object[]{pet.m_7755_(), blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_()}), true);
            }
            pet.m_21573_().m_26573_();
            float health = pet.m_21233_();
            pet.m_21153_(health);
        } else if (item.m_41773_() == 6 && (rabbit = (Rabbit)EntityType.f_20517_.m_20592_((ServerLevel)world, null, player, blockPos, MobSpawnType.SPAWN_EGG, false, false)) != null) {
            rabbit.m_21573_().m_26573_();
            rabbit.m_21153_(rabbit.m_21233_());
        }
    }

    public Component m_7626_(ItemStack item) {
        Object unlocalizedName = super.m_7626_(item).getString();
        unlocalizedName = !item.m_41782_() || item.m_41773_() == 0 ? (String)unlocalizedName + "_empty" : (String)unlocalizedName + "_full";
        return Component.m_237115_((String)unlocalizedName);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack item, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        CompoundTag nbt = item.m_41783_();
        if (nbt != null) {
            if (item.m_41773_() == 3) {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.pet_carrier.adopt_cat").m_130940_(ChatFormatting.ITALIC));
            } else if (item.m_41773_() == 4) {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.pet_carrier.adopt_dog").m_130940_(ChatFormatting.ITALIC));
            } else if (item.m_41773_() == 5) {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.pet_carrier.adopt_parrot").m_130940_(ChatFormatting.ITALIC));
            } else if (item.m_41773_() == 6) {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.pet_carrier.adopt_rabbit").m_130940_(ChatFormatting.ITALIC));
            } else if (item.m_41773_() != 0) {
                MutableComponent species = Component.m_237115_((String)Util.m_137492_((String)"entity", (ResourceLocation)new ResourceLocation(nbt.m_128461_("id"))));
                if (nbt.m_128441_("DisplayName")) {
                    tooltip.add((Component)Component.m_237113_((String)("\"" + nbt.m_128461_("DisplayName") + "\"")).m_130940_(ChatFormatting.AQUA));
                } else {
                    tooltip.add((Component)species.m_130940_(ChatFormatting.AQUA));
                }
                if (item.m_41773_() == 1) {
                    tooltip.add((Component)Genetics.getPhenotypeDescription(nbt, true).m_130940_(ChatFormatting.ITALIC));
                }
                if (nbt.m_128441_("OwnerName") && !nbt.m_128461_("OwnerName").isEmpty()) {
                    tooltip.add((Component)Component.m_237110_((String)"tooltip.pet_carrier.owner", (Object[])new Object[]{nbt.m_128461_("OwnerName")}));
                }
            }
        } else {
            MutableComponent empty = Component.m_237115_((String)"tooltip.pet_carrier.empty");
            tooltip.add((Component)empty.m_130940_(ChatFormatting.AQUA));
        }
    }
}

