/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.crank;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.simibubi.create.content.kinetics.crank.HandCrankBlock;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class HandCrankBlockEntity
extends GeneratingKineticBlockEntity {
    public int inUse;
    public boolean backwards;
    public float independentAngle;
    public float chasingVelocity;

    public HandCrankBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void turn(boolean back) {
        boolean update = false;
        if (this.getGeneratedSpeed() == 0.0f || back != this.backwards) {
            update = true;
        }
        this.inUse = 10;
        this.backwards = back;
        if (update && !this.f_58857_.f_46443_) {
            this.updateGeneratedRotation();
        }
    }

    public float getIndependentAngle(float partialTicks) {
        return (this.independentAngle + partialTicks * this.chasingVelocity) / 360.0f;
    }

    @Override
    public float getGeneratedSpeed() {
        Block block = this.m_58900_().m_60734_();
        if (!(block instanceof HandCrankBlock)) {
            return 0.0f;
        }
        HandCrankBlock crank = (HandCrankBlock)block;
        int speed = (this.inUse == 0 ? 0 : (this.clockwise() ? -1 : 1)) * crank.getRotationSpeed();
        return HandCrankBlockEntity.convertToDirection(speed, (Direction)this.m_58900_().m_61143_((Property)HandCrankBlock.FACING));
    }

    protected boolean clockwise() {
        return this.backwards;
    }

    @Override
    public void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128405_("InUse", this.inUse);
        compound.m_128379_("Backwards", this.backwards);
        super.write(compound, clientPacket);
    }

    @Override
    protected void read(CompoundTag compound, boolean clientPacket) {
        this.inUse = compound.m_128451_("InUse");
        this.backwards = compound.m_128471_("Backwards");
        super.read(compound, clientPacket);
    }

    @Override
    public void tick() {
        super.tick();
        float actualSpeed = this.getSpeed();
        this.chasingVelocity += (actualSpeed * 10.0f / 3.0f - this.chasingVelocity) * 0.25f;
        this.independentAngle += this.chasingVelocity;
        if (this.inUse > 0) {
            --this.inUse;
            if (this.inUse == 0 && !this.f_58857_.f_46443_) {
                this.sequenceContext = null;
                this.updateGeneratedRotation();
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public SuperByteBuffer getRenderedHandle() {
        BlockState blockState = this.m_58900_();
        Direction facing = blockState.m_61145_((Property)HandCrankBlock.FACING).orElse(Direction.UP);
        return CachedBuffers.partialFacing((PartialModel)AllPartialModels.HAND_CRANK_HANDLE, (BlockState)blockState, (Direction)facing.m_122424_());
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldRenderShaft() {
        return true;
    }

    @Override
    protected Block getStressConfigKey() {
        return AllBlocks.HAND_CRANK.has(this.m_58900_()) ? (Block)AllBlocks.HAND_CRANK.get() : (Block)AllBlocks.COPPER_VALVE_HANDLE.get();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void tickAudio() {
        super.tickAudio();
        if (this.inUse > 0 && AnimationTickHolder.getTicks() % 10 == 0) {
            if (!AllBlocks.HAND_CRANK.has(this.m_58900_())) {
                return;
            }
            AllSoundEvents.CRANKING.playAt(this.f_58857_, (Vec3i)this.f_58858_, (float)this.inUse / 2.5f, 0.65f + (float)(10 - this.inUse) / 10.0f, true);
        }
    }
}

