/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.funnel;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllShapes;
import com.simibubi.create.api.schematic.requirement.SpecialBlockItemRequirement;
import com.simibubi.create.content.kinetics.belt.BeltBlock;
import com.simibubi.create.content.kinetics.belt.BeltSlope;
import com.simibubi.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.simibubi.create.content.logistics.funnel.AbstractHorizontalFunnelBlock;
import com.simibubi.create.content.logistics.funnel.FunnelBlock;
import com.simibubi.create.content.schematics.requirement.ItemRequirement;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.tterrag.registrate.util.entry.BlockEntry;
import net.createmod.catnip.lang.Lang;
import net.createmod.catnip.math.VoxelShaper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BeltFunnelBlock
extends AbstractHorizontalFunnelBlock
implements SpecialBlockItemRequirement {
    private BlockEntry<? extends FunnelBlock> parent;
    public static final EnumProperty<Shape> SHAPE = EnumProperty.m_61587_((String)"shape", Shape.class);

    public BeltFunnelBlock(BlockEntry<? extends FunnelBlock> parent, BlockBehaviour.Properties p_i48377_1_) {
        super(p_i48377_1_);
        this.parent = parent;
        this.m_49959_((BlockState)this.m_49966_().m_61124_(SHAPE, (Comparable)((Object)Shape.RETRACTED)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_206840_1_) {
        super.m_7926_((StateDefinition.Builder<Block, BlockState>)p_206840_1_.m_61104_(new Property[]{SHAPE}));
    }

    public boolean isOfSameType(FunnelBlock otherFunnel) {
        return this.parent.get() == otherFunnel;
    }

    @Override
    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        FunnelBlock fb;
        Block block = newState.m_60734_();
        if (block instanceof FunnelBlock && this.isOfSameType(fb = (FunnelBlock)block)) {
            return;
        }
        super.m_6810_(state, world, pos, newState, isMoving);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter p_220053_2_, BlockPos p_220053_3_, CollisionContext p_220053_4_) {
        return ((Shape)((Object)state.m_61143_(BeltFunnelBlock.SHAPE))).shaper.get((Direction)state.m_61143_((Property)HORIZONTAL_FACING));
    }

    public VoxelShape m_5939_(BlockState p_220071_1_, BlockGetter p_220071_2_, BlockPos p_220071_3_, CollisionContext p_220071_4_) {
        if (p_220071_4_ instanceof EntityCollisionContext && ((EntityCollisionContext)p_220071_4_).m_193113_() instanceof ItemEntity && (p_220071_1_.m_61143_(SHAPE) == Shape.PULLING || p_220071_1_.m_61143_(SHAPE) == Shape.PUSHING)) {
            return AllShapes.FUNNEL_COLLISION.get(this.getFacing(p_220071_1_));
        }
        return this.m_5940_(p_220071_1_, p_220071_2_, p_220071_3_, p_220071_4_);
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockState stateForPlacement = super.m_5573_(ctx);
        BlockPos pos = ctx.m_8083_();
        Level world = ctx.m_43725_();
        Direction facing = ctx.m_43719_().m_122434_().m_122479_() ? ctx.m_43719_() : ctx.m_8125_();
        BlockState state = (BlockState)stateForPlacement.m_61124_((Property)HORIZONTAL_FACING, (Comparable)facing);
        boolean sneaking = ctx.m_43723_() != null && ctx.m_43723_().m_6144_();
        return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)BeltFunnelBlock.getShapeForPosition((BlockGetter)world, pos, facing, !sneaking)));
    }

    public static Shape getShapeForPosition(BlockGetter world, BlockPos pos, Direction facing, boolean extracting) {
        Shape perpendicularState;
        BlockPos posBelow = pos.m_7495_();
        BlockState stateBelow = world.m_8055_(posBelow);
        Shape shape = perpendicularState = extracting ? Shape.PUSHING : Shape.PULLING;
        if (!AllBlocks.BELT.has(stateBelow)) {
            return perpendicularState;
        }
        Direction movementFacing = (Direction)stateBelow.m_61143_(BeltBlock.HORIZONTAL_FACING);
        return movementFacing.m_122434_() != facing.m_122434_() ? perpendicularState : Shape.RETRACTED;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        return this.parent.asStack();
    }

    @Override
    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighbour, LevelAccessor world, BlockPos pos, BlockPos p_196271_6_) {
        Shape currentShape;
        this.updateWater(world, state, pos);
        if (!BeltFunnelBlock.isOnValidBelt(state, (LevelReader)world, pos)) {
            BlockState parentState = ProperWaterloggedBlock.withWater(world, this.parent.getDefaultState(), pos);
            if (state.m_61145_((Property)POWERED).orElse(false).booleanValue()) {
                parentState = (BlockState)parentState.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(true));
            }
            if (state.m_61143_(SHAPE) == Shape.PUSHING) {
                parentState = (BlockState)parentState.m_61124_((Property)FunnelBlock.EXTRACTING, (Comparable)Boolean.valueOf(true));
            }
            return (BlockState)parentState.m_61124_((Property)FunnelBlock.FACING, (Comparable)((Direction)state.m_61143_((Property)HORIZONTAL_FACING)));
        }
        Shape updatedShape = BeltFunnelBlock.getShapeForPosition((BlockGetter)world, pos, (Direction)state.m_61143_((Property)HORIZONTAL_FACING), state.m_61143_(SHAPE) == Shape.PUSHING);
        if (updatedShape == (currentShape = (Shape)((Object)state.m_61143_(SHAPE)))) {
            return state;
        }
        if (updatedShape == Shape.PUSHING && currentShape == Shape.PULLING) {
            return state;
        }
        if (updatedShape == Shape.RETRACTED && currentShape == Shape.EXTENDED) {
            return state;
        }
        return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)updatedShape));
    }

    public static boolean isOnValidBelt(BlockState state, LevelReader world, BlockPos pos) {
        BlockState stateBelow = world.m_8055_(pos.m_7495_());
        if (stateBelow.m_60734_() instanceof BeltBlock) {
            return BeltBlock.canTransportObjects(stateBelow);
        }
        DirectBeltInputBehaviour directBeltInputBehaviour = BlockEntityBehaviour.get((BlockGetter)world, pos.m_7495_(), DirectBeltInputBehaviour.TYPE);
        if (directBeltInputBehaviour == null) {
            return false;
        }
        return directBeltInputBehaviour.canSupportBeltFunnels();
    }

    @Override
    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        Shape shape;
        Level world = context.m_43725_();
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        Shape newShape = shape = (Shape)((Object)state.m_61143_(SHAPE));
        if (shape == Shape.PULLING) {
            newShape = Shape.PUSHING;
        } else if (shape == Shape.PUSHING) {
            newShape = Shape.PULLING;
        } else if (shape == Shape.EXTENDED) {
            newShape = Shape.RETRACTED;
        } else if (shape == Shape.RETRACTED) {
            BlockState belt = world.m_8055_(context.m_8083_().m_7495_());
            newShape = belt.m_60734_() instanceof BeltBlock && belt.m_61143_(BeltBlock.SLOPE) != BeltSlope.HORIZONTAL ? Shape.RETRACTED : Shape.EXTENDED;
        }
        if (newShape == shape) {
            return InteractionResult.SUCCESS;
        }
        world.m_46597_(context.m_8083_(), (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)newShape)));
        if (newShape == Shape.EXTENDED) {
            Direction facing = (Direction)state.m_61143_((Property)HORIZONTAL_FACING);
            BlockState opposite = world.m_8055_(context.m_8083_().m_121945_(facing));
            if (opposite.m_60734_() instanceof BeltFunnelBlock && opposite.m_61143_(SHAPE) == Shape.EXTENDED && opposite.m_61143_((Property)HORIZONTAL_FACING) == facing.m_122424_()) {
                AllAdvancements.FUNNEL_KISS.awardTo(context.m_43723_());
            }
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public ItemRequirement getRequiredItems(BlockState state, BlockEntity be) {
        return new ItemRequirement(ItemRequirement.ItemUseType.CONSUME, this.parent.m_5456_());
    }

    public static enum Shape implements StringRepresentable
    {
        RETRACTED(AllShapes.BELT_FUNNEL_RETRACTED),
        EXTENDED(AllShapes.BELT_FUNNEL_EXTENDED),
        PUSHING(AllShapes.BELT_FUNNEL_PERPENDICULAR),
        PULLING(AllShapes.BELT_FUNNEL_PERPENDICULAR);

        VoxelShaper shaper;

        private Shape(VoxelShaper shaper) {
            this.shaper = shaper;
        }

        public String m_7912_() {
            return Lang.asId((String)this.name());
        }
    }
}

