/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.collision;

import com.simibubi.create.foundation.collision.Matrix3d;
import com.simibubi.create.foundation.collision.OBBCollider;
import net.minecraft.world.phys.Vec3;

public class ContinuousOBBCollider
extends OBBCollider {
    public static ContinuousSeparationManifold separateBBs(Vec3 cA, Vec3 cB, Vec3 eA, Vec3 eB, Matrix3d m, Vec3 motion) {
        ContinuousSeparationManifold mf = new ContinuousSeparationManifold();
        Vec3 diff = cB.m_82546_(cA);
        m.transpose();
        Vec3 diff2 = m.transform(diff);
        Vec3 motion2 = m.transform(motion);
        m.transpose();
        double a00 = Math.abs(m.m00);
        double a01 = Math.abs(m.m01);
        double a02 = Math.abs(m.m02);
        double a10 = Math.abs(m.m10);
        double a11 = Math.abs(m.m11);
        double a12 = Math.abs(m.m12);
        double a20 = Math.abs(m.m20);
        double a21 = Math.abs(m.m21);
        double a22 = Math.abs(m.m22);
        Vec3 uB0 = new Vec3(m.m00, m.m10, m.m20);
        Vec3 uB1 = new Vec3(m.m01, m.m11, m.m21);
        Vec3 uB2 = new Vec3(m.m02, m.m12, m.m22);
        checkCount = 0;
        mf.stepSeparationAxis = uB1;
        mf.stepSeparation = Double.MAX_VALUE;
        mf.normalSeparation = Double.MAX_VALUE;
        if (!(ContinuousOBBCollider.separate(mf, uA0, diff.f_82479_, eA.f_82479_, a00 * eB.f_82479_ + a01 * eB.f_82480_ + a02 * eB.f_82481_, motion.f_82479_, true) || ContinuousOBBCollider.separate(mf, uA1, diff.f_82480_, eA.f_82480_, a10 * eB.f_82479_ + a11 * eB.f_82480_ + a12 * eB.f_82481_, motion.f_82480_, true) || ContinuousOBBCollider.separate(mf, uA2, diff.f_82481_, eA.f_82481_, a20 * eB.f_82479_ + a21 * eB.f_82480_ + a22 * eB.f_82481_, motion.f_82481_, true) || ContinuousOBBCollider.separate(mf, uB0, diff2.f_82479_, eA.f_82479_ * a00 + eA.f_82480_ * a10 + eA.f_82481_ * a20, eB.f_82479_, motion2.f_82479_, false) || ContinuousOBBCollider.separate(mf, uB1, diff2.f_82480_, eA.f_82479_ * a01 + eA.f_82480_ * a11 + eA.f_82481_ * a21, eB.f_82480_, motion2.f_82480_, false) || ContinuousOBBCollider.separate(mf, uB2, diff2.f_82481_, eA.f_82479_ * a02 + eA.f_82480_ * a12 + eA.f_82481_ * a22, eB.f_82481_, motion2.f_82481_, false))) {
            return mf;
        }
        return null;
    }

    static boolean separate(ContinuousSeparationManifold mf, Vec3 axis, double TL, double rA, double rB, double projectedMotion, boolean axisOfObjA) {
        double dot;
        boolean isBestSeperation;
        boolean discreteCollision;
        ++checkCount;
        double distance = Math.abs(TL);
        double diff = distance - (rA + rB);
        boolean bl = discreteCollision = diff <= 0.0;
        if (!discreteCollision && Math.signum(projectedMotion) == Math.signum(TL)) {
            return true;
        }
        double sTL = Math.signum(TL);
        double seperation = sTL * Math.abs(diff);
        double entryTime = 0.0;
        double exitTime = Double.MAX_VALUE;
        if (!discreteCollision) {
            mf.isDiscreteCollision = false;
            if (Math.abs(seperation) > Math.abs(projectedMotion)) {
                return true;
            }
            entryTime = Math.abs(seperation) / Math.abs(projectedMotion);
            exitTime = (diff + Math.abs(rA) + Math.abs(rB)) / Math.abs(projectedMotion);
            mf.latestCollisionEntryTime = Math.max(entryTime, mf.latestCollisionEntryTime);
            mf.earliestCollisionExitTime = Math.min(exitTime, mf.earliestCollisionExitTime);
        }
        Vec3 normalizedAxis = axis.m_82541_();
        boolean bl2 = isBestSeperation = distance != 0.0 && -diff <= Math.abs(mf.separation);
        if (axisOfObjA && distance != 0.0 && -diff <= Math.abs(mf.normalSeparation)) {
            mf.normalAxis = normalizedAxis;
            mf.normalSeparation = seperation;
        }
        if ((dot = mf.stepSeparationAxis.m_82526_(axis)) != 0.0 && discreteCollision) {
            Vec3 cross = axis.m_82537_(mf.stepSeparationAxis);
            double dotSeparation = Math.signum(dot) * TL - (rA + rB);
            double stepSeparation = -dotSeparation;
            Vec3 stepSeparationVec = axis;
            if (!cross.equals((Object)Vec3.f_82478_)) {
                Vec3 sepVec = normalizedAxis.m_82490_(dotSeparation);
                Vec3 axisPlane = axis.m_82537_(cross);
                Vec3 stepPlane = mf.stepSeparationAxis.m_82537_(cross);
                stepSeparationVec = sepVec.m_82546_(axisPlane.m_82490_(sepVec.m_82526_(stepPlane) / axisPlane.m_82526_(stepPlane)));
                stepSeparation = stepSeparationVec.m_82553_();
                if (Math.abs(mf.stepSeparation) > Math.abs(stepSeparation) && stepSeparation != 0.0) {
                    mf.stepSeparation = stepSeparation;
                }
            } else if (Math.abs(mf.stepSeparation) > stepSeparation) {
                mf.stepSeparation = stepSeparation;
            }
        }
        if (isBestSeperation) {
            mf.axis = normalizedAxis;
            mf.separation = seperation;
            mf.collisionPosition = normalizedAxis.m_82490_(Math.signum(TL) * (axisOfObjA ? -rB : -rB) - Math.signum(seperation) * 0.125);
        }
        return false;
    }

    public static class ContinuousSeparationManifold
    extends OBBCollider.SeparationManifold {
        static final double UNDEFINED = -1.0;
        double latestCollisionEntryTime = -1.0;
        double earliestCollisionExitTime = Double.MAX_VALUE;
        boolean isDiscreteCollision = true;
        Vec3 collisionPosition;
        Vec3 stepSeparationAxis;
        double stepSeparation;
        Vec3 normalAxis;
        double normalSeparation;

        public double getTimeOfImpact() {
            if (this.latestCollisionEntryTime == -1.0) {
                return -1.0;
            }
            if (this.latestCollisionEntryTime > this.earliestCollisionExitTime) {
                return -1.0;
            }
            return this.latestCollisionEntryTime;
        }

        public boolean isSurfaceCollision() {
            return true;
        }

        public Vec3 getCollisionNormal() {
            return this.normalAxis == null ? null : this.createSeparationVec(this.normalSeparation, this.normalAxis);
        }

        public Vec3 getCollisionPosition() {
            return this.collisionPosition;
        }

        public Vec3 asSeparationVec(double obbStepHeight) {
            if (this.isDiscreteCollision) {
                if (this.stepSeparation <= obbStepHeight) {
                    return this.createSeparationVec(this.stepSeparation, this.stepSeparationAxis);
                }
                return super.asSeparationVec();
            }
            double t = this.getTimeOfImpact();
            if (t == -1.0) {
                return null;
            }
            return Vec3.f_82478_;
        }

        @Override
        public Vec3 asSeparationVec() {
            return this.asSeparationVec(0.0);
        }
    }
}

