/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.infrastructure.gametest.tests;

import com.simibubi.create.AllBlockEntityTypes;
import com.simibubi.create.content.fluids.hosePulley.HosePulleyFluidHandler;
import com.simibubi.create.content.fluids.pipes.valve.FluidValveBlock;
import com.simibubi.create.content.kinetics.crank.ValveHandleBlockEntity;
import com.simibubi.create.content.kinetics.gauge.SpeedGaugeBlockEntity;
import com.simibubi.create.content.kinetics.gauge.StressGaugeBlockEntity;
import com.simibubi.create.content.kinetics.waterwheel.WaterWheelBlockEntity;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import com.simibubi.create.infrastructure.gametest.CreateGameTestHelper;
import com.simibubi.create.infrastructure.gametest.GameTestGroup;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestAssertException;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.RedstoneLampBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.mutable.MutableBoolean;

@GameTestGroup(path="fluids")
public class TestFluids {
    @GameTest(template="hose_pulley_transfer", timeoutTicks=400)
    public static void hosePulleyTransfer(CreateGameTestHelper helper) {
        BlockPos lever = new BlockPos(7, 7, 5);
        helper.m_177421_(lever);
        helper.m_177361_(() -> {
            helper.assertSecondsPassed(15);
            BlockPos filledLowerCorner = new BlockPos(2, 3, 2);
            BlockPos filledUpperCorner = new BlockPos(4, 5, 4);
            BlockPos.m_121940_((BlockPos)filledLowerCorner, (BlockPos)filledUpperCorner).forEach(pos -> helper.m_177208_(Blocks.f_49990_, (BlockPos)pos));
            BlockPos emptiedLowerCorner = new BlockPos(8, 3, 2);
            BlockPos emptiedUpperCorner = new BlockPos(10, 5, 4);
            BlockPos.m_121940_((BlockPos)emptiedLowerCorner, (BlockPos)emptiedUpperCorner).forEach(pos -> helper.m_177208_(Blocks.f_50016_, (BlockPos)pos));
            BlockPos pulleyPos = new BlockPos(4, 7, 3);
            IFluidHandler storage = helper.fluidStorageAt(pulleyPos);
            if (storage instanceof HosePulleyFluidHandler) {
                HosePulleyFluidHandler hose = (HosePulleyFluidHandler)storage;
                SmartFluidTank internalTank = hose.getInternalTank();
                if (!internalTank.drain(1, IFluidHandler.FluidAction.SIMULATE).isEmpty()) {
                    helper.m_177284_("Pulley not empty");
                }
            } else {
                helper.m_177284_("Not a pulley");
            }
        });
    }

    @GameTest(template="in_world_pumping_out")
    public static void inWorldPumpingOut(CreateGameTestHelper helper) {
        BlockPos lever = new BlockPos(4, 3, 3);
        BlockPos basin = new BlockPos(5, 2, 2);
        BlockPos output = new BlockPos(2, 2, 2);
        helper.m_177421_(lever);
        helper.m_177361_(() -> {
            helper.m_177208_(Blocks.f_49990_, output);
            helper.assertTankEmpty(basin);
        });
    }

    @GameTest(template="in_world_pumping_in")
    public static void inWorldPumpingIn(CreateGameTestHelper helper) {
        BlockPos lever = new BlockPos(4, 3, 3);
        BlockPos basin = new BlockPos(5, 2, 2);
        BlockPos water = new BlockPos(2, 2, 2);
        FluidStack expectedResult = new FluidStack((Fluid)Fluids.f_76193_, 1000);
        helper.m_177421_(lever);
        helper.m_177361_(() -> {
            helper.m_177208_(Blocks.f_50016_, water);
            helper.assertFluidPresent(expectedResult, basin);
        });
    }

    @GameTest(template="steam_engine")
    public static void steamEngine(CreateGameTestHelper helper) {
        BlockPos lever = new BlockPos(4, 3, 3);
        helper.m_177421_(lever);
        BlockPos stressometer = new BlockPos(5, 2, 5);
        BlockPos speedometer = new BlockPos(4, 2, 5);
        helper.m_177361_(() -> {
            StressGaugeBlockEntity stress = (StressGaugeBlockEntity)helper.getBlockEntity((BlockEntityType)AllBlockEntityTypes.STRESSOMETER.get(), stressometer);
            SpeedGaugeBlockEntity speed = (SpeedGaugeBlockEntity)helper.getBlockEntity((BlockEntityType)AllBlockEntityTypes.SPEEDOMETER.get(), speedometer);
            float capacity = stress.getNetworkCapacity();
            helper.assertCloseEnoughTo(capacity, 2048.0);
            float rotationSpeed = Mth.m_14154_((float)speed.getSpeed());
            helper.assertCloseEnoughTo(rotationSpeed, 16.0);
        });
    }

    @GameTest(template="3_pipe_combine", timeoutTicks=400)
    public static void threePipeCombine(CreateGameTestHelper helper) {
        BlockPos tank1Pos = new BlockPos(5, 2, 1);
        BlockPos tank2Pos = tank1Pos.m_122019_();
        BlockPos tank3Pos = tank2Pos.m_122019_();
        long initialContents = helper.getFluidInTanks(tank1Pos, tank2Pos, tank3Pos);
        BlockPos pumpPos = new BlockPos(2, 2, 2);
        helper.flipBlock(pumpPos);
        helper.m_177361_(() -> {
            helper.assertSecondsPassed(13);
            helper.assertTanksEmpty(tank1Pos, tank2Pos, tank3Pos);
            BlockPos outputTankPos = new BlockPos(1, 2, 2);
            long moved = helper.getFluidInTanks(outputTankPos);
            if (moved != initialContents) {
                helper.m_177284_("Wrong amount of fluid amount. expected [%s], got [%s]".formatted(initialContents, moved));
            }
        });
    }

    @GameTest(template="3_pipe_split", timeoutTicks=200)
    public static void threePipeSplit(CreateGameTestHelper helper) {
        BlockPos pumpPos = new BlockPos(2, 2, 2);
        BlockPos tank1Pos = new BlockPos(5, 2, 1);
        BlockPos tank2Pos = tank1Pos.m_122019_();
        BlockPos tank3Pos = tank2Pos.m_122019_();
        BlockPos outputTankPos = new BlockPos(1, 2, 2);
        long totalContents = helper.getFluidInTanks(tank1Pos, tank2Pos, tank3Pos, outputTankPos);
        helper.flipBlock(pumpPos);
        helper.m_177361_(() -> {
            long newTotalContents;
            helper.assertSecondsPassed(7);
            FluidStack contents = helper.getTankContents(outputTankPos);
            if (!contents.isEmpty()) {
                helper.m_177284_("Tank not empty: " + contents.getAmount());
            }
            if ((newTotalContents = helper.getFluidInTanks(tank1Pos, tank2Pos, tank3Pos)) != totalContents) {
                helper.m_177284_("Wrong total fluid amount. expected [%s], got [%s]".formatted(totalContents, newTotalContents));
            }
        });
    }

    @GameTest(template="large_waterwheel", timeoutTicks=200)
    public static void largeWaterwheel(CreateGameTestHelper helper) {
        BlockPos wheel = new BlockPos(4, 3, 2);
        BlockPos leftEnd = new BlockPos(6, 2, 2);
        BlockPos rightEnd = new BlockPos(2, 2, 2);
        List<BlockPos> edges = List.of(new BlockPos(4, 5, 1), new BlockPos(4, 5, 3));
        BlockPos openLever = new BlockPos(3, 8, 1);
        BlockPos leftLever = new BlockPos(5, 7, 1);
        TestFluids.waterwheel(helper, wheel, 4.0f, 512.0f, leftEnd, rightEnd, edges, openLever, leftLever);
    }

    @GameTest(template="small_waterwheel", timeoutTicks=200)
    public static void smallWaterwheel(CreateGameTestHelper helper) {
        BlockPos wheel = new BlockPos(3, 2, 2);
        BlockPos leftEnd = new BlockPos(4, 2, 2);
        BlockPos rightEnd = new BlockPos(2, 2, 2);
        List<BlockPos> edges = List.of(new BlockPos(3, 3, 1), new BlockPos(3, 3, 3));
        BlockPos openLever = new BlockPos(2, 6, 1);
        BlockPos leftLever = new BlockPos(4, 5, 1);
        TestFluids.waterwheel(helper, wheel, 8.0f, 256.0f, leftEnd, rightEnd, edges, openLever, leftLever);
    }

    private static void waterwheel(CreateGameTestHelper helper, BlockPos wheel, float expectedRpm, float expectedSU, BlockPos leftEnd, BlockPos rightEnd, List<BlockPos> edges, BlockPos openLever, BlockPos leftLever) {
        BlockPos speedometer = wheel.m_122012_();
        BlockPos stressometer = wheel.m_122019_();
        helper.m_177421_(openLever);
        helper.m_177361_(() -> {
            edges.forEach(pos -> helper.m_177341_(Blocks.f_49990_, (BlockPos)pos));
            helper.m_177208_(Blocks.f_49990_, rightEnd);
            if (!((Boolean)helper.m_177232_(leftLever).m_61143_((Property)LeverBlock.f_54622_)).booleanValue()) {
                helper.m_177208_(Blocks.f_49990_, leftEnd);
                helper.assertSpeedometerSpeed(speedometer, 0.0f);
                helper.assertStressometerCapacity(stressometer, 0.0f);
                helper.powerLever(leftLever);
                helper.m_177284_("Entering step 2");
            } else {
                helper.m_177341_(Blocks.f_49990_, leftEnd);
                helper.assertSpeedometerSpeed(speedometer, expectedRpm);
                helper.assertStressometerCapacity(stressometer, expectedSU);
            }
        });
    }

    @GameTest(template="waterwheel_materials", timeoutTicks=300)
    public static void waterwheelMaterials(CreateGameTestHelper helper) {
        List planks = ForgeRegistries.BLOCKS.tags().getTag(BlockTags.f_13090_).stream().map(ItemLike::m_5456_).collect(Collectors.toCollection(ArrayList::new));
        List<BlockPos> chests = List.of(new BlockPos(6, 4, 2), new BlockPos(6, 4, 3));
        List<BlockPos> deployers = chests.stream().map(pos -> pos.m_6625_(2)).toList();
        helper.m_177306_(3L, () -> chests.forEach(chest -> planks.forEach(plank -> ItemHandlerHelper.insertItem((IItemHandler)helper.itemStorageAt((BlockPos)chest), (ItemStack)new ItemStack((ItemLike)plank), (boolean)false))));
        BlockPos smallWheel = new BlockPos(4, 2, 2);
        BlockPos largeWheel = new BlockPos(3, 3, 3);
        BlockPos lever = new BlockPos(5, 3, 1);
        helper.m_177421_(lever);
        helper.m_177361_(() -> {
            Item plank = (Item)planks.get(0);
            if (!(plank instanceof BlockItem)) {
                throw new GameTestAssertException(String.valueOf(ForgeRegistries.ITEMS.getKey((Object)plank)) + " is not a BlockItem");
            }
            BlockItem blockItem = (BlockItem)plank;
            Block block = blockItem.m_40614_();
            WaterWheelBlockEntity smallWheelBe = (WaterWheelBlockEntity)helper.getBlockEntity((BlockEntityType)AllBlockEntityTypes.WATER_WHEEL.get(), smallWheel);
            if (!smallWheelBe.material.m_60713_(block)) {
                helper.m_177284_("Small waterwheel has not consumed " + String.valueOf(ForgeRegistries.ITEMS.getKey((Object)plank)));
            }
            WaterWheelBlockEntity largeWheelBe = (WaterWheelBlockEntity)helper.getBlockEntity((BlockEntityType)AllBlockEntityTypes.LARGE_WATER_WHEEL.get(), largeWheel);
            if (!largeWheelBe.material.m_60713_(block)) {
                helper.m_177284_("Large waterwheel has not consumed " + String.valueOf(ForgeRegistries.ITEMS.getKey((Object)plank)));
            }
            planks.remove(0);
            deployers.forEach(pos -> {
                IItemHandler handler = helper.itemStorageAt((BlockPos)pos);
                for (int i = 0; i < handler.getSlots(); ++i) {
                    handler.extractItem(i, Integer.MAX_VALUE, false);
                }
            });
            if (!planks.isEmpty()) {
                helper.m_177284_("Not all planks have been consumed");
            }
        });
    }

    @GameTest(template="smart_observer_pipes")
    public static void smartObserverPipes(CreateGameTestHelper helper) {
        BlockPos lever = new BlockPos(3, 3, 1);
        BlockPos output = new BlockPos(3, 4, 4);
        BlockPos tankOutput = new BlockPos(1, 2, 4);
        FluidStack expected = new FluidStack((Fluid)Fluids.f_76193_, 2000);
        helper.m_177421_(lever);
        helper.m_177361_(() -> {
            helper.assertFluidPresent(expected, tankOutput);
            helper.m_177208_(Blocks.f_50090_, output);
        });
    }

    @GameTest(template="threshold_switch", timeoutTicks=400)
    public static void thresholdSwitch(CreateGameTestHelper helper) {
        BlockPos leftHandle = new BlockPos(4, 2, 4);
        BlockPos leftValve = new BlockPos(4, 2, 3);
        BlockPos leftTank = new BlockPos(5, 2, 3);
        BlockPos rightHandle = new BlockPos(2, 2, 4);
        BlockPos rightValve = new BlockPos(2, 2, 3);
        BlockPos rightTank = new BlockPos(1, 2, 3);
        BlockPos drainHandle = new BlockPos(3, 3, 2);
        BlockPos drainValve = new BlockPos(3, 3, 1);
        BlockPos lamp = new BlockPos(1, 3, 1);
        BlockPos tank = new BlockPos(2, 2, 1);
        helper.m_177361_(() -> {
            if (!((Boolean)helper.m_177232_(leftValve).m_61143_((Property)FluidValveBlock.ENABLED)).booleanValue()) {
                ((ValveHandleBlockEntity)helper.getBlockEntity((BlockEntityType)AllBlockEntityTypes.VALVE_HANDLE.get(), leftHandle)).activate(false);
                helper.m_177284_("Entering step 2");
            } else if (!((Boolean)helper.m_177232_(rightValve).m_61143_((Property)FluidValveBlock.ENABLED)).booleanValue()) {
                helper.assertFluidPresent(FluidStack.EMPTY, leftTank);
                helper.m_177255_(lamp, (Property)RedstoneLampBlock.f_55654_, Boolean.valueOf(false));
                ((ValveHandleBlockEntity)helper.getBlockEntity((BlockEntityType)AllBlockEntityTypes.VALVE_HANDLE.get(), rightHandle)).activate(false);
                helper.m_177284_("Entering step 3");
            } else if (!((Boolean)helper.m_177232_(drainValve).m_61143_((Property)FluidValveBlock.ENABLED)).booleanValue()) {
                helper.assertFluidPresent(FluidStack.EMPTY, rightTank);
                helper.m_177255_(lamp, (Property)RedstoneLampBlock.f_55654_, Boolean.valueOf(true));
                ((ValveHandleBlockEntity)helper.getBlockEntity((BlockEntityType)AllBlockEntityTypes.VALVE_HANDLE.get(), drainHandle)).activate(false);
                helper.m_177284_("Entering step 4");
            } else {
                helper.assertTankEmpty(tank);
                helper.m_177255_(lamp, (Property)RedstoneLampBlock.f_55654_, Boolean.valueOf(false));
            }
        });
    }

    @GameTest(template="open_pipes")
    public static void openPipes(CreateGameTestHelper helper) {
        BlockPos effects = new BlockPos(2, 4, 2);
        BlockPos removers = new BlockPos(3, 5, 2);
        BlockPos firstSeat = new BlockPos(4, 2, 1);
        BlockPos secondSeat = firstSeat.m_122020_(2);
        Zombie firstZombie = (Zombie)helper.m_177176_(EntityType.f_20501_, firstSeat);
        Zombie secondZombie = (Zombie)helper.m_177176_(EntityType.f_20501_, secondSeat);
        helper.m_177421_(effects);
        MutableBoolean stage1 = new MutableBoolean(true);
        helper.m_177361_(() -> {
            if (stage1.booleanValue()) {
                helper.m_246336_(firstZombie.m_6060_(), "not ignited");
                helper.m_277053_(secondZombie.m_21220_().isEmpty(), "no effects");
                stage1.setFalse();
                helper.m_177421_(effects);
                helper.m_177421_(removers);
                helper.m_177284_("switching stages");
            } else {
                helper.m_277053_(firstZombie.m_6060_(), "not extinguished");
                helper.m_246336_(secondZombie.m_21220_().isEmpty(), "has effects");
            }
        });
    }

    @GameTest(template="spouting", timeoutTicks=200)
    public static void spouting(CreateGameTestHelper helper) {
        BlockPos farmland = new BlockPos(3, 2, 3);
        BlockPos depot = new BlockPos(5, 2, 1);
        helper.m_177302_(2, 3, 2);
        ItemStack waterBottle = PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43599_);
        helper.m_177361_(() -> {
            helper.m_177203_(Blocks.f_152477_, 3, 2, 1);
            helper.m_177255_(farmland, (Property)FarmBlock.f_53243_, Integer.valueOf(7));
            helper.m_177208_(Blocks.f_220864_, farmland.m_122030_(1));
            helper.m_177208_(Blocks.f_220864_, farmland.m_122030_(2));
            helper.m_177208_(Blocks.f_220864_, farmland.m_122030_(3));
            helper.m_177208_(Blocks.f_152476_, farmland.m_122030_(4));
            helper.m_177242_(depot, Items.f_42447_);
            helper.assertContainerContains(depot.m_122030_(1), waterBottle);
            helper.m_177242_(depot.m_122030_(2), Items.f_42276_);
        });
    }
}

