/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.botanicalmachinery.blocks.tesr;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import de.melanx.botanicalmachinery.blocks.tiles.BlockEntityMechanicalBrewery;
import de.melanx.botanicalmachinery.config.LibXClientConfig;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import org.joml.Quaternionf;
import org.moddingx.libx.render.RenderHelper;
import org.moddingx.libx.render.block.RotatedBlockRenderer;
import vazkii.botania.api.brew.BrewItem;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.common.item.BotaniaItems;

public class MechanicalBreweryRenderer
extends RotatedBlockRenderer<BlockEntityMechanicalBrewery> {
    public static final Map<Item, Integer> INGREDIENT_COLORS = ImmutableMap.builder().put((Object)Items.f_42588_, (Object)12468042).put((Object)Items.f_42696_, (Object)9553335).put((Object)Items.f_42525_, (Object)16759902).put((Object)Items.f_42436_, (Object)14393875).put((Object)Items.f_42620_, (Object)15317602).put((Object)Items.f_42501_, (Object)0xD5D5DF).put((Object)Items.f_42587_, (Object)0xF9F969).put((Object)Items.f_42416_, (Object)0xD8D8D8).put((Object)Items.f_42454_, (Object)12999733).put((Object)Items.f_42542_, (Object)13993248).put((Object)Items.f_42592_, (Object)6620715).put((Object)Items.f_42534_, (Object)3432131).put((Object)Items.f_42613_, (Object)15641624).put((Object)Items.f_42546_, (Object)13191432).put((Object)Items.f_42586_, (Object)10470339).put((Object)Items.f_42403_, (Object)0x727272).put((Object)Items.f_42583_, (Object)8602648).put((Object)Items.f_42500_, (Object)16579565).put((Object)Items.f_42401_, (Object)0xDBDBDB).put((Object)Items.f_42584_, (Object)3447176).put((Object)Items.f_42593_, (Object)0xFFE000).put((Object)BotaniaItems.manaSteel, (Object)27647).put((Object)Items.f_42591_, (Object)10296877).put((Object)Items.f_42677_, (Object)14393875).put((Object)Items.f_42516_, (Object)15330027).put((Object)Items.f_42410_, (Object)14489381).put((Object)Items.f_42402_, (Object)0x969696).put((Object)Items.f_42619_, (Object)16748041).put((Object)Items.f_42451_, (Object)15336448).put((Object)Items.f_42526_, (Object)13017713).put((Object)Items.f_42692_, (Object)14537926).put((Object)Items.f_42452_, (Object)0xFFFFFF).put((Object)Items.f_42616_, (Object)1564002).put((Object)Items.f_42575_, (Object)12529955).build();
    private final int waterColor = IClientFluidTypeExtensions.of((Fluid)Fluids.f_76193_).getTintColor();

    protected void doRender(@Nonnull BlockEntityMechanicalBrewery tile, float partialTick, @Nonnull PoseStack poseStack, @Nonnull MultiBufferSource buffer, int light, int overlay) {
        if (!LibXClientConfig.AdvancedRendering.all || !LibXClientConfig.AdvancedRendering.mechanicalBrewery) {
            return;
        }
        int slotToMove = -1;
        double travelCenter = 1.0;
        Quaternionf vialRotate = null;
        double vialDown = 0.0;
        boolean showOutput = false;
        if (tile.getProgress() > 0) {
            double progress = (double)tile.getProgress() / (double)tile.getMaxProgress();
            int segments = 3;
            for (int i = 1; i <= 6; ++i) {
                if (tile.getInventory().getStackInSlot(i).m_41619_()) continue;
                ++segments;
            }
            double segment = 1.0 / (double)segments;
            double segmentProgress = progress % segment * (double)segments;
            if (progress >= 1.0 - segment) {
                slotToMove = Integer.MAX_VALUE;
                double progressMinusHalf = segmentProgress - 0.5;
                vialDown = progressMinusHalf * progressMinusHalf - 0.25;
                vialRotate = Axis.f_252529_.m_252977_((float)(480.0 * vialDown));
                vialDown = 1.8 * vialDown;
                showOutput = progressMinusHalf >= 0.0;
                this.renderFluid(poseStack, buffer, partialTick, light, (float)(1.0 - segmentProgress), this.getTargetColor(tile));
            } else if (progress >= 1.0 - 2.0 * segment) {
                slotToMove = Integer.MAX_VALUE;
                int fromColor = this.waterColor;
                for (int i = 6; i >= 1; --i) {
                    if (tile.getInventory().getStackInSlot(i).m_41619_()) continue;
                    fromColor = this.getColor(tile.getInventory().getStackInSlot(i));
                    break;
                }
                this.renderFluid(poseStack, buffer, partialTick, light, 1.0f, fromColor, this.getTargetColor(tile), segmentProgress);
            } else if (progress < segment) {
                this.renderFluid(poseStack, buffer, partialTick, light, (float)segmentProgress, this.waterColor);
            } else {
                int idx = (int)((progress - segment) / segment);
                int fromColor = this.waterColor;
                int toColor = this.waterColor;
                for (int i = 1; i <= 6; ++i) {
                    if (tile.getInventory().getStackInSlot(i).m_41619_()) continue;
                    if (idx <= 0) {
                        slotToMove = i;
                        travelCenter = segmentProgress;
                        toColor = this.getColor(tile.getInventory().getStackInSlot(i));
                        break;
                    }
                    if (idx == 1) {
                        fromColor = this.getColor(tile.getInventory().getStackInSlot(i));
                    }
                    --idx;
                }
                this.renderFluid(poseStack, buffer, partialTick, light, 1.0f, fromColor, toColor, segmentProgress);
            }
        }
        ItemStack topStack = tile.getInventory().getStackInSlot(7);
        if (showOutput && !tile.getCurrentOutput().m_41619_()) {
            topStack = tile.getCurrentOutput();
        } else if (topStack.m_41619_() || tile.getProgress() > 0) {
            topStack = tile.getInventory().getStackInSlot(0);
        }
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.8 + vialDown, 0.5);
        poseStack.m_85841_(0.5f, 0.5f, 0.5f);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(((float)ClientTickHandler.ticksInGame + partialTick) / 1.3f));
        if (vialRotate != null) {
            poseStack.m_252781_(vialRotate);
        }
        Minecraft.m_91087_().m_91291_().m_269128_(topStack, ItemDisplayContext.GROUND, light, OverlayTexture.f_118083_, poseStack, buffer, tile.m_58904_(), (int)tile.m_58899_().m_121878_());
        poseStack.m_85849_();
        int itemAmount = 0;
        for (int i = 1; i <= 6; ++i) {
            if (tile.getInventory().getStackInSlot(i).m_41619_()) continue;
            ++itemAmount;
        }
        double angle = 360.0 / (double)itemAmount;
        float time = (float)ClientTickHandler.ticksInGame + partialTick;
        int idx = 0;
        for (int i = 1; i <= 6; ++i) {
            if (tile.getInventory().getStackInSlot(i).m_41619_()) continue;
            int idxNow = idx++;
            if (i < slotToMove) continue;
            poseStack.m_85836_();
            poseStack.m_85837_(0.5, 0.7, 0.5);
            poseStack.m_85841_(0.3f, 0.3f, 0.3f);
            poseStack.m_252781_(Axis.f_252436_.m_252977_((float)(-(angle * (double)idxNow + (double)time))));
            if (i == slotToMove) {
                poseStack.m_85837_((1.0 - travelCenter) * 1.125, travelCenter * -1.0, (1.0 - travelCenter) * 0.25);
                poseStack.m_252781_(Axis.f_252529_.m_252977_((float)(90.0 * travelCenter)));
            } else {
                poseStack.m_85837_(1.125, 0.0, 0.25);
            }
            poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
            poseStack.m_85837_(0.0, 0.075 * Math.sin((double)(time + (float)(idxNow * 10)) / 5.0), 0.0);
            Minecraft.m_91087_().m_91291_().m_269128_(tile.getInventory().getStackInSlot(i), ItemDisplayContext.GROUND, light, OverlayTexture.f_118083_, poseStack, buffer, tile.m_58904_(), (int)tile.m_58899_().m_121878_());
            poseStack.m_85849_();
        }
    }

    private int getColor(ItemStack stack) {
        if (stack.m_41619_()) {
            return this.waterColor;
        }
        if (INGREDIENT_COLORS.containsKey(stack.m_41720_())) {
            return INGREDIENT_COLORS.get(stack.m_41720_());
        }
        if (stack.m_41720_() instanceof DyeItem) {
            return ((DyeItem)stack.m_41720_()).m_41089_().m_41071_();
        }
        if (stack.m_41720_() instanceof BlockItem) {
            return ((BlockItem)stack.m_41720_()).m_40614_().m_284356_().f_283871_;
        }
        return this.waterColor;
    }

    private int getTargetColor(BlockEntityMechanicalBrewery tile) {
        Item item = tile.getCurrentOutput().m_41720_();
        if (item instanceof BrewItem) {
            BrewItem brewItem = (BrewItem)item;
            return brewItem.getBrew(tile.getCurrentOutput()).getColor(tile.getCurrentOutput());
        }
        return this.waterColor;
    }

    private void renderFluid(PoseStack poseStack, @Nonnull MultiBufferSource buffer, float partialTick, int light, float fillLevel, int colorFrom, int colorTo, double progress) {
        int fromRed = colorFrom >> 16 & 0xFF;
        int fromGreen = colorFrom >> 8 & 0xFF;
        int fromBlue = colorFrom & 0xFF;
        int toRed = colorTo >> 16 & 0xFF;
        int toGreen = colorTo >> 8 & 0xFF;
        int toBlue = colorTo & 0xFF;
        int red = (int)Math.round((double)fromRed + (double)(toRed - fromRed) * progress);
        int green = (int)Math.round((double)fromGreen + (double)(toGreen - fromGreen) * progress);
        int blue = (int)Math.round((double)fromBlue + (double)(toBlue - fromBlue) * progress);
        int color = red << 16 | green << 8 | blue;
        this.renderFluid(poseStack, buffer, partialTick, light, fillLevel, color);
    }

    private void renderFluid(PoseStack poseStack, @Nonnull MultiBufferSource buffer, float partialTick, int light, float fillLevel, int color) {
        poseStack.m_85836_();
        poseStack.m_85841_(0.0625f, 0.0625f, 0.0625f);
        poseStack.m_85837_(4.0, 3.0 + 4.4 * (double)fillLevel, 4.0);
        poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(IClientFluidTypeExtensions.of((Fluid)Fluids.f_76193_).getStillTexture());
        VertexConsumer vertex = buffer.m_6299_(Sheets.m_110792_());
        RenderHelper.renderIconColored((PoseStack)poseStack, (VertexConsumer)vertex, (float)0.0f, (float)0.0f, (TextureAtlasSprite)sprite, (float)8.0f, (float)8.0f, (float)1.0f, (int)color, (int)light, (int)OverlayTexture.f_118083_);
        poseStack.m_85849_();
    }
}

