/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.botanicalmachinery.network;

import de.melanx.botanicalmachinery.blocks.tiles.BlockEntityManaBattery;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import org.moddingx.libx.LibX;
import org.moddingx.libx.network.PacketHandler;
import org.moddingx.libx.network.PacketSerializer;

public record ManaBatteryLockedMessage(BlockPos pos, boolean locked1, boolean locked2) {

    public static class Serializer
    implements PacketSerializer<ManaBatteryLockedMessage> {
        public Class<ManaBatteryLockedMessage> messageClass() {
            return ManaBatteryLockedMessage.class;
        }

        public void encode(ManaBatteryLockedMessage msg, FriendlyByteBuf buffer) {
            buffer.m_130064_(msg.pos);
            buffer.writeBoolean(msg.locked1);
            buffer.writeBoolean(msg.locked2);
        }

        public ManaBatteryLockedMessage decode(FriendlyByteBuf buffer) {
            return new ManaBatteryLockedMessage(buffer.m_130135_(), buffer.readBoolean(), buffer.readBoolean());
        }
    }

    public static class Handler
    implements PacketHandler<ManaBatteryLockedMessage> {
        public PacketHandler.Target target() {
            return PacketHandler.Target.MAIN_THREAD;
        }

        public boolean handle(ManaBatteryLockedMessage msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                BlockEntity te;
                ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
                if (player == null) {
                    return;
                }
                ServerLevel level = (ServerLevel)player.m_9236_();
                if (level.m_46805_(msg.pos) && (te = level.m_7702_(msg.pos)) instanceof BlockEntityManaBattery) {
                    ((BlockEntityManaBattery)te).setSlot1Locked(msg.locked1);
                    ((BlockEntityManaBattery)te).setSlot2Locked(msg.locked2);
                    LibX.getNetwork().updateBE((Level)level, msg.pos);
                }
            });
            ctx.get().setPacketHandled(true);
            return true;
        }
    }
}

