/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block;

import com.lothrazar.cyclic.config.ClientConfigCyclic;
import com.lothrazar.cyclic.registry.BlockRegistry;
import com.lothrazar.library.block.EntityBlockFlib;
import com.lothrazar.library.util.SoundUtil;
import com.lothrazar.library.util.StringParseUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.NetworkHooks;

public class BlockCyclic
extends EntityBlockFlib {
    public static final BooleanProperty LIT = BooleanProperty.m_61465_((String)"lit");
    private boolean hasGui = false;
    private boolean hasFluidInteract = false;

    public BlockCyclic(BlockBehaviour.Properties properties) {
        super(properties);
        BlockRegistry.BLOCKSCLIENTREGISTRY.add(this);
    }

    public static boolean never(BlockState bs, BlockGetter bg, BlockPos pos) {
        return false;
    }

    protected BlockCyclic setHasGui() {
        this.hasGui = true;
        return this;
    }

    protected BlockCyclic setHasFluidInteract() {
        this.hasFluidInteract = true;
        return this;
    }

    public BlockEntity m_142194_(BlockPos p, BlockState st) {
        return null;
    }

    public BlockState rotate(BlockState state, LevelAccessor world, BlockPos pos, Rotation direction) {
        Direction oldDir;
        Direction newDir;
        if (state.m_61138_((Property)BlockStateProperties.f_61374_) && (newDir = direction.m_55954_(oldDir = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_))) != Direction.UP && newDir != Direction.DOWN) {
            return (BlockState)state.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)newDir);
        }
        if (state.m_61138_((Property)BlockStateProperties.f_61372_)) {
            oldDir = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
            newDir = direction.m_55954_(oldDir);
            return (BlockState)state.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)newDir);
        }
        BlockState newState = state.m_60717_(direction);
        return newState;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (this.hasFluidInteract) {
            IFluidHandler handler;
            BlockEntity tankHere;
            if (!world.f_46443_ && (tankHere = world.m_7702_(pos)) != null && (handler = (IFluidHandler)tankHere.getCapability(ForgeCapabilities.FLUID_HANDLER, hit.m_82434_()).orElse(null)) != null) {
                if (FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (IFluidHandler)handler)) {
                    if (player instanceof ServerPlayer) {
                        SoundUtil.playSoundFromServer((ServerPlayer)((ServerPlayer)player), (SoundEvent)SoundEvents.f_11781_, (float)1.0f, (float)1.0f);
                    }
                    if (handler.getFluidInTank(0) != null) {
                        this.displayClientFluidMessage(player, handler);
                    }
                } else {
                    this.displayClientFluidMessage(player, handler);
                }
            }
            if (FluidUtil.getFluidHandler((ItemStack)player.m_21120_(hand)).isPresent()) {
                return InteractionResult.SUCCESS;
            }
        }
        if (this.hasGui) {
            if (!world.f_46443_) {
                BlockEntity tileEntity = world.m_7702_(pos);
                if (tileEntity instanceof MenuProvider) {
                    NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)((MenuProvider)tileEntity), (BlockPos)tileEntity.m_58899_());
                } else {
                    throw new IllegalStateException("Our named container provider is missing!");
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, world, pos, player, hand, hit);
    }

    private void displayClientFluidMessage(Player player, IFluidHandler handler) {
        if (((Boolean)ClientConfigCyclic.FLUID_BLOCK_STATUS.get()).booleanValue()) {
            player.m_5661_((Component)Component.m_237115_((String)StringParseUtil.getFluidRatioName((IFluidHandler)handler)), true);
        }
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            IItemHandler items;
            BlockEntity tileentity = worldIn.m_7702_(pos);
            if (tileentity != null && (items = (IItemHandler)tileentity.getCapability(ForgeCapabilities.ITEM_HANDLER).orElse(null)) != null) {
                for (int i = 0; i < items.getSlots(); ++i) {
                    Containers.m_18992_((Level)worldIn, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)items.getStackInSlot(i));
                }
                worldIn.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, worldIn, pos, newState, isMoving);
        }
    }

    public void registerClient() {
    }

    public static boolean isItem(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        return BlockCyclic.hasCapabilityDir(facing, world, facingPos, ForgeCapabilities.ITEM_HANDLER);
    }

    public static boolean isFluid(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        return BlockCyclic.hasCapabilityDir(facing, world, facingPos, ForgeCapabilities.FLUID_HANDLER);
    }

    public static boolean isEnergy(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        return BlockCyclic.hasCapabilityDir(facing, world, facingPos, ForgeCapabilities.ENERGY);
    }

    private static boolean hasCapabilityDir(Direction facing, LevelAccessor world, BlockPos facingPos, Capability<?> cap) {
        if (facing == null) {
            return false;
        }
        BlockEntity neighbor = world.m_7702_(facingPos);
        return neighbor != null && neighbor.getCapability(cap, facing.m_122424_()).orElse(null) != null;
    }

    protected int calcRedstoneFromFluid(BlockEntity tileEntity) {
        IFluidHandler fluid = (IFluidHandler)tileEntity.getCapability(ForgeCapabilities.FLUID_HANDLER).orElse(null);
        if (fluid.getFluidInTank(0).isEmpty()) {
            return 0;
        }
        float cap = fluid.getTankCapacity(0);
        float amt = fluid.getFluidInTank(0).getAmount();
        float f = amt / cap;
        return (int)Math.floor(f * 14.0f) + 1;
    }
}

