/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block;

import com.lothrazar.cyclic.block.BlockCyclic;
import com.lothrazar.library.util.BlockstatesUtil;
import com.lothrazar.library.util.SoundUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class FireplaceBlock
extends BlockCyclic {
    public FireplaceBlock(BlockBehaviour.Properties properties) {
        super(properties.m_60978_(1.8f));
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        boolean isPowered = worldIn.m_276867_(pos);
        BlockPos posFire = pos.m_121945_((Direction)state.m_61143_((Property)BlockStateProperties.f_61372_));
        if (worldIn.m_8055_(posFire).m_60815_()) {
            posFire = posFire.m_7494_();
        }
        if (isPowered && !((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            if (this.setFire(worldIn, posFire, false) && worldIn.f_46443_) {
                SoundUtil.playSound((Level)worldIn, (BlockPos)pos, (SoundEvent)SoundEvents.f_11942_);
            }
        } else if (!isPowered && ((Boolean)state.m_61143_((Property)LIT)).booleanValue() && this.setFire(worldIn, posFire, true)) {
            worldIn.m_46796_(1009, pos, 0);
        }
        worldIn.m_46597_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(isPowered)));
        super.m_6861_(state, worldIn, pos, blockIn, fromPos, isMoving);
    }

    private boolean setFire(Level worldIn, BlockPos pos, boolean extinguish) {
        BlockState state = worldIn.m_8055_(pos);
        if ((state.m_60734_() == Blocks.f_50683_ || state.m_60734_() == Blocks.f_50684_) && extinguish == (Boolean)state.m_61143_((Property)CampfireBlock.f_51227_)) {
            return worldIn.m_46597_(pos, (BlockState)state.m_61124_((Property)CampfireBlock.f_51227_, (Comparable)Boolean.valueOf(!extinguish)));
        }
        if (extinguish && this.canExtinguish(worldIn, pos)) {
            return worldIn.m_46597_(pos, Blocks.f_50016_.m_49966_());
        }
        if (extinguish && this.canExtinguishInfiniteFire(worldIn, pos)) {
            return worldIn.m_46597_(pos.m_121945_(Direction.UP), Blocks.f_50016_.m_49966_());
        }
        if (!extinguish && this.canSetFire(worldIn, pos)) {
            return worldIn.m_46597_(pos, Blocks.f_50083_.m_49966_());
        }
        if (!extinguish && this.canSetInfiniteFire(worldIn, pos)) {
            return worldIn.m_46597_(pos.m_121945_(Direction.UP), Blocks.f_50083_.m_49966_());
        }
        return false;
    }

    private boolean canSetFire(Level worldIn, BlockPos pos) {
        return worldIn.m_46859_(pos) && worldIn.m_8055_(pos.m_121945_(Direction.DOWN)).m_60815_();
    }

    private boolean canSetInfiniteFire(Level worldIn, BlockPos pos) {
        return worldIn.m_46859_(pos.m_121945_(Direction.UP)) && this.hasInfiniburnTag(worldIn, pos);
    }

    private boolean canExtinguish(Level worldIn, BlockPos pos) {
        return worldIn.m_8055_(pos).m_60734_() == Blocks.f_50083_;
    }

    private boolean canExtinguishInfiniteFire(Level worldIn, BlockPos pos) {
        return this.hasInfiniburnTag(worldIn, pos) && this.canExtinguish(worldIn, pos.m_121945_(Direction.UP));
    }

    private boolean hasInfiniburnTag(Level worldIn, BlockPos pos) {
        BlockState state = worldIn.m_8055_(pos);
        return state.m_204336_(BlockTags.f_13060_) && worldIn.m_46472_() == Level.f_46430_ || state.m_204336_(BlockTags.f_13059_) && worldIn.m_46472_() == Level.f_46429_ || state.m_204336_(BlockTags.f_13058_) && worldIn.m_46472_() == Level.f_46428_;
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
        if (entity != null) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)BlockstatesUtil.getFacingFromEntity((BlockPos)pos, (LivingEntity)entity)), 2);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BlockStateProperties.f_61372_}).m_61104_(new Property[]{LIT});
    }
}

