/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.antipotion;

import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.block.BlockCyclic;
import com.lothrazar.cyclic.block.antipotion.TileAntiBeacon;
import com.lothrazar.cyclic.capabilities.livingentity.LivingEntityCapProvider;
import com.lothrazar.cyclic.capabilities.livingentity.LivingEntityCapabilityStorage;
import com.lothrazar.cyclic.registry.BlockRegistry;
import com.lothrazar.cyclic.registry.TileRegistry;
import com.lothrazar.library.util.EntityUtil;
import com.lothrazar.library.util.StringParseUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;

public class BlockAntiBeacon
extends BlockCyclic {
    private static final float[] COLOR = new float[]{1.0f, 1.0f, 1.0f};

    public BlockAntiBeacon(BlockBehaviour.Properties properties) {
        super(properties.m_60977_().m_60978_(0.7f).m_60955_());
    }

    public float[] getBeaconColorMultiplier(BlockState state, LevelReader level, BlockPos pos, BlockPos beaconPos) {
        return COLOR;
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public boolean shouldDisplayFluidOverlay(BlockState state, BlockAndTintGetter world, BlockPos pos, FluidState fluidState) {
        return true;
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TileAntiBeacon(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return BlockAntiBeacon.createTickerHelper(type, (BlockEntityType)((BlockEntityType)TileRegistry.ANTI_BEACON.get()), (BlockEntityTicker)(world.f_46443_ ? TileAntiBeacon::clientTick : TileAntiBeacon::serverTick));
    }

    public void m_6807_(BlockState bs, Level world, BlockPos pos, BlockState bsIn, boolean p_56815_) {
        if (!bsIn.m_60713_(bs.m_60734_())) {
            BlockAntiBeacon.absorbPotions(world, pos);
        }
    }

    public static void absorbPotions(Level world, BlockPos pos) {
        List all = world.m_45976_(LivingEntity.class, EntityUtil.makeBoundingBox((BlockPos)pos, (int)((Integer)TileAntiBeacon.RADIUS.get()), (int)3));
        for (LivingEntity e : all) {
            BlockAntiBeacon.cureAllRelevant(e);
        }
    }

    public static void markNearbyEntitiesWithAntiBeaconPosition(Level world, BlockPos pos) {
        List all = world.m_45976_(LivingEntity.class, EntityUtil.makeBoundingBox((BlockPos)pos, (int)((Integer)TileAntiBeacon.RADIUS.get()), (int)((Integer)TileAntiBeacon.RADIUS.get())));
        for (LivingEntity e : all) {
            LivingEntityCapabilityStorage livingEntityData = (LivingEntityCapabilityStorage)e.getCapability(LivingEntityCapProvider.CYCLIC_LIVING_ENTITY).orElse(null);
            if (livingEntityData == null) continue;
            BlockPos oldPosition = livingEntityData.getClosestAntiBeaconPosition();
            if (oldPosition != null && world.m_8055_(oldPosition).m_60713_((Block)BlockRegistry.ANTI_BEACON.get())) {
                int oldDistance = e.m_20183_().m_123333_((Vec3i)oldPosition);
                int newDistance = e.m_20183_().m_123333_((Vec3i)pos);
                if (newDistance >= oldDistance) continue;
                livingEntityData.setClosestAntiBeaconPosition(pos);
                continue;
            }
            livingEntityData.setClosestAntiBeaconPosition(pos);
        }
    }

    private static void cureAllRelevant(LivingEntity e) {
        ArrayList<MobEffect> cureMe = new ArrayList<MobEffect>();
        for (MobEffect mobEffect : e.m_21221_().keySet()) {
            if (!BlockAntiBeacon.doesConfigBlockEffect(mobEffect)) continue;
            cureMe.add(mobEffect);
        }
        for (MobEffect curedEffect : cureMe) {
            ModCyclic.LOGGER.info("[potion cured] " + curedEffect);
            e.m_21195_(curedEffect);
        }
    }

    private static boolean doesConfigBlockEffect(MobEffect mobEffect) {
        if (((Boolean)TileAntiBeacon.HARMFUL_POTIONS.get()).booleanValue() && mobEffect.m_19483_() == MobEffectCategory.HARMFUL) {
            return true;
        }
        ResourceLocation potionId = ForgeRegistries.MOB_EFFECTS.getKey((Object)mobEffect);
        return StringParseUtil.isInList((List)((List)TileAntiBeacon.POTIONS.get()), (ResourceLocation)potionId);
    }

    public void isPotionApplicable(MobEffectEvent.Applicable event) {
        ServerLevel serverLevel;
        Level level;
        if (event.getEffectInstance() == null) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (BlockAntiBeacon.doesConfigBlockEffect(event.getEffectInstance().m_19544_()) && (level = livingEntity.m_20193_()) instanceof ServerLevel && (serverLevel = (ServerLevel)level).m_46749_(livingEntity.m_20183_())) {
            LivingEntityCapabilityStorage livingEntityData = (LivingEntityCapabilityStorage)livingEntity.getCapability(LivingEntityCapProvider.CYCLIC_LIVING_ENTITY).orElse(null);
            if (livingEntityData == null) {
                return;
            }
            BlockPos closestAntiBeacon = livingEntityData.getClosestAntiBeaconPosition();
            if (closestAntiBeacon == null) {
                return;
            }
            if (livingEntity.m_20183_().m_123333_((Vec3i)closestAntiBeacon) > (Integer)TileAntiBeacon.RADIUS.get()) {
                livingEntityData.setClosestAntiBeaconPosition(null);
                return;
            }
            if (!serverLevel.m_8055_(closestAntiBeacon).m_60734_().equals((Object)this)) {
                livingEntityData.setClosestAntiBeaconPosition(null);
                return;
            }
            boolean isPowered = false;
            if (serverLevel.m_276867_(closestAntiBeacon)) {
                return;
            }
            ModCyclic.LOGGER.info("[potion blocked] " + event.getEffectInstance());
            event.setResult(Event.Result.DENY);
        }
    }
}

