/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.enderctrl;

import com.lothrazar.cyclic.block.TileBlockEntityCyclic;
import com.lothrazar.cyclic.block.enderctrl.EnderControllerItemHandler;
import com.lothrazar.cyclic.block.endershelf.TileEnderShelf;
import com.lothrazar.cyclic.registry.TileRegistry;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;

public class TileEnderCtrl
extends TileBlockEntityCyclic {
    private static final String NBT_SHELVES = "shelves";
    EnderControllerItemHandler controllerInv = new EnderControllerItemHandler(this);
    private final LazyOptional<EnderControllerItemHandler> controllerInventoryCap = LazyOptional.of(() -> this.controllerInv);
    private List<BlockPos> connectedShelves = new ArrayList<BlockPos>();
    TileEnderShelf.RenderTextType renderStyle = TileEnderShelf.RenderTextType.TEXT;

    public TileEnderCtrl(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileRegistry.ENDER_CONTROLLER.get(), pos, state);
    }

    @Override
    public void setField(int field, int value) {
    }

    @Override
    public int getField(int field) {
        return 0;
    }

    public void setAndSort(Set<BlockPos> shelvesIn) {
        this.connectedShelves = shelvesIn.stream().sorted(Comparator.comparing(o -> o.m_123331_((Vec3i)this.f_58858_))).collect(Collectors.toList());
    }

    public List<BlockPos> getShelves() {
        if (this.connectedShelves == null) {
            this.connectedShelves = new ArrayList<BlockPos>();
        }
        return this.connectedShelves;
    }

    public void invalidateCaps() {
        this.controllerInventoryCap.invalidate();
        super.invalidateCaps();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.controllerInventoryCap.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        if (tag.m_128441_("RenderTextType")) {
            int rt = tag.m_128451_("RenderTextType");
            this.renderStyle = TileEnderShelf.RenderTextType.values()[rt];
        }
        if (tag.m_128441_(NBT_SHELVES)) {
            ListTag shelves = tag.m_128437_(NBT_SHELVES, 10);
            for (int i = 0; i < shelves.size(); ++i) {
                BlockPos pos = NbtUtils.m_129239_((CompoundTag)shelves.m_128728_(i));
                this.connectedShelves.add(pos);
            }
        }
        super.m_142466_(tag);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        tag.m_128405_("RenderTextType", this.renderStyle.ordinal());
        ListTag shelves = new ListTag();
        for (BlockPos pos : this.connectedShelves) {
            shelves.add((Object)NbtUtils.m_129224_((BlockPos)pos));
        }
        tag.m_128365_(NBT_SHELVES, (Tag)shelves);
        super.m_183515_(tag);
    }

    public void toggleShowText() {
        int ord = this.renderStyle.ordinal() + 1;
        if (ord == TileEnderShelf.RenderTextType.values().length) {
            ord = 0;
        }
        this.renderStyle = TileEnderShelf.RenderTextType.values()[ord];
    }
}

